/*
 * Decompiled with CFR 0.152.
 */
package mockwebserver3.internal;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import mockwebserver3.internal.SleepNanosKt;
import okio.Buffer;
import okio.Sink;
import okio.Timeout;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\t\u0010\b\u001a\u00020\tH\u0096\u0001J\t\u0010\n\u001a\u00020\tH\u0096\u0001J\t\u0010\u000b\u001a\u00020\fH\u0096\u0001J\u0018\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0004H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lmockwebserver3/internal/ThrottledSink;", "Lokio/Sink;", "delegate", "bytesPerPeriod", "", "periodDelayNanos", "(Lokio/Sink;JJ)V", "bytesWrittenSinceLastDelay", "close", "", "flush", "timeout", "Lokio/Timeout;", "write", "source", "Lokio/Buffer;", "byteCount", "mockwebserver3"})
public final class ThrottledSink
implements Sink {
    @NotNull
    private final Sink delegate;
    private final long bytesPerPeriod;
    private final long periodDelayNanos;
    private long bytesWrittenSinceLastDelay;

    public ThrottledSink(@NotNull Sink delegate, long bytesPerPeriod, long periodDelayNanos) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        this.delegate = delegate;
        this.bytesPerPeriod = bytesPerPeriod;
        this.periodDelayNanos = periodDelayNanos;
    }

    public void close() {
        this.delegate.close();
    }

    public void flush() {
        this.delegate.flush();
    }

    @NotNull
    public Timeout timeout() {
        return this.delegate.timeout();
    }

    public void write(@NotNull Buffer source, long byteCount) {
        long toWrite;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        for (long bytesLeft = byteCount; bytesLeft > 0L; bytesLeft -= toWrite) {
            if (this.bytesWrittenSinceLastDelay == this.bytesPerPeriod) {
                this.flush();
                SleepNanosKt.sleepNanos(this.periodDelayNanos);
                this.bytesWrittenSinceLastDelay = 0L;
            }
            toWrite = Math.min(bytesLeft, this.bytesPerPeriod - this.bytesWrittenSinceLastDelay);
            this.bytesWrittenSinceLastDelay += toWrite;
            this.delegate.write(source, toWrite);
        }
    }
}

