/*
 * Decompiled with CFR 0.152.
 */
package mockwebserver3.internal;

import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.ProtocolException;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import mockwebserver3.RecordedRequest;
import mockwebserver3.internal.MockWebServerSocket;
import mockwebserver3.internal.RequestLine;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u001a^\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0000\u001a\u0012\u0010\u0013\u001a\u00020\u00032\b\u0010\u0002\u001a\u0004\u0018\u00010\u0014H\u0000\u001a \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\"\u0014\u0010\u0015\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0014\u0010\u0018\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0017\u00a8\u0006\u001c"}, d2={"RecordedRequest", "Lmockwebserver3/RecordedRequest;", "requestLine", "Lmockwebserver3/internal/RequestLine;", "headers", "Lokhttp3/Headers;", "chunkSizes", "", "", "bodySize", "", "body", "Lokio/ByteString;", "connectionIndex", "exchangeIndex", "socket", "Lmockwebserver3/internal/MockWebServerSocket;", "failure", "Ljava/io/IOException;", "decodeRequestLine", "", "DEFAULT_REQUEST_LINE_HTTP_1", "getDEFAULT_REQUEST_LINE_HTTP_1", "()Lmockwebserver3/internal/RequestLine;", "DEFAULT_REQUEST_LINE_HTTP_2", "getDEFAULT_REQUEST_LINE_HTTP_2", "requestUrl", "Lokhttp3/HttpUrl;", "mockwebserver3"})
public final class RecordedRequestFactoryKt {
    @NotNull
    private static final RequestLine DEFAULT_REQUEST_LINE_HTTP_1 = new RequestLine("GET", "/", "HTTP/1.1");
    @NotNull
    private static final RequestLine DEFAULT_REQUEST_LINE_HTTP_2 = new RequestLine("GET", "/", "HTTP/2");

    @NotNull
    public static final RecordedRequest RecordedRequest(@NotNull RequestLine requestLine, @NotNull Headers headers, @Nullable List<Integer> chunkSizes, long bodySize, @Nullable ByteString body, int connectionIndex, int exchangeIndex, @NotNull MockWebServerSocket socket, @Nullable IOException failure) {
        Intrinsics.checkNotNullParameter((Object)requestLine, (String)"requestLine");
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
        HttpUrl httpUrl = Intrinsics.areEqual((Object)requestLine.getMethod(), (Object)"CONNECT") ? HttpUrl.Companion.parse(socket.getScheme() + "://" + requestLine.getTarget() + '/') : null;
        if (httpUrl == null && (httpUrl = HttpUrl.Companion.parse(requestLine.getTarget())) == null) {
            httpUrl = RecordedRequestFactoryKt.requestUrl(socket, requestLine, headers);
        }
        HttpUrl requestUrl = httpUrl;
        return new RecordedRequest(connectionIndex, exchangeIndex, socket.getHandshake(), socket.getHandshakeServerNames(), requestLine.getMethod(), requestLine.getTarget(), requestLine.getVersion(), requestUrl, headers, body, bodySize, chunkSizes, failure);
    }

    public static /* synthetic */ RecordedRequest RecordedRequest$default(RequestLine requestLine, Headers headers, List list, long l, ByteString byteString, int n, int n2, MockWebServerSocket mockWebServerSocket, IOException iOException, int n3, Object object) {
        if ((n3 & 0x100) != 0) {
            iOException = null;
        }
        return RecordedRequestFactoryKt.RecordedRequest(requestLine, headers, list, l, byteString, n, n2, mockWebServerSocket, iOException);
    }

    @NotNull
    public static final RequestLine decodeRequestLine(@Nullable String requestLine) {
        String string = requestLine;
        if (string == null) {
            return DEFAULT_REQUEST_LINE_HTTP_1;
        }
        char[] cArray = new char[]{' '};
        List parts = StringsKt.split$default((CharSequence)string, (char[])cArray, (boolean)false, (int)3, (int)2, null);
        if (parts.size() != 3) {
            throw new ProtocolException("unexpected request line: " + requestLine);
        }
        return new RequestLine((String)parts.get(0), (String)parts.get(1), (String)parts.get(2));
    }

    @NotNull
    public static final RequestLine getDEFAULT_REQUEST_LINE_HTTP_1() {
        return DEFAULT_REQUEST_LINE_HTTP_1;
    }

    @NotNull
    public static final RequestLine getDEFAULT_REQUEST_LINE_HTTP_2() {
        return DEFAULT_REQUEST_LINE_HTTP_2;
    }

    private static final HttpUrl requestUrl(MockWebServerSocket socket, RequestLine requestLine, Headers headers) {
        String string = headers.get(":authority");
        if (string == null && (string = headers.get("Host")) == null) {
            InetAddress inetAddress = socket.getLocalAddress();
            string = inetAddress instanceof Inet6Address ? '[' + ((Inet6Address)inetAddress).getHostAddress() + "]:" + socket.getLocalPort() : inetAddress.getHostAddress() + ':' + socket.getLocalPort();
        }
        String hostAndPort = string;
        String path = Intrinsics.areEqual((Object)requestLine.getMethod(), (Object)"OPTIONS") && Intrinsics.areEqual((Object)requestLine.getTarget(), (Object)"*") ? "/" : requestLine.getTarget();
        return HttpUrl.Companion.get(socket.getScheme() + "://" + hostAndPort + path);
    }
}

