/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.dnsoverhttps;

import java.io.EOFException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okio.Buffer;
import okio.ByteString;
import okio.Utf8;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0007J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lokhttp3/dnsoverhttps/DnsRecordCodec;", "", "()V", "ASCII", "Ljava/nio/charset/Charset;", "kotlin.jvm.PlatformType", "NXDOMAIN", "", "SERVFAIL", "TYPE_A", "TYPE_AAAA", "TYPE_PTR", "decodeAnswers", "", "Ljava/net/InetAddress;", "hostname", "", "byteString", "Lokio/ByteString;", "encodeQuery", "host", "type", "skipName", "", "source", "Lokio/Buffer;", "okhttp-dnsoverhttps"})
@SourceDebugExtension(value={"SMAP\nDnsRecordCodec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DnsRecordCodec.kt\nokhttp3/dnsoverhttps/DnsRecordCodec\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,128:1\n731#2,9:129\n1#3:138\n*S KotlinDebug\n*F\n+ 1 DnsRecordCodec.kt\nokhttp3/dnsoverhttps/DnsRecordCodec\n*L\n46#1:129,9\n*E\n"})
public final class DnsRecordCodec {
    @NotNull
    public static final DnsRecordCodec INSTANCE = new DnsRecordCodec();
    private static final int SERVFAIL = 2;
    private static final int NXDOMAIN = 3;
    public static final int TYPE_A = 1;
    public static final int TYPE_AAAA = 28;
    private static final int TYPE_PTR = 12;
    private static final Charset ASCII = StandardCharsets.US_ASCII;

    private DnsRecordCodec() {
    }

    @NotNull
    public final ByteString encodeQuery(@NotNull String host, int type) {
        List list;
        Buffer buffer;
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Buffer $this$encodeQuery_u24lambda_u242 = buffer = new Buffer();
        boolean bl = false;
        $this$encodeQuery_u24lambda_u242.writeShort(0);
        $this$encodeQuery_u24lambda_u242.writeShort(256);
        $this$encodeQuery_u24lambda_u242.writeShort(1);
        $this$encodeQuery_u24lambda_u242.writeShort(0);
        $this$encodeQuery_u24lambda_u242.writeShort(0);
        $this$encodeQuery_u24lambda_u242.writeShort(0);
        Buffer nameBuf = new Buffer();
        Object object = new char[]{'.'};
        List $this$dropLastWhile$iv = StringsKt.split$default((CharSequence)host, (char[])object, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl2 = false;
                if (((CharSequence)it).length() == 0) continue;
                list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        List labels = list;
        object = labels.iterator();
        while (object.hasNext()) {
            String label = (String)object.next();
            long utf8ByteCount = Utf8.size$default((String)label, (int)0, (int)0, (int)3, null);
            if (!(utf8ByteCount == (long)label.length())) {
                boolean bl3 = false;
                String string = "non-ascii hostname: " + host;
                throw new IllegalArgumentException(string.toString());
            }
            nameBuf.writeByte((int)utf8ByteCount);
            nameBuf.writeUtf8(label);
        }
        nameBuf.writeByte(0);
        nameBuf.copyTo($this$encodeQuery_u24lambda_u242, 0L, nameBuf.size());
        $this$encodeQuery_u24lambda_u242.writeShort(type);
        $this$encodeQuery_u24lambda_u242.writeShort(1);
        return buffer.readByteString();
    }

    @NotNull
    public final List<InetAddress> decodeAnswers(@NotNull String hostname, @NotNull ByteString byteString) throws Exception {
        int i;
        Intrinsics.checkNotNullParameter((Object)hostname, (String)"hostname");
        Intrinsics.checkNotNullParameter((Object)byteString, (String)"byteString");
        List result = new ArrayList();
        Buffer buf = new Buffer();
        buf.write(byteString);
        buf.readShort();
        int flags = buf.readShort() & 0xFFFF;
        if (!(flags >> 15 != 0)) {
            boolean $i$a$-require-DnsRecordCodec$decodeAnswers$22 = false;
            String $i$a$-require-DnsRecordCodec$decodeAnswers$22 = "not a response";
            throw new IllegalArgumentException($i$a$-require-DnsRecordCodec$decodeAnswers$22.toString());
        }
        int responseCode = flags & 0xF;
        switch (responseCode) {
            case 3: {
                throw new UnknownHostException(hostname + ": NXDOMAIN");
            }
            case 2: {
                throw new UnknownHostException(hostname + ": SERVFAIL");
            }
        }
        int questionCount = buf.readShort() & 0xFFFF;
        int answerCount = buf.readShort() & 0xFFFF;
        buf.readShort();
        buf.readShort();
        for (i = 0; i < questionCount; ++i) {
            this.skipName(buf);
            buf.readShort();
            buf.readShort();
        }
        block8: for (i = 0; i < answerCount; ++i) {
            this.skipName(buf);
            int type = buf.readShort() & 0xFFFF;
            buf.readShort();
            long ttl = (long)buf.readInt() & 0xFFFFFFFFL;
            int length = buf.readShort() & 0xFFFF;
            switch (type) {
                case 1: 
                case 28: {
                    byte[] bytes = new byte[length];
                    buf.read(bytes);
                    InetAddress inetAddress = InetAddress.getByAddress(bytes);
                    Intrinsics.checkNotNullExpressionValue((Object)inetAddress, (String)"getByAddress(bytes)");
                    result.add(inetAddress);
                    continue block8;
                }
                default: {
                    buf.skip((long)length);
                }
            }
        }
        return result;
    }

    private final void skipName(Buffer source) throws EOFException {
        byte length = source.readByte();
        if (length < 0) {
            source.skip(1L);
        } else {
            while (length > 0) {
                source.skip((long)length);
                length = source.readByte();
            }
        }
    }
}

