/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.sse;

import java.io.IOException;
import javax.annotation.Nullable;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;

public final class ServerSentEventReader {
    private static final ByteString CRLF = ByteString.encodeUtf8((String)"\r\n");
    private static final ByteString DATA = ByteString.encodeUtf8((String)"data");
    private static final ByteString ID = ByteString.encodeUtf8((String)"id");
    private static final ByteString EVENT = ByteString.encodeUtf8((String)"event");
    private static final ByteString RETRY = ByteString.encodeUtf8((String)"retry");
    private final BufferedSource source;
    private final Callback callback;
    private String lastId = null;

    public ServerSentEventReader(BufferedSource source, Callback callback) {
        if (source == null) {
            throw new NullPointerException("source == null");
        }
        if (callback == null) {
            throw new NullPointerException("callback == null");
        }
        this.source = source;
        this.callback = callback;
    }

    boolean processNextEvent() throws IOException {
        String id = this.lastId;
        String type = null;
        Buffer data = new Buffer();
        long lineEnd;
        block7: while ((lineEnd = this.source.indexOfElement(CRLF)) != -1L) {
            switch (this.source.buffer().getByte(0L)) {
                case 10: 
                case 13: {
                    this.completeEvent(id, type, data);
                    return true;
                }
                case 100: {
                    if (!this.isKey(DATA)) break;
                    this.parseData(data, lineEnd);
                    continue block7;
                }
                case 101: {
                    if (!this.isKey(EVENT)) break;
                    type = this.parseEvent(lineEnd);
                    continue block7;
                }
                case 105: {
                    if (!this.isKey(ID)) break;
                    id = this.parseId(lineEnd);
                    continue block7;
                }
                case 114: {
                    if (!this.isKey(RETRY)) break;
                    this.parseRetry(lineEnd);
                    continue block7;
                }
            }
            this.source.skip(lineEnd);
            this.skipCrAndOrLf();
        }
        return false;
    }

    private void completeEvent(String id, String type, Buffer data) throws IOException {
        this.skipCrAndOrLf();
        if (data.size() != 0L) {
            this.lastId = id;
            data.skip(1L);
            this.callback.onEvent(id, type, data.readUtf8());
        }
    }

    private void parseData(Buffer data, long end) throws IOException {
        data.writeByte(10);
        this.source.readFully(data, end -= this.skipNameAndDivider(4L));
        this.skipCrAndOrLf();
    }

    private String parseEvent(long end) throws IOException {
        String type = null;
        if ((end -= this.skipNameAndDivider(5L)) != 0L) {
            type = this.source.readUtf8(end);
        }
        this.skipCrAndOrLf();
        return type;
    }

    private String parseId(long end) throws IOException {
        String id = (end -= this.skipNameAndDivider(2L)) != 0L ? this.source.readUtf8(end) : null;
        this.skipCrAndOrLf();
        return id;
    }

    private void parseRetry(long end) throws IOException {
        String retryString = this.source.readUtf8(end -= this.skipNameAndDivider(5L));
        long retryMs = -1L;
        try {
            retryMs = Long.parseLong(retryString);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (retryMs != -1L) {
            this.callback.onRetryChange(retryMs);
        }
        this.skipCrAndOrLf();
    }

    private boolean isKey(ByteString key) throws IOException {
        if (this.source.rangeEquals(0L, key)) {
            byte nextByte = this.source.buffer().getByte((long)key.size());
            return nextByte == 58 || nextByte == 13 || nextByte == 10;
        }
        return false;
    }

    private void skipCrAndOrLf() throws IOException {
        if ((this.source.readByte() & 0xFF) == 13 && this.source.request(1L) && this.source.buffer().getByte(0L) == 10) {
            this.source.skip(1L);
        }
    }

    private long skipNameAndDivider(long length) throws IOException {
        this.source.skip(length);
        if (this.source.buffer().getByte(0L) == 58) {
            this.source.skip(1L);
            ++length;
            if (this.source.buffer().getByte(0L) == 32) {
                this.source.skip(1L);
                ++length;
            }
        }
        return length;
    }

    public static interface Callback {
        public void onEvent(@Nullable String var1, @Nullable String var2, String var3);

        public void onRetryChange(long var1);
    }
}

