/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.HttpUrl;
import org.assertj.core.api.Assertions;

public final class RecordingCookieJar
implements CookieJar {
    private final Deque<List<Cookie>> requestCookies = new ArrayDeque<List<Cookie>>();
    private final Deque<List<Cookie>> responseCookies = new ArrayDeque<List<Cookie>>();

    public void enqueueRequestCookies(Cookie ... cookies) {
        this.requestCookies.add(Arrays.asList(cookies));
    }

    public List<Cookie> takeResponseCookies() {
        return this.responseCookies.removeFirst();
    }

    public void assertResponseCookies(String ... cookies) {
        List<Cookie> actualCookies = this.takeResponseCookies();
        ArrayList<String> actualCookieStrings = new ArrayList<String>();
        for (Cookie cookie : actualCookies) {
            actualCookieStrings.add(cookie.toString());
        }
        Assertions.assertThat(actualCookieStrings).containsExactly((Object[])cookies);
    }

    public void saveFromResponse(HttpUrl url, List<Cookie> cookies) {
        this.responseCookies.add(cookies);
    }

    public List<Cookie> loadForRequest(HttpUrl url) {
        if (this.requestCookies.isEmpty()) {
            return Collections.emptyList();
        }
        return this.requestCookies.removeFirst();
    }
}

