/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.testing;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.RunListener;

public class InstallUncaughtExceptionHandlerListener
extends RunListener {
    private Thread.UncaughtExceptionHandler oldDefaultUncaughtExceptionHandler;
    private Description lastTestStarted;

    public void testRunStarted(Description description) throws Exception {
        System.err.println("Installing aggressive uncaught exception handler");
        this.oldDefaultUncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread, Throwable throwable) {
                StringWriter errorText = new StringWriter(256);
                errorText.append("Uncaught exception in OkHttp thread \"");
                errorText.append(thread.getName());
                errorText.append("\"\n");
                throwable.printStackTrace(new PrintWriter(errorText));
                errorText.append("\n");
                if (InstallUncaughtExceptionHandlerListener.this.lastTestStarted != null) {
                    errorText.append("Last test to start was: ");
                    errorText.append(InstallUncaughtExceptionHandlerListener.this.lastTestStarted.getDisplayName());
                    errorText.append("\n");
                }
                System.err.print(errorText.toString());
                System.exit(-1);
            }
        });
    }

    public void testStarted(Description description) throws Exception {
        this.lastTestStarted = description;
    }

    public void testRunFinished(Result result) throws Exception {
        Thread.setDefaultUncaughtExceptionHandler(this.oldDefaultUncaughtExceptionHandler);
        System.err.println("Uninstalled aggressive uncaught exception handler");
    }
}

