/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.tls.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.tls.HandshakeCertificates;
import okhttp3.tls.HeldCertificate;

public final class TlsUtil {
    public static final char[] password = "password".toCharArray();
    private static HandshakeCertificates localhost;

    private TlsUtil() {
    }

    public static synchronized HandshakeCertificates localhost() {
        if (localhost != null) {
            return localhost;
        }
        try {
            HeldCertificate heldCertificate = new HeldCertificate.Builder().commonName("localhost").addSubjectAlternativeName(InetAddress.getByName("localhost").getCanonicalHostName()).build();
            localhost = new HandshakeCertificates.Builder().heldCertificate(heldCertificate, new X509Certificate[0]).addTrustedCertificate(heldCertificate.certificate()).build();
            return localhost;
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    public static X509TrustManager newTrustManager(String keyStoreType, List<X509Certificate> trustedCertificates) throws GeneralSecurityException {
        KeyStore trustStore = TlsUtil.newEmptyKeyStore(keyStoreType);
        for (int i = 0; i < trustedCertificates.size(); ++i) {
            trustStore.setCertificateEntry("cert_" + i, trustedCertificates.get(i));
        }
        TrustManagerFactory factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        factory.init(trustStore);
        Object[] result = factory.getTrustManagers();
        if (result.length != 1 || !(result[0] instanceof X509TrustManager)) {
            throw new IllegalStateException("Unexpected trust managers:" + Arrays.toString(result));
        }
        return (X509TrustManager)result[0];
    }

    public static X509KeyManager newKeyManager(String keyStoreType, HeldCertificate heldCertificate, X509Certificate ... intermediates) throws GeneralSecurityException {
        KeyStore keyStore = TlsUtil.newEmptyKeyStore(keyStoreType);
        if (heldCertificate != null) {
            Certificate[] chain = new Certificate[1 + intermediates.length];
            chain[0] = heldCertificate.certificate();
            System.arraycopy(intermediates, 0, chain, 1, intermediates.length);
            keyStore.setKeyEntry("private", heldCertificate.keyPair().getPrivate(), password, chain);
        }
        KeyManagerFactory factory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        factory.init(keyStore, password);
        Object[] result = factory.getKeyManagers();
        if (result.length != 1 || !(result[0] instanceof X509KeyManager)) {
            throw new IllegalStateException("Unexpected key managers:" + Arrays.toString(result));
        }
        return (X509KeyManager)result[0];
    }

    private static KeyStore newEmptyKeyStore(String keyStoreType) throws GeneralSecurityException {
        if (keyStoreType == null) {
            keyStoreType = KeyStore.getDefaultType();
        }
        try {
            KeyStore keyStore = KeyStore.getInstance(keyStoreType);
            InputStream in = null;
            keyStore.load(in, password);
            return keyStore;
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }
}

