/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.tls;

import java.security.GeneralSecurityException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import okio.Buffer;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0002*\u00020\u0001\u001a\u0018\u0010\u0004\u001a\u00020\u0005*\u00060\u0006j\u0002`\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u00a8\u0006\n"}, d2={"certificatePem", "", "Ljava/security/cert/X509Certificate;", "decodeCertificatePem", "encodeBase64Lines", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "data", "Lokio/ByteString;", "okhttp-tls"})
@JvmName(name="Certificates")
public final class Certificates {
    @NotNull
    public static final X509Certificate decodeCertificatePem(@NotNull String $this$decodeCertificatePem) {
        Intrinsics.checkNotNullParameter((Object)$this$decodeCertificatePem, (String)"<this>");
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            Collection<? extends Certificate> certificates = certificateFactory.generateCertificates(new Buffer().writeUtf8($this$decodeCertificatePem).inputStream());
            Intrinsics.checkNotNullExpressionValue(certificates, (String)"certificates");
            Object object = CollectionsKt.single((Iterable)certificates);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.security.cert.X509Certificate");
            return (X509Certificate)object;
        }
        catch (NoSuchElementException nsee) {
            throw new IllegalArgumentException("failed to decode certificate", nsee);
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException("failed to decode certificate", iae);
        }
        catch (GeneralSecurityException e) {
            throw new IllegalArgumentException("failed to decode certificate", e);
        }
    }

    @NotNull
    public static final String certificatePem(@NotNull X509Certificate $this$certificatePem) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$certificatePem, (String)"<this>");
        StringBuilder $this$certificatePem_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$certificatePem_u24lambda_u240.append("-----BEGIN CERTIFICATE-----\n");
        byte[] byArray = $this$certificatePem.getEncoded();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"encoded");
        Certificates.encodeBase64Lines($this$certificatePem_u24lambda_u240, ByteString.Companion.of$default((ByteString.Companion)ByteString.Companion, (byte[])byArray, (int)0, (int)0, (int)3, null));
        $this$certificatePem_u24lambda_u240.append("-----END CERTIFICATE-----\n");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    public static final void encodeBase64Lines(@NotNull StringBuilder $this$encodeBase64Lines, @NotNull ByteString data) {
        Intrinsics.checkNotNullParameter((Object)$this$encodeBase64Lines, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        String base64 = data.base64();
        IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)base64.length())), (int)64);
        int i = intProgression.getFirst();
        int n = intProgression.getLast();
        int n2 = intProgression.getStep();
        if (n2 > 0 && i <= n || n2 < 0 && n <= i) {
            while (true) {
                $this$encodeBase64Lines.append(base64, i, Math.min(i + 64, base64.length())).append('\n');
                if (i == n) break;
                i += n2;
            }
        }
    }
}

