/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.io.IOException;
import java.net.Authenticator;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Authenticator;
import okhttp3.Challenge;
import okhttp3.Credentials;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0014\u0010\t\u001a\u00020\n*\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"Lokhttp3/JavaNetAuthenticator;", "Lokhttp3/Authenticator;", "()V", "authenticate", "Lokhttp3/Request;", "route", "Lokhttp3/Route;", "response", "Lokhttp3/Response;", "connectToInetAddress", "Ljava/net/InetAddress;", "Ljava/net/Proxy;", "url", "Lokhttp3/HttpUrl;", "okhttp-urlconnection"})
public final class JavaNetAuthenticator
implements Authenticator {
    @Nullable
    public Request authenticate(@Nullable Route route, @NotNull Response response) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
        List challenges = response.challenges();
        Request request = response.request();
        HttpUrl url = request.url();
        boolean proxyAuthorization = response.code() == 407;
        Object object = route;
        if (object == null || (object = object.proxy()) == null) {
            object = Proxy.NO_PROXY;
        }
        Object proxy = object;
        for (Challenge challenge : challenges) {
            PasswordAuthentication auth;
            PasswordAuthentication passwordAuthentication;
            if (!StringsKt.equals((String)"Basic", (String)challenge.scheme(), (boolean)true)) continue;
            if (proxyAuthorization) {
                SocketAddress socketAddress = ((Proxy)proxy).address();
                if (socketAddress == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.net.InetSocketAddress");
                }
                InetSocketAddress proxyAddress = (InetSocketAddress)socketAddress;
                String string = proxyAddress.getHostName();
                Object object2 = proxy;
                Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"proxy");
                passwordAuthentication = java.net.Authenticator.requestPasswordAuthentication(string, this.connectToInetAddress((Proxy)object2, url), proxyAddress.getPort(), url.scheme(), challenge.realm(), challenge.scheme(), url.url(), Authenticator.RequestorType.PROXY);
            } else {
                String string = url.host();
                Object object3 = proxy;
                Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"proxy");
                passwordAuthentication = java.net.Authenticator.requestPasswordAuthentication(string, this.connectToInetAddress((Proxy)object3, url), url.port(), url.scheme(), challenge.realm(), challenge.scheme(), url.url(), Authenticator.RequestorType.SERVER);
            }
            if ((auth = passwordAuthentication) == null) continue;
            String credentialHeader = proxyAuthorization ? "Proxy-Authorization" : "Authorization";
            String string = auth.getUserName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"auth.userName");
            char[] cArray = auth.getPassword();
            Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"auth.password");
            char[] cArray2 = cArray;
            String string2 = string;
            boolean bl = false;
            String string3 = new String(cArray2);
            String credential = Credentials.basic((String)string2, (String)string3, (Charset)challenge.charset());
            return request.newBuilder().header(credentialHeader, credential).build();
        }
        return null;
    }

    private final InetAddress connectToInetAddress(@NotNull Proxy $this$connectToInetAddress, HttpUrl url) throws IOException {
        InetAddress inetAddress;
        if ($this$connectToInetAddress.type() == Proxy.Type.DIRECT) {
            InetAddress inetAddress2 = InetAddress.getByName(url.host());
            inetAddress = inetAddress2;
            Intrinsics.checkExpressionValueIsNotNull((Object)inetAddress2, (String)"InetAddress.getByName(url.host)");
        } else {
            SocketAddress socketAddress = $this$connectToInetAddress.address();
            if (socketAddress == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.net.InetSocketAddress");
            }
            InetAddress inetAddress3 = ((InetSocketAddress)socketAddress).getAddress();
            inetAddress = inetAddress3;
            Intrinsics.checkExpressionValueIsNotNull((Object)inetAddress3, (String)"(address() as InetSocketAddress).address");
        }
        return inetAddress;
    }
}

