/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import okhttp3.MediaType;
import okhttp3.internal.Util;
import okio.BufferedSink;
import okio.ByteString;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\n\u0010\u0005\u001a\u0004\u0018\u00010\u0006H&J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH&\u00a8\u0006\u000f"}, d2={"Lokhttp3/RequestBody;", "", "()V", "contentLength", "", "contentType", "Lokhttp3/MediaType;", "isDuplex", "", "isOneShot", "writeTo", "", "sink", "Lokio/BufferedSink;", "Companion", "okhttp"})
public abstract class RequestBody {
    public static final Companion Companion = new Companion(null);

    @Nullable
    public abstract MediaType contentType();

    public long contentLength() throws IOException {
        return -1L;
    }

    public abstract void writeTo(@NotNull BufferedSink var1) throws IOException;

    public boolean isDuplex() {
        return false;
    }

    public boolean isOneShot() {
        return false;
    }

    @JvmStatic
    @NotNull
    public static final RequestBody create(@Nullable MediaType contentType, @NotNull String content) {
        return Companion.create(contentType, content);
    }

    @JvmStatic
    @NotNull
    public static final RequestBody create(@Nullable MediaType contentType, @NotNull ByteString content) {
        return Companion.create(contentType, content);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final RequestBody create(@Nullable MediaType contentType, @NotNull byte[] content, int offset, int byteCount) {
        return Companion.create(contentType, content, offset, byteCount);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final RequestBody create(@Nullable MediaType contentType, @NotNull byte[] content, int offset) {
        return okhttp3.RequestBody$Companion.create$default(Companion, contentType, content, offset, 0, 8, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final RequestBody create(@Nullable MediaType contentType, @NotNull byte[] content) {
        return okhttp3.RequestBody$Companion.create$default(Companion, contentType, content, 0, 0, 12, null);
    }

    @JvmStatic
    @NotNull
    public static final RequestBody create(@Nullable MediaType contentType, @NotNull File file) {
        return Companion.create(contentType, file);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J.\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\fH\u0007J\u001a\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\u000eH\u0007J\u001a\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\u000fH\u0007\u00a8\u0006\u0010"}, d2={"Lokhttp3/RequestBody$Companion;", "", "()V", "create", "Lokhttp3/RequestBody;", "contentType", "Lokhttp3/MediaType;", "file", "Ljava/io/File;", "content", "", "offset", "", "byteCount", "", "Lokio/ByteString;", "okhttp"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final RequestBody create(@Nullable MediaType contentType, @NotNull String content) {
            Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
            Charset charset = Charsets.UTF_8;
            MediaType finalContentType = contentType;
            if (contentType != null) {
                Charset resolvedCharset = MediaType.charset$default(contentType, null, 1, null);
                if (resolvedCharset == null) {
                    charset = Charsets.UTF_8;
                    finalContentType = MediaType.Companion.parse(contentType + "; charset=utf-8");
                } else {
                    charset = resolvedCharset;
                }
            }
            String string = content;
            boolean bl = false;
            byte[] byArray = string.getBytes(charset);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            byte[] bytes = byArray;
            return okhttp3.RequestBody$Companion.create$default(this, finalContentType, bytes, 0, 0, 12, null);
        }

        @JvmStatic
        @NotNull
        public final RequestBody create(@Nullable MediaType contentType, @NotNull ByteString content) {
            Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
            return new RequestBody(contentType, content){
                final /* synthetic */ MediaType $contentType;
                final /* synthetic */ ByteString $content;

                @Nullable
                public MediaType contentType() {
                    return this.$contentType;
                }

                public long contentLength() {
                    return this.$content.size();
                }

                public void writeTo(@NotNull BufferedSink sink) {
                    Intrinsics.checkParameterIsNotNull((Object)sink, (String)"sink");
                    sink.write(this.$content);
                }
                {
                    this.$contentType = $captured_local_variable$0;
                    this.$content = $captured_local_variable$1;
                }
            };
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final RequestBody create(@Nullable MediaType contentType, @NotNull byte[] content, int offset, int byteCount) {
            Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
            Util.checkOffsetAndCount(content.length, offset, byteCount);
            return new RequestBody(contentType, byteCount, content, offset){
                final /* synthetic */ MediaType $contentType;
                final /* synthetic */ int $byteCount;
                final /* synthetic */ byte[] $content;
                final /* synthetic */ int $offset;

                @Nullable
                public MediaType contentType() {
                    return this.$contentType;
                }

                public long contentLength() {
                    return this.$byteCount;
                }

                public void writeTo(@NotNull BufferedSink sink) {
                    Intrinsics.checkParameterIsNotNull((Object)sink, (String)"sink");
                    sink.write(this.$content, this.$offset, this.$byteCount);
                }
                {
                    this.$contentType = $captured_local_variable$0;
                    this.$byteCount = $captured_local_variable$1;
                    this.$content = $captured_local_variable$2;
                    this.$offset = $captured_local_variable$3;
                }
            };
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public static /* synthetic */ RequestBody create$default(Companion companion, MediaType mediaType, byte[] byArray, int n, int n2, int n3, Object object) {
            if ((n3 & 4) != 0) {
                n = 0;
            }
            if ((n3 & 8) != 0) {
                n2 = byArray.length;
            }
            return companion.create(mediaType, byArray, n, n2);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final RequestBody create(@Nullable MediaType contentType, @NotNull byte[] content, int offset) {
            return okhttp3.RequestBody$Companion.create$default(this, contentType, content, offset, 0, 8, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final RequestBody create(@Nullable MediaType contentType, @NotNull byte[] content) {
            return okhttp3.RequestBody$Companion.create$default(this, contentType, content, 0, 0, 12, null);
        }

        @JvmStatic
        @NotNull
        public final RequestBody create(@Nullable MediaType contentType, @NotNull File file) {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            return new RequestBody(contentType, file){
                final /* synthetic */ MediaType $contentType;
                final /* synthetic */ File $file;

                @Nullable
                public MediaType contentType() {
                    return this.$contentType;
                }

                public long contentLength() {
                    return this.$file.length();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void writeTo(@NotNull BufferedSink sink) {
                    Intrinsics.checkParameterIsNotNull((Object)sink, (String)"sink");
                    Closeable closeable = (Closeable)Okio.source((File)this.$file);
                    boolean bl = false;
                    Throwable throwable = null;
                    try {
                        Source source = (Source)closeable;
                        boolean bl2 = false;
                        long l = sink.writeAll(source);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
                {
                    this.$contentType = $captured_local_variable$0;
                    this.$file = $captured_local_variable$1;
                }
            };
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

