/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Response;
import okhttp3.internal.NamedRunnable;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000R\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\t\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0017\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003H\u0086\b\u001a\u0015\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0005H\u0086\u0004\u001a\u0015\u0010\u0004\u001a\u00020\b*\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0086\u0004\u001a\u0015\u0010\u0004\u001a\u00020\u0005*\u00020\t2\u0006\u0010\u0007\u001a\u00020\u0005H\u0086\u0004\u001a\n\u0010\n\u001a\u00020\u000b*\u00020\f\u001a%\u0010\r\u001a\u00020\u0001*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000b2\u000e\b\u0004\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003H\u0086\b\u001a\n\u0010\u0010\u001a\u00020\b*\u00020\u0011\u001a\u0014\u0010\u0012\u001a\u00020\u0005*\u00020\u000b2\b\b\u0002\u0010\u0013\u001a\u00020\u0005\u001a\n\u0010\u0014\u001a\u00020\u0005*\u00020\u0015\u001a\u0012\u0010\u0016\u001a\u00020\u0005*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0006\u001a\u0012\u0010\u0019\u001a\u00020\b*\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\b\u001a\u0014\u0010\u001b\u001a\u00020\u0005*\u0004\u0018\u00010\u000b2\u0006\u0010\u001a\u001a\u00020\u0005\u001a%\u0010\u001c\u001a\u00020\u0001*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000b2\u000e\b\u0004\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003H\u0086\b\u001a\u0012\u0010\u001d\u001a\u00020\u0001*\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0005\u00a8\u0006 "}, d2={"ignoreIoExceptions", "", "block", "Lkotlin/Function0;", "and", "", "", "mask", "", "", "connectionName", "", "Ljava/net/Socket;", "execute", "Ljava/util/concurrent/Executor;", "name", "headersContentLength", "Lokhttp3/Response;", "indexOfNonWhitespace", "startIndex", "readMedium", "Lokio/BufferedSource;", "skipAll", "Lokio/Buffer;", "b", "toLongOrDefault", "defaultValue", "toNonNegativeInt", "tryExecute", "writeMedium", "Lokio/BufferedSink;", "medium", "okhttp"})
@JvmName(name="UtilKt")
public final class UtilKt {
    public static final int and(byte $this$and, int mask) {
        return $this$and & mask;
    }

    public static final int and(short $this$and, int mask) {
        return $this$and & mask;
    }

    public static final long and(int $this$and, long mask) {
        return (long)$this$and & mask;
    }

    public static final void writeMedium(@NotNull BufferedSink $this$writeMedium, int medium) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)$this$writeMedium, (String)"$this$writeMedium");
        $this$writeMedium.writeByte(medium >>> 16 & 0xFF);
        $this$writeMedium.writeByte(medium >>> 8 & 0xFF);
        $this$writeMedium.writeByte(medium & 0xFF);
    }

    public static final int readMedium(@NotNull BufferedSource $this$readMedium) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)$this$readMedium, (String)"$this$readMedium");
        return UtilKt.and($this$readMedium.readByte(), 255) << 16 | UtilKt.and($this$readMedium.readByte(), 255) << 8 | UtilKt.and($this$readMedium.readByte(), 255);
    }

    @NotNull
    public static final String connectionName(@NotNull Socket $this$connectionName) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)$this$connectionName, (String)"$this$connectionName");
        SocketAddress address = $this$connectionName.getRemoteSocketAddress();
        if (address instanceof InetSocketAddress) {
            String string2 = ((InetSocketAddress)address).getHostName();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"address.hostName");
        } else {
            string = address.toString();
        }
        return string;
    }

    public static final void ignoreIoExceptions(@NotNull Function0<Unit> block) {
        int $i$f$ignoreIoExceptions = 0;
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        try {
            block.invoke();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static final void execute(@NotNull Executor $this$execute, @NotNull String name, @NotNull Function0<Unit> block) {
        int $i$f$execute = 0;
        Intrinsics.checkParameterIsNotNull((Object)$this$execute, (String)"$this$execute");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        $this$execute.execute(new NamedRunnable(block, name, "%s", new Object[]{name}){
            final /* synthetic */ Function0 $block;
            final /* synthetic */ String $name;

            protected void execute() {
                this.$block.invoke();
            }
            {
                this.$block = $captured_local_variable$0;
                this.$name = $captured_local_variable$1;
                super($super_call_param$2, $super_call_param$3);
            }
        });
    }

    public static final void tryExecute(@NotNull Executor $this$tryExecute, @NotNull String name, @NotNull Function0<Unit> block) {
        int $i$f$tryExecute = 0;
        Intrinsics.checkParameterIsNotNull((Object)$this$tryExecute, (String)"$this$tryExecute");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        try {
            Executor $this$execute$iv = $this$tryExecute;
            boolean $i$f$execute = false;
            $this$execute$iv.execute(new /* invalid duplicate definition of identical inner class */);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    public static final int skipAll(@NotNull Buffer $this$skipAll, byte b) {
        Intrinsics.checkParameterIsNotNull((Object)$this$skipAll, (String)"$this$skipAll");
        int count = 0;
        while (!$this$skipAll.exhausted() && $this$skipAll.getByte(0L) == b) {
            ++count;
            $this$skipAll.readByte();
        }
        return count;
    }

    /*
     * WARNING - void declaration
     */
    public static final int indexOfNonWhitespace(@NotNull String $this$indexOfNonWhitespace, int startIndex) {
        Intrinsics.checkParameterIsNotNull((Object)$this$indexOfNonWhitespace, (String)"$this$indexOfNonWhitespace");
        int n = startIndex;
        int n2 = $this$indexOfNonWhitespace.length();
        while (n < n2) {
            void i;
            char c = $this$indexOfNonWhitespace.charAt((int)i);
            if (c != ' ' && c != '\t') {
                return (int)i;
            }
            ++i;
        }
        return $this$indexOfNonWhitespace.length();
    }

    public static /* synthetic */ int indexOfNonWhitespace$default(String string, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return UtilKt.indexOfNonWhitespace(string, n);
    }

    public static final long headersContentLength(@NotNull Response $this$headersContentLength) {
        Intrinsics.checkParameterIsNotNull((Object)$this$headersContentLength, (String)"$this$headersContentLength");
        String string = $this$headersContentLength.headers().get("Content-Length");
        return string != null ? UtilKt.toLongOrDefault(string, -1L) : -1L;
    }

    public static final long toLongOrDefault(@NotNull String $this$toLongOrDefault, long defaultValue) {
        long l;
        Intrinsics.checkParameterIsNotNull((Object)$this$toLongOrDefault, (String)"$this$toLongOrDefault");
        try {
            String string = $this$toLongOrDefault;
            boolean bl = false;
            l = Long.parseLong(string);
        }
        catch (NumberFormatException _) {
            l = defaultValue;
        }
        return l;
    }

    public static final int toNonNegativeInt(@Nullable String $this$toNonNegativeInt, int defaultValue) {
        try {
            String string = $this$toNonNegativeInt;
            if (string == null) {
                return defaultValue;
            }
            String string2 = string;
            boolean bl = false;
            long value = Long.parseLong(string2);
            return value > (long)Integer.MAX_VALUE ? Integer.MAX_VALUE : (value < 0L ? 0 : (int)value);
        }
        catch (NumberFormatException _) {
            return defaultValue;
        }
    }
}

