/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.connection;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.Socket;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import okhttp3.Address;
import okhttp3.Call;
import okhttp3.CertificatePinner;
import okhttp3.Connection;
import okhttp3.EventListener;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.internal.Util;
import okhttp3.internal.connection.Exchange;
import okhttp3.internal.connection.ExchangeFinder;
import okhttp3.internal.connection.RealConnection;
import okhttp3.internal.connection.RealConnectionPool;
import okhttp3.internal.connection.Transmitter;
import okhttp3.internal.http.ExchangeCodec;
import okhttp3.internal.platform.Platform;
import okio.AsyncTimeout;
import okio.Timeout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u007f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006*\u0001 \u0018\u00002\u00020\u0001:\u0001FB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010#\u001a\u00020$2\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010%\u001a\u00020$J\u0006\u0010&\u001a\u00020\tJ\u0006\u0010'\u001a\u00020$J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0002J\u0006\u0010,\u001a\u00020$J;\u0010-\u001a\u0002H.\"\n\b\u0000\u0010.*\u0004\u0018\u00010/2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u00100\u001a\u00020\t2\u0006\u00101\u001a\u00020\t2\u0006\u00102\u001a\u0002H.H\u0000\u00a2\u0006\u0004\b3\u00104J\u0006\u00105\u001a\u00020\tJ)\u00106\u001a\u0002H.\"\n\b\u0000\u0010.*\u0004\u0018\u00010/2\u0006\u00102\u001a\u0002H.2\u0006\u00107\u001a\u00020\tH\u0002\u00a2\u0006\u0002\u00108J\u001d\u00109\u001a\u00020\u00152\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b=J\u0012\u0010\u001c\u001a\u0004\u0018\u00010/2\b\u00102\u001a\u0004\u0018\u00010/J\u000e\u0010>\u001a\u00020$2\u0006\u0010\u001d\u001a\u00020\u001eJ\b\u0010?\u001a\u0004\u0018\u00010@J\u0006\u0010\u001f\u001a\u00020AJ\u0006\u0010\"\u001a\u00020$J\u0006\u0010B\u001a\u00020$J!\u0010C\u001a\u0002H.\"\n\b\u0000\u0010.*\u0004\u0018\u00010/2\u0006\u0010D\u001a\u0002H.H\u0002\u00a2\u0006\u0002\u0010ER\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001a\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010!R\u000e\u0010\"\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lokhttp3/internal/connection/Transmitter;", "", "client", "Lokhttp3/OkHttpClient;", "call", "Lokhttp3/Call;", "(Lokhttp3/OkHttpClient;Lokhttp3/Call;)V", "callStackTrace", "canceled", "", "connection", "Lokhttp3/internal/connection/RealConnection;", "getConnection", "()Lokhttp3/internal/connection/RealConnection;", "setConnection", "(Lokhttp3/internal/connection/RealConnection;)V", "connectionPool", "Lokhttp3/internal/connection/RealConnectionPool;", "eventListener", "Lokhttp3/EventListener;", "exchange", "Lokhttp3/internal/connection/Exchange;", "exchangeFinder", "Lokhttp3/internal/connection/ExchangeFinder;", "exchangeRequestDone", "exchangeResponseDone", "isCanceled", "()Z", "noMoreExchanges", "request", "Lokhttp3/Request;", "timeout", "okhttp3/internal/connection/Transmitter$timeout$1", "Lokhttp3/internal/connection/Transmitter$timeout$1;", "timeoutEarlyExit", "acquireConnectionNoEvents", "", "callStart", "canRetry", "cancel", "createAddress", "Lokhttp3/Address;", "url", "Lokhttp3/HttpUrl;", "exchangeDoneDueToException", "exchangeMessageDone", "E", "Ljava/io/IOException;", "requestDone", "responseDone", "e", "exchangeMessageDone$okhttp", "(Lokhttp3/internal/connection/Exchange;ZZLjava/io/IOException;)Ljava/io/IOException;", "hasExchange", "maybeReleaseConnection", "force", "(Ljava/io/IOException;Z)Ljava/io/IOException;", "newExchange", "chain", "Lokhttp3/Interceptor$Chain;", "doExtensiveHealthChecks", "newExchange$okhttp", "prepareToConnect", "releaseConnectionNoEvents", "Ljava/net/Socket;", "Lokio/Timeout;", "timeoutEnter", "timeoutExit", "cause", "(Ljava/io/IOException;)Ljava/io/IOException;", "TransmitterReference", "okhttp"})
public final class Transmitter {
    private final RealConnectionPool connectionPool;
    private final EventListener eventListener;
    private final timeout.1 timeout;
    private Object callStackTrace;
    private Request request;
    private ExchangeFinder exchangeFinder;
    @Nullable
    private RealConnection connection;
    private Exchange exchange;
    private boolean exchangeRequestDone;
    private boolean exchangeResponseDone;
    private boolean canceled;
    private boolean timeoutEarlyExit;
    private boolean noMoreExchanges;
    private final OkHttpClient client;
    private final Call call;

    @Nullable
    public final RealConnection getConnection() {
        return this.connection;
    }

    public final void setConnection(@Nullable RealConnection realConnection) {
        this.connection = realConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isCanceled() {
        RealConnectionPool realConnectionPool = this.connectionPool;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (realConnectionPool) {
            boolean bl3 = false;
            boolean bl4 = this.canceled;
            return bl4;
        }
    }

    @NotNull
    public final Timeout timeout() {
        return (Timeout)this.timeout;
    }

    public final void timeoutEnter() {
        this.timeout.enter();
    }

    public final void timeoutEarlyExit() {
        boolean bl = !this.timeoutEarlyExit;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Check failed.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.timeoutEarlyExit = true;
        this.timeout.exit();
    }

    private final <E extends IOException> E timeoutExit(E cause) {
        if (this.timeoutEarlyExit) {
            return cause;
        }
        if (!this.timeout.exit()) {
            return cause;
        }
        InterruptedIOException e = new InterruptedIOException("timeout");
        if (cause != null) {
            e.initCause(cause);
        }
        return (E)e;
    }

    public final void callStart() {
        this.callStackTrace = Platform.Companion.get().getStackTraceForCloseable("response.body().close()");
        this.eventListener.callStart(this.call);
    }

    public final void prepareToConnect(@NotNull Request request) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        if (this.request != null) {
            Request request2 = this.request;
            if (request2 == null) {
                Intrinsics.throwNpe();
            }
            if (Util.sameConnection(request2.url(), request.url())) {
                ExchangeFinder exchangeFinder = this.exchangeFinder;
                if (exchangeFinder == null) {
                    Intrinsics.throwNpe();
                }
                if (exchangeFinder.hasRouteToTry()) {
                    return;
                }
            }
            boolean bl = this.exchange == null;
            boolean bl2 = false;
            boolean bl3 = false;
            bl3 = false;
            boolean bl4 = false;
            if (!bl) {
                boolean bl5 = false;
                String string = "Check failed.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            if (this.exchangeFinder != null) {
                this.maybeReleaseConnection(null, true);
                this.exchangeFinder = null;
            }
        }
        this.request = request;
        this.exchangeFinder = new ExchangeFinder(this, this.connectionPool, this.createAddress(request.url()), this.call, this.eventListener);
    }

    private final Address createAddress(HttpUrl url) {
        SSLSocketFactory sslSocketFactory = null;
        HostnameVerifier hostnameVerifier = null;
        CertificatePinner certificatePinner = null;
        if (url.isHttps()) {
            sslSocketFactory = this.client.sslSocketFactory();
            hostnameVerifier = this.client.hostnameVerifier();
            certificatePinner = this.client.certificatePinner();
        }
        return new Address(url.host(), url.port(), this.client.dns(), this.client.socketFactory(), sslSocketFactory, hostnameVerifier, certificatePinner, this.client.proxyAuthenticator(), this.client.proxy(), this.client.protocols(), this.client.connectionSpecs(), this.client.proxySelector());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Exchange newExchange$okhttp(@NotNull Interceptor.Chain chain, boolean doExtensiveHealthChecks) {
        Object object;
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)chain, (String)"chain");
        RealConnectionPool realConnectionPool = this.connectionPool;
        boolean bl2 = false;
        boolean bl3 = false;
        synchronized (realConnectionPool) {
            boolean bl4 = false;
            bl = !this.noMoreExchanges;
            boolean bl5 = false;
            boolean bl6 = false;
            if (!bl) {
                boolean bl7 = false;
                String string = "released";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            bl = this.exchange == null;
            bl5 = false;
            bl6 = false;
            if (!bl) {
                boolean bl8 = false;
                String string = "cannot make a new request because the previous response is still open: please call response.close()";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            object = Unit.INSTANCE;
        }
        ExchangeFinder exchangeFinder = this.exchangeFinder;
        if (exchangeFinder == null) {
            Intrinsics.throwNpe();
        }
        ExchangeCodec codec = exchangeFinder.find(this.client, chain, doExtensiveHealthChecks);
        ExchangeFinder exchangeFinder2 = this.exchangeFinder;
        if (exchangeFinder2 == null) {
            Intrinsics.throwNpe();
        }
        Exchange result = new Exchange(this, this.call, this.eventListener, exchangeFinder2, codec);
        object = this.connectionPool;
        boolean bl9 = false;
        bl = false;
        synchronized (object) {
            boolean bl10 = false;
            this.exchange = result;
            this.exchangeRequestDone = false;
            this.exchangeResponseDone = false;
            Exchange exchange = result;
            return exchange;
        }
    }

    public final void acquireConnectionNoEvents(@NotNull RealConnection connection) {
        Intrinsics.checkParameterIsNotNull((Object)connection, (String)"connection");
        boolean bl = Thread.holdsLock(this.connectionPool);
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        bl = this.connection == null;
        bl2 = false;
        bl3 = false;
        bl3 = false;
        boolean bl5 = false;
        if (!bl) {
            boolean bl6 = false;
            String string = "Check failed.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.connection = connection;
        connection.transmitters.add(new TransmitterReference(this, this.callStackTrace));
    }

    @Nullable
    public final Socket releaseConnectionNoEvents() {
        RealConnection released;
        int n;
        boolean bl;
        block8: {
            boolean bl2 = Thread.holdsLock(this.connectionPool);
            boolean bl3 = false;
            bl = false;
            if (_Assertions.ENABLED && !bl2) {
                boolean bl4 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            RealConnection realConnection = this.connection;
            if (realConnection == null) {
                Intrinsics.throwNpe();
            }
            List<Reference<Transmitter>> list = realConnection.transmitters;
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"connection!!.transmitters");
            List<Reference<Transmitter>> $this$indexOfFirst$iv = list;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<Reference<Transmitter>> iterator = $this$indexOfFirst$iv.iterator();
            while (iterator.hasNext()) {
                Reference<Transmitter> item$iv;
                Reference<Transmitter> it = item$iv = iterator.next();
                boolean bl5 = false;
                if (Intrinsics.areEqual((Object)it.get(), (Object)this)) {
                    n = index$iv;
                    break block8;
                }
                ++index$iv;
            }
            n = -1;
        }
        int index = n;
        boolean $this$indexOfFirst$iv = index != -1;
        bl = false;
        boolean bl6 = false;
        bl6 = false;
        boolean bl7 = false;
        if (!$this$indexOfFirst$iv) {
            boolean bl8 = false;
            String string = "Check failed.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        RealConnection realConnection = released = this.connection;
        if (realConnection == null) {
            Intrinsics.throwNpe();
        }
        realConnection.transmitters.remove(index);
        this.connection = null;
        if (released.transmitters.isEmpty()) {
            released.idleAtNanos = System.nanoTime();
            if (this.connectionPool.connectionBecameIdle(released)) {
                return released.socket();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void exchangeDoneDueToException() {
        RealConnectionPool realConnectionPool = this.connectionPool;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (realConnectionPool) {
            boolean bl3 = false;
            boolean bl4 = !this.noMoreExchanges;
            boolean bl5 = false;
            boolean bl6 = false;
            bl6 = false;
            boolean bl7 = false;
            if (!bl4) {
                boolean bl8 = false;
                String string = "Check failed.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            this.exchange = null;
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <E extends IOException> E exchangeMessageDone$okhttp(@NotNull Exchange exchange, boolean requestDone, boolean responseDone, E e) {
        Intrinsics.checkParameterIsNotNull((Object)exchange, (String)"exchange");
        E result = e;
        boolean exchangeDone = false;
        RealConnectionPool realConnectionPool = this.connectionPool;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (realConnectionPool) {
            block12: {
                boolean bl3 = false;
                if (!(Intrinsics.areEqual((Object)exchange, (Object)this.exchange) ^ true)) break block12;
                E e2 = result;
                return e2;
            }
            boolean changed = false;
            if (requestDone) {
                if (!this.exchangeRequestDone) {
                    changed = true;
                }
                this.exchangeRequestDone = true;
            }
            if (responseDone) {
                if (!this.exchangeResponseDone) {
                    changed = true;
                }
                this.exchangeResponseDone = true;
            }
            if (this.exchangeRequestDone && this.exchangeResponseDone && changed) {
                exchangeDone = true;
                Exchange exchange2 = this.exchange;
                if (exchange2 == null) {
                    Intrinsics.throwNpe();
                }
                RealConnection realConnection = exchange2.connection();
                if (realConnection == null) {
                    Intrinsics.throwNpe();
                }
                int n = realConnection.successCount;
                realConnection.successCount = n + 1;
                this.exchange = null;
            }
            Unit unit = Unit.INSTANCE;
        }
        if (exchangeDone) {
            result = this.maybeReleaseConnection(result, false);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final IOException noMoreExchanges(@Nullable IOException e) {
        RealConnectionPool realConnectionPool = this.connectionPool;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (realConnectionPool) {
            boolean bl3 = false;
            this.noMoreExchanges = true;
            Unit unit = Unit.INSTANCE;
        }
        return this.maybeReleaseConnection(e, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <E extends IOException> E maybeReleaseConnection(E e, boolean force) {
        E result = e;
        Socket socket = null;
        Ref.ObjectRef releasedConnection = new Ref.ObjectRef();
        boolean callEnd = false;
        RealConnectionPool realConnectionPool = this.connectionPool;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (realConnectionPool) {
            boolean bl3 = false;
            boolean bl4 = !force || this.exchange == null;
            boolean bl5 = false;
            boolean bl6 = false;
            if (!bl4) {
                boolean bl7 = false;
                String string = "cannot release connection while it is in use";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            releasedConnection.element = this.connection;
            Socket socket2 = socket = this.connection != null && this.exchange == null && (force || this.noMoreExchanges) ? this.releaseConnectionNoEvents() : null;
            if (this.connection != null) {
                releasedConnection.element = null;
            }
            callEnd = this.noMoreExchanges && this.exchange == null;
            Unit unit = Unit.INSTANCE;
        }
        Util.closeQuietly(socket);
        if ((Connection)releasedConnection.element != null) {
            Connection connection = (Connection)releasedConnection.element;
            if (connection == null) {
                Intrinsics.throwNpe();
            }
            this.eventListener.connectionReleased(this.call, connection);
        }
        if (callEnd) {
            boolean callFailed = result != null;
            result = this.timeoutExit(result);
            if (callFailed) {
                E e2 = result;
                if (e2 == null) {
                    Intrinsics.throwNpe();
                }
                this.eventListener.callFailed(this.call, e2);
            } else {
                this.eventListener.callEnd(this.call);
            }
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean canRetry() {
        ExchangeFinder exchangeFinder = this.exchangeFinder;
        if (exchangeFinder == null) {
            Intrinsics.throwNpe();
        }
        if (!exchangeFinder.hasStreamFailure()) return false;
        ExchangeFinder exchangeFinder2 = this.exchangeFinder;
        if (exchangeFinder2 == null) {
            Intrinsics.throwNpe();
        }
        if (!exchangeFinder2.hasRouteToTry()) return false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean hasExchange() {
        RealConnectionPool realConnectionPool = this.connectionPool;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (realConnectionPool) {
            boolean bl3 = false;
            boolean bl4 = this.exchange != null;
            return bl4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cancel() {
        block5: {
            Object connectionToCancel;
            block4: {
                Exchange exchangeToCancel = null;
                connectionToCancel = null;
                RealConnectionPool realConnectionPool = this.connectionPool;
                boolean bl = false;
                boolean bl2 = false;
                synchronized (realConnectionPool) {
                    boolean bl3 = false;
                    this.canceled = true;
                    exchangeToCancel = this.exchange;
                    Object object = this.exchangeFinder;
                    if (object == null || (object = ((ExchangeFinder)object).connectingConnection()) == null) {
                        object = this.connection;
                    }
                    connectionToCancel = object;
                    Unit unit = Unit.INSTANCE;
                }
                Exchange exchange = exchangeToCancel;
                if (exchange == null) break block4;
                exchange.cancel();
                break block5;
            }
            Object object = connectionToCancel;
            if (object == null) break block5;
            ((RealConnection)object).cancel();
        }
    }

    public Transmitter(@NotNull OkHttpClient client, @NotNull Call call) {
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
        this.client = client;
        this.call = call;
        this.connectionPool = this.client.connectionPool().delegate;
        this.eventListener = this.client.eventListenerFactory().create(this.call);
        AsyncTimeout asyncTimeout = new AsyncTimeout(this){
            final /* synthetic */ Transmitter this$0;

            protected void timedOut() {
                this.this$0.cancel();
            }
            {
                this.this$0 = $outer;
            }
        };
        Transmitter transmitter = this;
        boolean bl = false;
        boolean bl2 = false;
        AsyncTimeout $this$apply = asyncTimeout;
        boolean bl3 = false;
        $this$apply.timeout((long)this.client.callTimeoutMillis(), TimeUnit.MILLISECONDS);
        AsyncTimeout asyncTimeout2 = asyncTimeout;
        transmitter.timeout = asyncTimeout2;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lokhttp3/internal/connection/Transmitter$TransmitterReference;", "Ljava/lang/ref/WeakReference;", "Lokhttp3/internal/connection/Transmitter;", "referent", "callStackTrace", "", "(Lokhttp3/internal/connection/Transmitter;Ljava/lang/Object;)V", "getCallStackTrace", "()Ljava/lang/Object;", "okhttp"})
    public static final class TransmitterReference
    extends WeakReference<Transmitter> {
        @Nullable
        private final Object callStackTrace;

        @Nullable
        public final Object getCallStackTrace() {
            return this.callStackTrace;
        }

        public TransmitterReference(@NotNull Transmitter referent, @Nullable Object callStackTrace) {
            Intrinsics.checkParameterIsNotNull((Object)referent, (String)"referent");
            super(referent);
            this.callStackTrace = callStackTrace;
        }
    }
}

