/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.ws;

import java.io.IOException;
import java.util.Random;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.internal.ws.WebSocketProtocol;
import okio.Buffer;
import okio.BufferedSink;
import okio.ByteString;
import okio.Sink;
import okio.Timeout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0000\u0018\u00002\u00020\u0001:\u00012B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#J\u0018\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020!2\b\u0010'\u001a\u0004\u0018\u00010(J\u0018\u0010)\u001a\u00020%2\u0006\u0010*\u001a\u00020!2\u0006\u0010+\u001a\u00020(H\u0002J&\u0010,\u001a\u00020%2\u0006\u0010 \u001a\u00020!2\u0006\u0010-\u001a\u00020#2\u0006\u0010.\u001a\u00020\u00032\u0006\u0010/\u001a\u00020\u0003J\u000e\u00100\u001a\u00020%2\u0006\u0010+\u001a\u00020(J\u000e\u00101\u001a\u00020%2\u0006\u0010+\u001a\u00020(R\u001a\u0010\t\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0012\u0010\u0012\u001a\u00060\u0013R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lokhttp3/internal/ws/WebSocketWriter;", "", "isClient", "", "sink", "Lokio/BufferedSink;", "random", "Ljava/util/Random;", "(ZLokio/BufferedSink;Ljava/util/Random;)V", "activeWriter", "getActiveWriter", "()Z", "setActiveWriter", "(Z)V", "buffer", "Lokio/Buffer;", "getBuffer", "()Lokio/Buffer;", "frameSink", "Lokhttp3/internal/ws/WebSocketWriter$FrameSink;", "maskCursor", "Lokio/Buffer$UnsafeCursor;", "maskKey", "", "getRandom", "()Ljava/util/Random;", "getSink", "()Lokio/BufferedSink;", "sinkBuffer", "writerClosed", "newMessageSink", "Lokio/Sink;", "formatOpcode", "", "contentLength", "", "writeClose", "", "code", "reason", "Lokio/ByteString;", "writeControlFrame", "opcode", "payload", "writeMessageFrame", "byteCount", "isFirstFrame", "isFinal", "writePing", "writePong", "FrameSink", "okhttp"})
public final class WebSocketWriter {
    private final Buffer sinkBuffer;
    private boolean writerClosed;
    @NotNull
    private final Buffer buffer;
    private final FrameSink frameSink;
    private boolean activeWriter;
    private final byte[] maskKey;
    private final Buffer.UnsafeCursor maskCursor;
    private final boolean isClient;
    @NotNull
    private final BufferedSink sink;
    @NotNull
    private final Random random;

    @NotNull
    public final Buffer getBuffer() {
        return this.buffer;
    }

    public final boolean getActiveWriter() {
        return this.activeWriter;
    }

    public final void setActiveWriter(boolean bl) {
        this.activeWriter = bl;
    }

    public final void writePing(@NotNull ByteString payload) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)payload, (String)"payload");
        this.writeControlFrame(9, payload);
    }

    public final void writePong(@NotNull ByteString payload) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)payload, (String)"payload");
        this.writeControlFrame(10, payload);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeClose(int code, @Nullable ByteString reason) throws IOException {
        ByteString payload = ByteString.EMPTY;
        if (code != 0 || reason != null) {
            if (code != 0) {
                WebSocketProtocol.INSTANCE.validateCloseCode(code);
            }
            Buffer buffer = new Buffer();
            boolean bl = false;
            boolean bl2 = false;
            Buffer $this$run = buffer;
            boolean bl3 = false;
            $this$run.writeShort(code);
            if (reason != null) {
                $this$run.write(reason);
            }
            payload = $this$run.readByteString();
        }
        try {
            this.writeControlFrame(8, payload);
        }
        finally {
            this.writerClosed = true;
        }
    }

    private final void writeControlFrame(int opcode, ByteString payload) throws IOException {
        if (this.writerClosed) {
            throw (Throwable)new IOException("closed");
        }
        int length = payload.size();
        boolean bl = (long)length <= 125L;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Payload size must be less than or equal to 125";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        int b0 = 0x80 | opcode;
        this.sinkBuffer.writeByte(b0);
        int b1 = length;
        if (this.isClient) {
            this.sinkBuffer.writeByte(b1 |= 0x80);
            if (this.maskKey == null) {
                Intrinsics.throwNpe();
            }
            this.random.nextBytes(this.maskKey);
            this.sinkBuffer.write(this.maskKey);
            if (length > 0) {
                long payloadStart = this.sinkBuffer.size();
                this.sinkBuffer.write(payload);
                Buffer.UnsafeCursor unsafeCursor = this.maskCursor;
                if (unsafeCursor == null) {
                    Intrinsics.throwNpe();
                }
                this.sinkBuffer.readAndWriteUnsafe(unsafeCursor);
                this.maskCursor.seek(payloadStart);
                WebSocketProtocol.INSTANCE.toggleMask(this.maskCursor, this.maskKey);
                this.maskCursor.close();
            }
        } else {
            this.sinkBuffer.writeByte(b1);
            this.sinkBuffer.write(payload);
        }
        this.sink.flush();
    }

    @NotNull
    public final Sink newMessageSink(int formatOpcode, long contentLength) {
        boolean bl = !this.activeWriter;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Another message writer is active. Did you call close()?";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.activeWriter = true;
        this.frameSink.setFormatOpcode(formatOpcode);
        this.frameSink.setContentLength(contentLength);
        this.frameSink.setFirstFrame(true);
        this.frameSink.setClosed(false);
        return this.frameSink;
    }

    public final void writeMessageFrame(int formatOpcode, long byteCount, boolean isFirstFrame, boolean isFinal) throws IOException {
        int b0;
        if (this.writerClosed) {
            throw (Throwable)new IOException("closed");
        }
        int n = b0 = isFirstFrame ? formatOpcode : 0;
        if (isFinal) {
            b0 |= 0x80;
        }
        this.sinkBuffer.writeByte(b0);
        int b1 = 0;
        if (this.isClient) {
            b1 |= 0x80;
        }
        if (byteCount <= 125L) {
            this.sinkBuffer.writeByte(b1 |= (int)byteCount);
        } else if (byteCount <= 65535L) {
            this.sinkBuffer.writeByte(b1 |= 0x7E);
            this.sinkBuffer.writeShort((int)byteCount);
        } else {
            this.sinkBuffer.writeByte(b1 |= 0x7F);
            this.sinkBuffer.writeLong(byteCount);
        }
        if (this.isClient) {
            if (this.maskKey == null) {
                Intrinsics.throwNpe();
            }
            this.random.nextBytes(this.maskKey);
            this.sinkBuffer.write(this.maskKey);
            if (byteCount > 0L) {
                long bufferStart = this.sinkBuffer.size();
                this.sinkBuffer.write(this.buffer, byteCount);
                Buffer.UnsafeCursor unsafeCursor = this.maskCursor;
                if (unsafeCursor == null) {
                    Intrinsics.throwNpe();
                }
                this.sinkBuffer.readAndWriteUnsafe(unsafeCursor);
                this.maskCursor.seek(bufferStart);
                WebSocketProtocol.INSTANCE.toggleMask(this.maskCursor, this.maskKey);
                this.maskCursor.close();
            }
        } else {
            this.sinkBuffer.write(this.buffer, byteCount);
        }
        this.sink.emit();
    }

    @NotNull
    public final BufferedSink getSink() {
        return this.sink;
    }

    @NotNull
    public final Random getRandom() {
        return this.random;
    }

    public WebSocketWriter(boolean isClient, @NotNull BufferedSink sink, @NotNull Random random) {
        Intrinsics.checkParameterIsNotNull((Object)sink, (String)"sink");
        Intrinsics.checkParameterIsNotNull((Object)random, (String)"random");
        this.isClient = isClient;
        this.sink = sink;
        this.random = random;
        this.sinkBuffer = this.sink.getBuffer();
        this.buffer = new Buffer();
        this.frameSink = new FrameSink();
        this.maskKey = this.isClient ? new byte[4] : null;
        this.maskCursor = this.isClient ? new Buffer.UnsafeCursor() : null;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0018H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\nH\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0006\"\u0004\b\u0016\u0010\b\u00a8\u0006 "}, d2={"Lokhttp3/internal/ws/WebSocketWriter$FrameSink;", "Lokio/Sink;", "(Lokhttp3/internal/ws/WebSocketWriter;)V", "closed", "", "getClosed", "()Z", "setClosed", "(Z)V", "contentLength", "", "getContentLength", "()J", "setContentLength", "(J)V", "formatOpcode", "", "getFormatOpcode", "()I", "setFormatOpcode", "(I)V", "isFirstFrame", "setFirstFrame", "close", "", "flush", "timeout", "Lokio/Timeout;", "write", "source", "Lokio/Buffer;", "byteCount", "okhttp"})
    public final class FrameSink
    implements Sink {
        private int formatOpcode;
        private long contentLength;
        private boolean isFirstFrame;
        private boolean closed;

        public final int getFormatOpcode() {
            return this.formatOpcode;
        }

        public final void setFormatOpcode(int n) {
            this.formatOpcode = n;
        }

        public final long getContentLength() {
            return this.contentLength;
        }

        public final void setContentLength(long l) {
            this.contentLength = l;
        }

        public final boolean isFirstFrame() {
            return this.isFirstFrame;
        }

        public final void setFirstFrame(boolean bl) {
            this.isFirstFrame = bl;
        }

        public final boolean getClosed() {
            return this.closed;
        }

        public final void setClosed(boolean bl) {
            this.closed = bl;
        }

        public void write(@NotNull Buffer source, long byteCount) throws IOException {
            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
            if (this.closed) {
                throw (Throwable)new IOException("closed");
            }
            WebSocketWriter.this.getBuffer().write(source, byteCount);
            boolean deferWrite = this.isFirstFrame && this.contentLength != -1L && WebSocketWriter.this.getBuffer().size() > this.contentLength - (long)8192;
            long emitCount = WebSocketWriter.this.getBuffer().completeSegmentByteCount();
            if (emitCount > 0L && !deferWrite) {
                WebSocketWriter.this.writeMessageFrame(this.formatOpcode, emitCount, this.isFirstFrame, false);
                this.isFirstFrame = false;
            }
        }

        public void flush() throws IOException {
            if (this.closed) {
                throw (Throwable)new IOException("closed");
            }
            WebSocketWriter.this.writeMessageFrame(this.formatOpcode, WebSocketWriter.this.getBuffer().size(), this.isFirstFrame, false);
            this.isFirstFrame = false;
        }

        @NotNull
        public Timeout timeout() {
            return WebSocketWriter.this.getSink().timeout();
        }

        public void close() throws IOException {
            if (this.closed) {
                throw (Throwable)new IOException("closed");
            }
            WebSocketWriter.this.writeMessageFrame(this.formatOpcode, WebSocketWriter.this.getBuffer().size(), this.isFirstFrame, true);
            this.closed = true;
            WebSocketWriter.this.setActiveWriter(false);
        }
    }
}

