/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import okio.ExperimentalFileSystem;
import okio.FileHandle;
import okio.FileMetadata;
import okio.FileSystem;
import okio.JvmFileHandle;
import okio.Okio;
import okio.Path;
import okio.Sink;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0011\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006H\u0016J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006H\u0016J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u0006H\u0016J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0006H\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u00112\u0006\u0010\u000e\u001a\u00020\u0006H\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\f\u001a\u00020\u0006H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\t\u001a\u00020\u00182\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016\u00a8\u0006\u001b"}, d2={"Lokio/JvmSystemFileSystem;", "Lokio/FileSystem;", "()V", "appendingSink", "Lokio/Sink;", "file", "Lokio/Path;", "atomicMove", "", "source", "target", "canonicalize", "path", "createDirectory", "dir", "delete", "list", "", "metadataOrNull", "Lokio/FileMetadata;", "openReadOnly", "Lokio/FileHandle;", "openReadWrite", "sink", "Lokio/Source;", "toString", "", "okio"})
@ExperimentalFileSystem
public class JvmSystemFileSystem
extends FileSystem {
    @Override
    @NotNull
    public Path canonicalize(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        File canonicalFile = path.toFile().getCanonicalFile();
        if (!canonicalFile.exists()) {
            throw new FileNotFoundException("no such file");
        }
        Intrinsics.checkNotNullExpressionValue((Object)canonicalFile, (String)"canonicalFile");
        return Path.Companion.get(canonicalFile);
    }

    @Override
    @Nullable
    public FileMetadata metadataOrNull(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        File file = path.toFile();
        boolean isRegularFile = file.isFile();
        boolean isDirectory = file.isDirectory();
        long lastModifiedAtMillis = file.lastModified();
        long size = file.length();
        if (!(isRegularFile || isDirectory || lastModifiedAtMillis != 0L || size != 0L || file.exists())) {
            return null;
        }
        return new FileMetadata(isRegularFile, isDirectory, size, null, lastModifiedAtMillis, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Path> list(@NotNull Path dir) {
        void destination$iv;
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        File file = dir.toFile();
        String[] entries = file.list();
        if (entries == null) {
            if (!file.exists()) {
                throw new FileNotFoundException(Intrinsics.stringPlus((String)"no such file: ", (Object)dir));
            }
            throw new IOException(Intrinsics.stringPlus((String)"failed to list ", (Object)dir));
        }
        String[] stringArray = entries;
        boolean bl = false;
        Collection collection = new ArrayList();
        boolean $i$f$mapTo = false;
        void var8_8 = $this$mapTo$iv;
        int n = ((void)var8_8).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv;
            void var12_12 = item$iv = var8_8[i];
            void var14_14 = destination$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            Path path = dir.resolve((String)it);
            var14_14.add(path);
        }
        List result = (List)destination$iv;
        CollectionsKt.sort((List)result);
        return result;
    }

    @Override
    @NotNull
    public FileHandle openReadOnly(@NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return new JvmFileHandle(false, new RandomAccessFile(file.toFile(), "r"));
    }

    @Override
    @NotNull
    public FileHandle openReadWrite(@NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return new JvmFileHandle(true, new RandomAccessFile(file.toFile(), "rw"));
    }

    @Override
    @NotNull
    public Source source(@NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return Okio.source(file.toFile());
    }

    @Override
    @NotNull
    public Sink sink(@NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return Okio.sink$default(file.toFile(), false, 1, null);
    }

    @Override
    @NotNull
    public Sink appendingSink(@NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return Okio.sink(file.toFile(), true);
    }

    @Override
    public void createDirectory(@NotNull Path dir) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        if (!dir.toFile().mkdir()) {
            throw new IOException(Intrinsics.stringPlus((String)"failed to create directory: ", (Object)dir));
        }
    }

    @Override
    public void atomicMove(@NotNull Path source2, @NotNull Path target) {
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        boolean renamed = source2.toFile().renameTo(target.toFile());
        if (!renamed) {
            throw new IOException("failed to move " + source2 + " to " + target);
        }
    }

    @Override
    public void delete(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        File file = path.toFile();
        boolean deleted = file.delete();
        if (!deleted) {
            if (!file.exists()) {
                throw new FileNotFoundException(Intrinsics.stringPlus((String)"no such file: ", (Object)path));
            }
            throw new IOException(Intrinsics.stringPlus((String)"failed to delete ", (Object)path));
        }
    }

    @NotNull
    public String toString() {
        return "JvmSystemFileSystem";
    }
}

