//[okio](../../../index.md)/[okio](../index.md)/[Buffer](index.md)/[writeShortLe](write-short-le.md)

# writeShortLe

[common]\
expect open override fun [writeShortLe](write-short-le.md)(s: [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html)): [Buffer](index.md)

Writes a little-endian short to this sink using two bytes.

```java
Buffer buffer = new Buffer();
buffer.writeShortLe(32767);
buffer.writeShortLe(15);

assertEquals(4, buffer.size());
assertEquals((byte) 0xff, buffer.readByte());
assertEquals((byte) 0x7f, buffer.readByte());
assertEquals((byte) 0x0f, buffer.readByte());
assertEquals((byte) 0x00, buffer.readByte());
assertEquals(0, buffer.size());
```

[jvm, nonJvm]\
[jvm, nonJvm]\
actual open override fun [writeShortLe](write-short-le.md)(s: [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html)): [Buffer](index.md)