//[okio](../../../index.md)/[okio](../index.md)/[GzipSink](index.md)

# GzipSink

[zlib]\
class [GzipSink](index.md)(sink: [Sink](../-sink/index.md#-376010351%2FMain%2F-1717108311)) : [Sink](../-sink/index.md#-376010351%2FMain%2F-1717108311)

A sink that uses [GZIP](http://www.ietf.org/rfc/rfc1952.txt) to compress written data to another sink.

### Sync flush

Aggressive flushing of this stream may result in reduced compression. Each call to [flush](flush.md) immediately compresses all currently-buffered data; this early compression may be less effective than compression performed without flushing.

This is equivalent to using [Deflater](../-deflater/index.md) with the sync flush option. This class does not offer any partial flush mechanism. For best performance, only call [flush](flush.md) when application behavior requires it.

## Constructors

| | |
|---|---|
| [GzipSink](-gzip-sink.md) | [zlib]<br>constructor(sink: [Sink](../-sink/index.md#-376010351%2FMain%2F-1717108311)) |

## Properties

| Name | Summary |
|---|---|
| [deflater](deflater.md) | [zlib]<br>@get:[JvmName](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin.jvm/-jvm-name/index.html)(name = &quot;deflater&quot;)<br>val [deflater](deflater.md): [Deflater](../-deflater/index.md)<br>The deflater used to compress the body. |

## Functions

| Name | Summary |
|---|---|
| [buffer](../buffer.md) | [common]<br>fun [Sink](../-sink/index.md).[buffer](../buffer.md)(): [BufferedSink](../-buffered-sink/index.md)<br>Returns a new sink that buffers writes to `sink`. The returned sink will batch writes to `sink`. Use this wherever you write to a sink to get an ergonomic and efficient access to data. |
| [cipherSink](../cipher-sink.md) | [jvm]<br>fun [Sink](../-sink/index.md).[cipherSink](../cipher-sink.md)(cipher: [Cipher](https://docs.oracle.com/javase/8/docs/api/javax/crypto/Cipher.html)): [CipherSink](../-cipher-sink/index.md)<br>Returns a sink that uses [cipher](../cipher-sink.md) to encrypt or decrypt this. |
| [close](close.md) | [zlib]<br>open override fun [close](close.md)()<br>Pushes all buffered bytes to their final destination and releases the resources held by this sink. It is an error to write a closed sink. It is safe to close a sink more than once. |
| [deflate](../deflate.md) | [zlib]<br>inline fun [Sink](../-sink/index.md#-376010351%2FMain%2F-1717108311).[deflate](../deflate.md)(deflater: [Deflater](../-deflater/index.md) = Deflater()): [DeflaterSink](../-deflater-sink/index.md)<br>Returns an [DeflaterSink](../-deflater-sink/index.md) that DEFLATE-compresses data to this [Sink](../-sink/index.md#-376010351%2FMain%2F-1717108311) while writing. |
| [flush](flush.md) | [zlib]<br>open override fun [flush](flush.md)()<br>Pushes all buffered bytes to their final destination. |
| [gzip](../gzip.md) | [zlib]<br>inline fun [Sink](../-sink/index.md#-376010351%2FMain%2F-1717108311).[gzip](../gzip.md)(): [GzipSink](index.md)<br>Returns a [GzipSink](index.md) that gzip-compresses to this [Sink](../-sink/index.md#-376010351%2FMain%2F-1717108311) while writing. |
| [hashingSink](../hashing-sink.md) | [jvm]<br>fun [Sink](../-sink/index.md).[hashingSink](../hashing-sink.md)(digest: [MessageDigest](https://docs.oracle.com/javase/8/docs/api/java/security/MessageDigest.html)): [HashingSink](../-hashing-sink/index.md)<br>Returns a sink that uses [digest](../hashing-sink.md) to hash this.<br>[jvm]<br>fun [Sink](../-sink/index.md).[hashingSink](../hashing-sink.md)(mac: [Mac](https://docs.oracle.com/javase/8/docs/api/javax/crypto/Mac.html)): [HashingSink](../-hashing-sink/index.md)<br>Returns a sink that uses [mac](../hashing-sink.md) to hash this. |
| [timeout](timeout.md) | [zlib]<br>open override fun [timeout](timeout.md)(): Timeout<br>Returns the timeout for this sink. |
| [write](write.md) | [zlib]<br>open override fun [write](write.md)(source: [Buffer](../-buffer/index.md#-987215932%2FMain%2F-1717108311), byteCount: [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html))<br>Removes `byteCount` bytes from `source` and appends them to this. |