//[okio](../../../index.md)/[okio](../index.md)/[Deflater](index.md)

# Deflater

expect class [Deflater](index.md)(level: [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html), nowrap: [Boolean](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-boolean/index.html))actual class [Deflater](index.md)(level: [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html), nowrap: [Boolean](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-boolean/index.html))actual typealias [Deflater](index.md) = [java.util.zip.Deflater](https://docs.oracle.com/javase/8/docs/api/java/util/zip/Deflater.html)

Deflate using Kotlin/Native's built-in zlib bindings. This uses the raw deflate format and omits the zlib header and trailer, and does not compute a check value.

Note that you must set [flush](flush.md) to Z_FINISH before the last call to process. (It is okay to call process() when the source is exhausted.)

See also, the [zlib manual](https://www.zlib.net/manual.html).

#### Parameters

zlib

| | |
|---|---|
| nowrap | true to skip the ZLIB header and checksum. |

## Constructors

| | |
|---|---|
| [Deflater](-deflater.md) | [zlib]<br>expect constructor()<br>Creates a deflater that expects to read a ZLIB header and checksum.<br>expect constructor(level: [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html), nowrap: [Boolean](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-boolean/index.html))<br>[native]<br>actual constructor()actual constructor(level: [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html), nowrap: [Boolean](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-boolean/index.html)) |

## Properties

| Name | Summary |
|---|---|
| [flush](flush.md) | [native]<br>var [flush](flush.md): [Int](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-int/index.html)<br>Probably Z_NO_FLUSH, Z_FINISH, or Z_SYNC_FLUSH. |

## Functions

| Name | Summary |
|---|---|
| [end](end.md) | [zlib, native]<br>[zlib]<br>expect fun [end](end.md)()<br>[native]<br>actual fun [end](end.md)() |
| [getBytesRead](get-bytes-read.md) | [zlib, native]<br>[zlib]<br>expect fun [getBytesRead](get-bytes-read.md)(): [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html)<br>[native]<br>actual fun [getBytesRead](get-bytes-read.md)(): [Long](https://kotlinlang.org/api/core/kotlin-stdlib/kotlin/-long/index.html) |