//[okio](../../../index.md)/[okio](../index.md)/[BufferedSink](index.md)/[emitCompleteSegments](emit-complete-segments.md)

# emitCompleteSegments

[common]\
abstract fun [emitCompleteSegments](emit-complete-segments.md)(): [BufferedSink](index.md)

Writes complete segments to the underlying sink, if one exists. Like [flush](flush.md), but weaker. Use this to limit the memory held in the buffer to a single segment. Typically application code will not need to call this: it is only necessary when application code writes directly to this [sink's buffer](../buffer.md).

BufferedSink b0 = new Buffer();\
BufferedSink b1 = Okio.buffer(b0);\
BufferedSink b2 = Okio.buffer(b1);\
\
b2.buffer().write(new byte[20_000]);\
assertEquals(20_000, b2.buffer().size());\
assertEquals(     0, b1.buffer().size());\
assertEquals(     0, b0.buffer().size());\
\
b2.emitCompleteSegments();\
assertEquals( 3_616, b2.buffer().size());\
assertEquals(     0, b1.buffer().size());\
assertEquals(16_384, b0.buffer().size()); // This example assumes 8192 byte segments.

[jvm, nonJvm]\
[jvm, nonJvm]\
abstract fun [emitCompleteSegments](emit-complete-segments.md)(): [BufferedSink](index.md)
