//[okio](../../../index.md)/[okio](../index.md)/[BufferedSink](index.md)/[writeShortLe](write-short-le.md)

# writeShortLe

[common]\
expect abstract fun [writeShortLe](write-short-le.md)(s: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [BufferedSink](index.md)

Writes a little-endian short to this sink using two bytes.

```kotlin
Buffer buffer = new Buffer();
buffer.writeShortLe(32767);
buffer.writeShortLe(15);

assertEquals(4, buffer.size());
assertEquals((byte) 0xff, buffer.readByte());
assertEquals((byte) 0x7f, buffer.readByte());
assertEquals((byte) 0x0f, buffer.readByte());
assertEquals((byte) 0x00, buffer.readByte());
assertEquals(0, buffer.size());
```

[jvm, nonJvm]\
[jvm, nonJvm]\
actual abstract fun [writeShortLe](write-short-le.md)(s: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [BufferedSink](index.md)
