//[okio](../../../index.md)/[okio](../index.md)/[Path](index.md)/[relativeTo](relative-to.md)

# relativeTo

[common]\
expect fun [relativeTo](relative-to.md)(other: [Path](index.md)): [Path](index.md)

Returns this path relative to [other](relative-to.md). This effectively inverts the resolve operator, `/`. For any two paths `a` and `b` that have the same root, `a / (b.relativeTo(a))` is equal to `b`. If both paths don't use the same slash, the resolved path will use the slash of the [other](relative-to.md) path.

#### Throws

| | |
|---|---|
| [IllegalArgumentException](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-illegal-argument-exception/index.html) | if this path and the [other](relative-to.md) path are not both [absolute paths](is-absolute.md) or both [relative paths](is-relative.md), or if they are both [absolute paths](is-absolute.md) but of different roots (C: vs D:, or C: vs \\server, etc.). It will also throw if the relative path is impossible to resolve. For instance, it is impossible to resolve the path `../a` relative to `../../b`. |

[jvm, nonJvm]\
[jvm, nonJvm]\
actual fun [relativeTo](relative-to.md)(other: [Path](index.md)): [Path](index.md)
