/*
 * Decompiled with CFR 0.152.
 */
package retrofit2.adapter.rxjava;

import java.util.concurrent.atomic.AtomicInteger;
import retrofit2.Call;
import retrofit2.Response;
import rx.Producer;
import rx.Subscriber;
import rx.Subscription;
import rx.exceptions.CompositeException;
import rx.exceptions.Exceptions;
import rx.exceptions.OnCompletedFailedException;
import rx.exceptions.OnErrorFailedException;
import rx.exceptions.OnErrorNotImplementedException;
import rx.plugins.RxJavaPlugins;

final class CallArbiter<T>
extends AtomicInteger
implements Subscription,
Producer {
    private static final int STATE_WAITING = 0;
    private static final int STATE_REQUESTED = 1;
    private static final int STATE_HAS_RESPONSE = 2;
    private static final int STATE_TERMINATED = 3;
    private final Call<T> call;
    private final Subscriber<? super Response<T>> subscriber;
    private volatile Response<T> response;

    CallArbiter(Call<T> call, Subscriber<? super Response<T>> subscriber) {
        super(0);
        this.call = call;
        this.subscriber = subscriber;
    }

    public void unsubscribe() {
        this.call.cancel();
    }

    public boolean isUnsubscribed() {
        return this.call.isCanceled();
    }

    /*
     * Unable to fully structure code
     */
    public void request(long amount) {
        if (amount == 0L) {
            return;
        }
        block5: while (true) {
            state = this.get();
            switch (state) {
                case 0: {
                    if (!this.compareAndSet(0, 1)) continue block5;
                    return;
                }
                case 2: {
                    if (this.compareAndSet(2, 3)) ** break;
                    continue block5;
                    this.deliverResponse(this.response);
                    return;
                }
                case 1: 
                case 3: {
                    return;
                }
            }
            break;
        }
        throw new IllegalStateException("Unknown state: " + state);
    }

    /*
     * Unable to fully structure code
     */
    void emitResponse(Response<T> response) {
        block5: while (true) {
            state = this.get();
            switch (state) {
                case 0: {
                    this.response = response;
                    if (!this.compareAndSet(0, 2)) continue block5;
                    return;
                }
                case 1: {
                    if (this.compareAndSet(1, 3)) ** break;
                    continue block5;
                    this.deliverResponse(response);
                    return;
                }
                case 2: 
                case 3: {
                    throw new AssertionError();
                }
            }
            break;
        }
        throw new IllegalStateException("Unknown state: " + state);
    }

    private void deliverResponse(Response<T> response) {
        try {
            if (!this.isUnsubscribed()) {
                this.subscriber.onNext(response);
            }
        }
        catch (OnCompletedFailedException | OnErrorFailedException | OnErrorNotImplementedException e) {
            RxJavaPlugins.getInstance().getErrorHandler().handleError(e);
            return;
        }
        catch (Throwable t) {
            Exceptions.throwIfFatal((Throwable)t);
            try {
                this.subscriber.onError(t);
            }
            catch (OnCompletedFailedException | OnErrorFailedException | OnErrorNotImplementedException e) {
                RxJavaPlugins.getInstance().getErrorHandler().handleError(e);
            }
            catch (Throwable inner) {
                Exceptions.throwIfFatal((Throwable)inner);
                CompositeException composite = new CompositeException(new Throwable[]{t, inner});
                RxJavaPlugins.getInstance().getErrorHandler().handleError((Throwable)composite);
            }
            return;
        }
        try {
            if (!this.isUnsubscribed()) {
                this.subscriber.onCompleted();
            }
        }
        catch (OnCompletedFailedException | OnErrorFailedException | OnErrorNotImplementedException e) {
            RxJavaPlugins.getInstance().getErrorHandler().handleError(e);
        }
        catch (Throwable t) {
            Exceptions.throwIfFatal((Throwable)t);
            RxJavaPlugins.getInstance().getErrorHandler().handleError(t);
        }
    }

    void emitError(Throwable t) {
        this.set(3);
        if (!this.isUnsubscribed()) {
            try {
                this.subscriber.onError(t);
            }
            catch (OnCompletedFailedException | OnErrorFailedException | OnErrorNotImplementedException e) {
                RxJavaPlugins.getInstance().getErrorHandler().handleError(e);
            }
            catch (Throwable inner) {
                Exceptions.throwIfFatal((Throwable)inner);
                CompositeException composite = new CompositeException(new Throwable[]{t, inner});
                RxJavaPlugins.getInstance().getErrorHandler().handleError((Throwable)composite);
            }
        }
    }
}

