/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.squareup.wire.ProtoAdapter;
import com.squareup.wire.schema.Field;
import com.squareup.wire.schema.MessageType;
import com.squareup.wire.schema.ProtoFile;
import com.squareup.wire.schema.ProtoMember;
import com.squareup.wire.schema.ProtoType;
import com.squareup.wire.schema.Pruner;
import com.squareup.wire.schema.PruningRules;
import com.squareup.wire.schema.SchemaProtoAdapterFactory;
import com.squareup.wire.schema.Service;
import com.squareup.wire.schema.Type;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 +2\u00020\u0001:\u0001+B\u0017\b\u0000\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0017\u001a\u00020\u000eJ\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0019\u001a\u00020\fJ\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u001cJ\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001e\u001a\u00020\u000eJ\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0019\u001a\u00020\fJ\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001e\u001a\u00020\u000eJ\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0019\u001a\u00020\fJ\u0010\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020#J\u0018\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010$\u001a\u00020\u000e2\u0006\u0010%\u001a\u00020\u000eJ\u0018\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010%\u001a\u00020\u000eJ\u001c\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00010'2\u0006\u0010$\u001a\u00020\u000e2\u0006\u0010(\u001a\u00020)J\u000e\u0010*\u001a\u00020)2\u0006\u0010\"\u001a\u00020#R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00040\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00110\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006,"}, d2={"Lcom/squareup/wire/schema/Schema;", "", "protoFiles", "", "Lcom/squareup/wire/schema/ProtoFile;", "<init>", "(Ljava/lang/Iterable;)V", "", "getProtoFiles", "()Ljava/util/List;", "protoFilesIndex", "", "Lcom/squareup/wire/schema/ProtoType;", "typesIndex", "", "Lcom/squareup/wire/schema/Type;", "servicesIndex", "Lcom/squareup/wire/schema/Service;", "types", "", "getTypes", "()Ljava/util/Set;", "protoFile", "path", "Lokio/Path;", "protoType", "prune", "pruningRules", "Lcom/squareup/wire/schema/PruningRules;", "getService", "name", "getType", "getField", "Lcom/squareup/wire/schema/Field;", "protoMember", "Lcom/squareup/wire/schema/ProtoMember;", "typeName", "memberName", "protoAdapter", "Lcom/squareup/wire/ProtoAdapter;", "includeUnknown", "", "isExtensionField", "Companion", "wire-schema"})
@SourceDebugExtension(value={"SMAP\nSchema.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Schema.kt\ncom/squareup/wire/schema/Schema\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,169:1\n1053#2:170\n295#2,2:171\n1#3:173\n*S KotlinDebug\n*F\n+ 1 Schema.kt\ncom/squareup/wire/schema/Schema\n*L\n29#1:170\n44#1:171,2\n*E\n"})
public final class Schema {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<ProtoFile> protoFiles;
    @NotNull
    private final Map<ProtoType, ProtoFile> protoFilesIndex;
    @NotNull
    private final Map<String, Type> typesIndex;
    @NotNull
    private final Map<String, Service> servicesIndex;

    public Schema(@NotNull Iterable<ProtoFile> protoFiles) {
        Intrinsics.checkNotNullParameter(protoFiles, (String)"protoFiles");
        Iterable<ProtoFile> $this$sortedBy$iv = protoFiles;
        boolean $i$f$sortedBy = false;
        this.protoFiles = CollectionsKt.sortedWith($this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ProtoFile it = (ProtoFile)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getLocation().getPath());
                it = (ProtoFile)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getLocation().getPath())));
            }
        });
        Map index = new LinkedHashMap();
        this.typesIndex = Schema.Companion.buildTypesIndex(protoFiles, index);
        this.servicesIndex = Schema.Companion.buildServicesIndex(protoFiles, index);
        this.protoFilesIndex = index;
    }

    @NotNull
    public final List<ProtoFile> getProtoFiles() {
        return this.protoFiles;
    }

    @NotNull
    public final Set<ProtoType> getTypes() {
        return this.protoFilesIndex.keySet();
    }

    @Nullable
    public final ProtoFile protoFile(@NotNull String path) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Iterable $this$firstOrNull$iv = this.protoFiles;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ProtoFile it = (ProtoFile)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getLocation().getPath(), (Object)path)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Nullable
    public final ProtoFile protoFile(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.protoFile(path.toString());
    }

    @Nullable
    public final ProtoFile protoFile(@NotNull ProtoType protoType) {
        Intrinsics.checkNotNullParameter((Object)protoType, (String)"protoType");
        return this.protoFilesIndex.get(protoType);
    }

    @NotNull
    public final Schema prune(@NotNull PruningRules pruningRules) {
        Intrinsics.checkNotNullParameter((Object)pruningRules, (String)"pruningRules");
        return new Pruner(this, pruningRules).prune();
    }

    @Nullable
    public final Service getService(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.servicesIndex.get(name);
    }

    @Nullable
    public final Service getService(@NotNull ProtoType protoType) {
        Intrinsics.checkNotNullParameter((Object)protoType, (String)"protoType");
        return this.getService(protoType.toString());
    }

    @Nullable
    public final Type getType(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.typesIndex.get(name);
    }

    @Nullable
    public final Type getType(@NotNull ProtoType protoType) {
        Intrinsics.checkNotNullParameter((Object)protoType, (String)"protoType");
        return this.getType(protoType.toString());
    }

    @Nullable
    public final Field getField(@NotNull ProtoMember protoMember) {
        Intrinsics.checkNotNullParameter((Object)protoMember, (String)"protoMember");
        Type type = this.getType(protoMember.getType());
        MessageType messageType = type instanceof MessageType ? (MessageType)type : null;
        if (messageType == null) {
            return null;
        }
        MessageType type2 = messageType;
        Field field = type2.field(protoMember.getMember());
        if (field == null) {
            field = type2.extensionField(protoMember.getMember());
        }
        return field;
    }

    @Nullable
    public final Field getField(@NotNull String typeName, @NotNull String memberName) {
        Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
        Intrinsics.checkNotNullParameter((Object)memberName, (String)"memberName");
        return this.getField(ProtoType.Companion.get(typeName), memberName);
    }

    @Nullable
    public final Field getField(@NotNull ProtoType protoType, @NotNull String memberName) {
        Intrinsics.checkNotNullParameter((Object)protoType, (String)"protoType");
        Intrinsics.checkNotNullParameter((Object)memberName, (String)"memberName");
        return this.getField(ProtoMember.Companion.get(protoType, memberName));
    }

    @NotNull
    public final ProtoAdapter<Object> protoAdapter(@NotNull String typeName, boolean includeUnknown) {
        Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
        Type type = this.getType(typeName);
        if (type == null) {
            boolean bl = false;
            String string = "unexpected type " + typeName;
            throw new IllegalArgumentException(string.toString());
        }
        Type type2 = type;
        return new SchemaProtoAdapterFactory(this, includeUnknown).get(type2.getType());
    }

    public final boolean isExtensionField(@NotNull ProtoMember protoMember) {
        Intrinsics.checkNotNullParameter((Object)protoMember, (String)"protoMember");
        Type type = this.getType(protoMember.getType());
        return type instanceof MessageType && ((MessageType)type).extensionField(protoMember.getMember()) != null;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J6\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\n0\fH\u0002J6\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000f0\u00052\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\n0\fH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/squareup/wire/schema/Schema$Companion;", "", "<init>", "()V", "buildTypesIndex", "", "", "Lcom/squareup/wire/schema/Type;", "protoFiles", "", "Lcom/squareup/wire/schema/ProtoFile;", "protoFilesIndex", "", "Lcom/squareup/wire/schema/ProtoType;", "buildServicesIndex", "Lcom/squareup/wire/schema/Service;", "wire-schema"})
    public static final class Companion {
        private Companion() {
        }

        private final Map<String, Type> buildTypesIndex(Iterable<ProtoFile> protoFiles, Map<ProtoType, ProtoFile> protoFilesIndex) {
            Map typesByName = new LinkedHashMap();
            for (ProtoFile protoFile : protoFiles) {
                for (Type type : protoFile.getTypes()) {
                    com.squareup.wire.schema.Schema$Companion.buildTypesIndex$index(protoFilesIndex, typesByName, type, protoFile);
                }
            }
            return typesByName;
        }

        private final Map<String, Service> buildServicesIndex(Iterable<ProtoFile> protoFiles, Map<ProtoType, ProtoFile> protoFilesIndex) {
            Map result = new LinkedHashMap();
            for (ProtoFile protoFile : protoFiles) {
                for (Service service : protoFile.getServices()) {
                    result.put(service.type().toString(), service);
                    protoFilesIndex.put(service.type(), protoFile);
                }
            }
            return result;
        }

        private static final void buildTypesIndex$index(Map<ProtoType, ProtoFile> $protoFilesIndex, Map<String, Type> typesByName, Type type, ProtoFile protoFile) {
            ProtoType protoType = type.getType();
            if (!$protoFilesIndex.containsKey(protoType)) {
                $protoFilesIndex.put(protoType, protoFile);
            }
            typesByName.put(protoType.toString(), type);
            for (Type nested : type.getNestedTypes()) {
                com.squareup.wire.schema.Schema$Companion.buildTypesIndex$index($protoFilesIndex, typesByName, nested, protoFile);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

