/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.analysis.utils;

import com.sourceclear.util.security.SecurityUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SetupPyParser {
    private static final String PY_IDENT = "[^\\d\\W](?:\\w|/[^/])*";
    private static final String PY_QUOTE = "[\"']";
    private static final String PY_MODULE_OR_EMPTY = "[\"']((?:[^\\d\\W](?:\\w|/[^/])*)?)[\"']";
    private static final String PY_MODULE = "[\"']([^\\d\\W](?:\\w|/[^/])*)[\"']";
    private static final Pattern PACKAGE_DIR_MAPPING = Pattern.compile("(?:[\"']package_dir[\"']\\s*:|package_dir\\s*=)\\s*\\{\\s*[\"']((?:[^\\d\\W](?:\\w|/[^/])*)?)[\"']\\s*:\\s*[\"']([^\\d\\W](?:\\w|/[^/])*)[\"']\\s*\\}");

    public static Path getSpecifiedRoot(Path path) throws ParseException, IOException {
        return SetupPyParser.getSpecifiedRoot(new String(Files.readAllBytes(path)));
    }

    static Path getSpecifiedRoot(String text) throws ParseException {
        return new SetupPyParser().parse(text);
    }

    private SetupPyParser() {
    }

    private Path parse(String text) throws ParseException {
        Matcher m = PACKAGE_DIR_MAPPING.matcher(text);
        if (m.find()) {
            String left = m.group(1);
            String right = m.group(2);
            if (m.find()) {
                throw new ParseException("More than one package_dir key", m.start());
            }
            if (right.endsWith(left)) {
                String commonPrefix = right.substring(0, right.length() - left.length());
                return SecurityUtils.securePathsGet(commonPrefix, new String[0]);
            }
            return SecurityUtils.securePathsGet(right, new String[0]);
        }
        throw new ParseException("No package_dir key", 0);
    }
}

