/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.api.data.evidence;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.google.common.base.Strings;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Ordering;
import com.sourceclear.api.data.evidence.BuildType;
import com.sourceclear.api.data.evidence.CoordNormalizer;
import com.sourceclear.api.data.evidence.CoordinateType;
import java.util.Comparator;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonIdentityInfo(generator=ObjectIdGenerators.IntSequenceGenerator.class)
public class Coordinates
implements Comparable<Coordinates> {
    @NotNull
    @JsonProperty(value="coordinateType")
    private CoordinateType coordType;
    @NotNull
    @Size(min=1)
    private @NotNull @Size(min=1) String coordinate1;
    private String coordinate2;
    private String version;
    private String platform;
    private String scope;
    private transient String normalizedCoord1;
    private transient String normalizedCoord2;

    public Coordinates() {
    }

    private Coordinates(Builder builder) {
        this.coordType = builder.coordType;
        this.coordinate1 = builder.coordinate1;
        this.coordinate2 = builder.coordinate2;
        if (this.coordType != null) {
            CoordNormalizer normalizer = this.coordType.getNormalizer();
            this.coordinate1 = normalizer.normalize(this.coordinate1);
            if (this.coordinate2 != null) {
                this.coordinate2 = normalizer.normalize(this.coordinate2);
            }
        }
        this.version = builder.version;
        this.platform = builder.platform;
        this.scope = builder.scope;
    }

    @Deprecated
    public Coordinates(CoordinateType coordType, String coordinate1, String version) {
        this(coordType, coordinate1, null, version);
    }

    @Deprecated
    public Coordinates(CoordinateType coordType, String coordinate1, String coordinate2, String version) {
        this(new Builder().withCoordinateType(coordType).withCoordinate1(coordinate1).withCoordinate2(coordinate2).withVersion(version));
    }

    public String toRawString() {
        String str;
        String string = str = this.coordinate2 != null ? String.format("%s:%s:%s", this.coordinate1, this.coordinate2, this.version) : String.format("%s:%s", this.coordinate1, this.version);
        if (!Strings.isNullOrEmpty((String)this.scope)) {
            str = str + ":" + this.scope;
        }
        return str;
    }

    @Override
    public int compareTo(@NotNull Coordinates other) {
        return ComparisonChain.start().compare((Object)this.getCoordinateType(), (Object)other.getCoordinateType(), (Comparator)Ordering.natural().nullsFirst()).compare((Object)this.getCoordinate1(), (Object)other.getCoordinate1(), (Comparator)Ordering.natural().nullsFirst()).compare((Object)this.getCoordinate2(), (Object)other.getCoordinate2(), (Comparator)Ordering.natural().nullsFirst()).compare((Object)this.getVersion(), (Object)other.getVersion(), (Comparator)Ordering.natural().nullsFirst()).compare((Object)this.getPlatform(), (Object)other.getPlatform(), (Comparator)Ordering.natural().nullsFirst()).compare((Object)this.getScope(), (Object)other.getScope(), (Comparator)Ordering.natural().nullsFirst()).result();
    }

    public String toString() {
        String str;
        String string = str = this.coordinate2 != null ? String.format("%s/%s:%s:%s", new Object[]{this.coordType, this.coordinate1, this.coordinate2, this.version}) : String.format("%s/%s:%s", new Object[]{this.coordType, this.coordinate1, this.version});
        if (!Strings.isNullOrEmpty((String)this.scope)) {
            str = str + ":" + this.scope;
        }
        return str;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Coordinates that = (Coordinates)o;
        return this.coordType == that.coordType && Objects.equals(this.getCoordinate1(), that.getCoordinate1()) && Objects.equals(this.getCoordinate2(), that.getCoordinate2()) && Objects.equals(this.version, that.version) && Objects.equals(this.platform, that.platform) && Objects.equals(this.scope, that.scope);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.coordType, this.getCoordinate1(), this.getCoordinate2(), this.version, this.platform, this.scope});
    }

    @JsonSetter(value="buildType")
    public void setBuildType(BuildType buildType) {
        this.coordType = buildType == null ? null : CoordinateType.toCoordType(buildType.name());
    }

    @JsonProperty(value="buildType")
    public CoordinateType getCoordinateType() {
        return this.coordType;
    }

    public String getCoordinate1() {
        if (this.coordinate1 == null) {
            return null;
        }
        if (this.normalizedCoord1 == null) {
            this.normalizedCoord1 = this.coordType == null ? this.coordinate1 : this.coordType.getNormalizer().normalize(this.coordinate1);
        }
        return this.normalizedCoord1;
    }

    public String getCoordinate2() {
        if (this.coordinate2 == null) {
            return null;
        }
        if (this.normalizedCoord2 == null) {
            this.normalizedCoord2 = this.coordType == null ? this.coordinate2 : this.coordType.getNormalizer().normalize(this.coordinate2);
        }
        return this.normalizedCoord2;
    }

    public String getVersion() {
        return this.version;
    }

    public String getPlatform() {
        return this.platform;
    }

    public String getScope() {
        return this.scope;
    }

    public static class Builder {
        private CoordinateType coordType;
        private String coordinate1;
        private String coordinate2;
        private String version;
        private String platform;
        private String scope;

        public Builder withOtherCoordinates(Coordinates coordinates) {
            this.coordType = coordinates.coordType;
            this.coordinate1 = coordinates.coordinate1;
            this.coordinate2 = coordinates.coordinate2;
            this.version = coordinates.version;
            this.platform = coordinates.platform;
            this.scope = coordinates.scope;
            return this;
        }

        @Deprecated
        public Builder withBuildType(BuildType buildType) {
            this.coordType = buildType == null ? null : CoordinateType.toCoordType(buildType.name());
            return this;
        }

        public Builder withCoordinateType(CoordinateType coordType) {
            this.coordType = coordType;
            return this;
        }

        public Builder withCoordinates(String ... coords) {
            int len = coords.length;
            if (len < 1 || len > 2) {
                throw new IllegalArgumentException("Coordinates must be 1 or 2 in length");
            }
            this.coordinate1 = coords[0];
            if (len == 2) {
                this.coordinate2 = coords[1];
            }
            return this;
        }

        public Builder withCoordinate1(String coord1) {
            this.coordinate1 = coord1;
            return this;
        }

        public Builder withCoordinate2(String coord2) {
            this.coordinate2 = coord2;
            return this;
        }

        public Builder withVersion(String version) {
            this.version = version;
            return this;
        }

        public Builder withPlatform(String platform) {
            this.platform = platform;
            return this;
        }

        public Builder withScope(String scope) {
            this.scope = scope;
            return this;
        }

        public Coordinates build() {
            return new Coordinates(this);
        }
    }
}

