/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.api.data.git;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.Strings;
import com.sourceclear.api.data.git.RefType;
import java.io.Serializable;
import java.net.URI;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=Builder.class)
@Immutable
public class MetaGit
implements Serializable {
    private static final long serialVersionUID = 4L;
    private final URI localPath;
    private final String subPath;
    private final URI remote;
    private final String head;
    private final String refName;
    private final RefType refType;

    private MetaGit(Builder builder) {
        Objects.requireNonNull(builder.localPath, "MetaGit requires a non-null \"localPath\"");
        Objects.requireNonNull(builder.head, "MetaGit requires a non-null \"head\"");
        Objects.requireNonNull(builder.refType, "MetaGit requires a non-null \"refType\"");
        this.localPath = builder.localPath;
        this.subPath = Strings.nullToEmpty((String)builder.subPath);
        this.remote = builder.remote;
        this.head = builder.head;
        this.refName = builder.refName;
        this.refType = builder.refType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetaGit metaGit = (MetaGit)o;
        return Objects.equals(this.localPath, metaGit.localPath) && Objects.equals(this.subPath, metaGit.subPath) && Objects.equals(this.remote, metaGit.remote) && Objects.equals(this.head, metaGit.head) && Objects.equals(this.refName, metaGit.refName) && this.refType == metaGit.refType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.localPath, this.subPath, this.remote, this.head, this.refName, this.refType});
    }

    public String toString() {
        return new StringJoiner(", ", MetaGit.class.getSimpleName() + "[", "]").add("localPath=" + this.localPath).add("subPath='" + this.subPath + "'").add("remote=" + this.remote).add("head='" + this.head + "'").add("refName='" + this.refName + "'").add("refType=" + (Object)((Object)this.refType)).toString();
    }

    public URI getLocalPath() {
        return this.localPath;
    }

    @Nonnull
    public String getSubPath() {
        return this.subPath;
    }

    @Nullable
    public URI getRemote() {
        return this.remote;
    }

    @Nonnull
    public String getHead() {
        return this.head;
    }

    @Nonnull
    public String getRefName() {
        return this.refName;
    }

    @Nonnull
    public RefType getRefType() {
        return this.refType;
    }

    public static class Builder {
        private URI localPath;
        private String subPath;
        private URI remote;
        private String head;
        private String refName;
        private RefType refType;

        public Builder withLocalPath(URI localPath) {
            this.localPath = localPath;
            return this;
        }

        public Builder withSubPath(String subPath) {
            this.subPath = subPath;
            return this;
        }

        public Builder withRemote(URI remote) {
            this.remote = remote;
            return this;
        }

        public Builder withHead(String head) {
            this.head = head;
            return this;
        }

        public Builder withRefName(String refName) {
            this.refName = refName;
            return this;
        }

        public Builder withRefType(RefType refType) {
            this.refType = refType;
            return this;
        }

        public MetaGit build() {
            return new MetaGit(this);
        }
    }
}

