/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.api.data.match;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.sourceclear.api.data.evidence.Evidence;
import com.sourceclear.api.data.match.MatchQueryInternal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import java.util.stream.BaseStream;

abstract class MatchQueryInternal_Builder {
    private boolean vulnMethods;
    private List<Evidence> evidence = ImmutableList.of();
    private final EnumSet<Property> _unsetProperties = EnumSet.allOf(Property.class);

    MatchQueryInternal_Builder() {
    }

    public static MatchQueryInternal.Builder from(MatchQueryInternal value) {
        if (value instanceof Rebuildable) {
            return ((Rebuildable)value).toBuilder();
        }
        return new MatchQueryInternal.Builder().mergeFrom(value);
    }

    @JsonProperty(value="vulnMethods")
    public MatchQueryInternal.Builder vulnMethods(boolean vulnMethods) {
        this.vulnMethods = vulnMethods;
        this._unsetProperties.remove((Object)Property.VULN_METHODS);
        return (MatchQueryInternal.Builder)this;
    }

    public MatchQueryInternal.Builder mapVulnMethods(UnaryOperator<Boolean> mapper) {
        Objects.requireNonNull(mapper);
        return this.vulnMethods((Boolean)mapper.apply(this.vulnMethods()));
    }

    public boolean vulnMethods() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.VULN_METHODS) ? 1 : 0) != 0, (Object)"vulnMethods not set");
        return this.vulnMethods;
    }

    public MatchQueryInternal.Builder addEvidence(Evidence element) {
        if (this.evidence instanceof ImmutableList) {
            this.evidence = new ArrayList<Evidence>(this.evidence);
        }
        this.evidence.add(Objects.requireNonNull(element));
        return (MatchQueryInternal.Builder)this;
    }

    public MatchQueryInternal.Builder addEvidence(Evidence ... elements) {
        return this.addAllEvidence(Arrays.asList(elements));
    }

    public MatchQueryInternal.Builder addAllEvidence(Spliterator<? extends Evidence> elements) {
        long elementsSize;
        if ((elements.characteristics() & 0x40) != 0 && (elementsSize = elements.estimateSize()) > 0L && elementsSize <= Integer.MAX_VALUE) {
            if (this.evidence instanceof ImmutableList) {
                this.evidence = new ArrayList<Evidence>(this.evidence);
            }
            ((ArrayList)this.evidence).ensureCapacity(this.evidence.size() + (int)elementsSize);
        }
        elements.forEachRemaining(this::addEvidence);
        return (MatchQueryInternal.Builder)this;
    }

    public MatchQueryInternal.Builder addAllEvidence(BaseStream<? extends Evidence, ?> elements) {
        return this.addAllEvidence(elements.spliterator());
    }

    @JsonProperty(value="evidence")
    public MatchQueryInternal.Builder addAllEvidence(Iterable<? extends Evidence> elements) {
        return this.addAllEvidence(elements.spliterator());
    }

    public MatchQueryInternal.Builder mutateEvidence(Consumer<? super List<Evidence>> mutator) {
        if (this.evidence instanceof ImmutableList) {
            this.evidence = new ArrayList<Evidence>(this.evidence);
        }
        mutator.accept(this.evidence);
        return (MatchQueryInternal.Builder)this;
    }

    public MatchQueryInternal.Builder clearEvidence() {
        if (this.evidence instanceof ImmutableList) {
            this.evidence = ImmutableList.of();
        } else {
            this.evidence.clear();
        }
        return (MatchQueryInternal.Builder)this;
    }

    public List<Evidence> evidence() {
        if (this.evidence instanceof ImmutableList) {
            this.evidence = new ArrayList<Evidence>(this.evidence);
        }
        return Collections.unmodifiableList(this.evidence);
    }

    public MatchQueryInternal.Builder mergeFrom(MatchQueryInternal value) {
        MatchQueryInternal.Builder defaults = new MatchQueryInternal.Builder();
        if (defaults._unsetProperties.contains((Object)Property.VULN_METHODS) || value.vulnMethods() != ((MatchQueryInternal_Builder)defaults).vulnMethods()) {
            this.vulnMethods(value.vulnMethods());
        }
        if (value instanceof Value && this.evidence == ImmutableList.of()) {
            this.evidence = ImmutableList.copyOf(value.evidence());
        } else {
            this.addAllEvidence(value.evidence());
        }
        return (MatchQueryInternal.Builder)this;
    }

    public MatchQueryInternal.Builder mergeFrom(MatchQueryInternal.Builder template) {
        MatchQueryInternal.Builder base = template;
        MatchQueryInternal.Builder defaults = new MatchQueryInternal.Builder();
        if (!base._unsetProperties.contains((Object)Property.VULN_METHODS) && (defaults._unsetProperties.contains((Object)Property.VULN_METHODS) || template.vulnMethods() != ((MatchQueryInternal_Builder)defaults).vulnMethods())) {
            this.vulnMethods(template.vulnMethods());
        }
        this.addAllEvidence(base.evidence);
        return (MatchQueryInternal.Builder)this;
    }

    public MatchQueryInternal.Builder clear() {
        MatchQueryInternal.Builder defaults = new MatchQueryInternal.Builder();
        this.vulnMethods = defaults.vulnMethods;
        this.clearEvidence();
        this._unsetProperties.clear();
        this._unsetProperties.addAll(defaults._unsetProperties);
        return (MatchQueryInternal.Builder)this;
    }

    public MatchQueryInternal build() {
        Preconditions.checkState((boolean)this._unsetProperties.isEmpty(), (String)"Not set: %s", this._unsetProperties);
        return new Value(this);
    }

    @VisibleForTesting
    public MatchQueryInternal buildPartial() {
        return new Partial(this);
    }

    private static final class Partial
    extends Rebuildable {
        private final boolean vulnMethods;
        private final ImmutableList<Evidence> evidence;
        private final EnumSet<Property> _unsetProperties;

        Partial(MatchQueryInternal_Builder builder) {
            this.vulnMethods = builder.vulnMethods;
            this.evidence = ImmutableList.copyOf((Collection)builder.evidence);
            this._unsetProperties = builder._unsetProperties.clone();
        }

        @Override
        @JsonProperty(value="vulnMethods")
        public boolean vulnMethods() {
            if (this._unsetProperties.contains((Object)Property.VULN_METHODS)) {
                throw new UnsupportedOperationException("vulnMethods not set");
            }
            return this.vulnMethods;
        }

        @Override
        @JsonProperty(value="evidence")
        public Collection<Evidence> evidence() {
            return this.evidence;
        }

        @Override
        public MatchQueryInternal.Builder toBuilder() {
            PartialBuilder builder = new PartialBuilder();
            ((MatchQueryInternal_Builder)builder).vulnMethods = this.vulnMethods;
            ((MatchQueryInternal_Builder)builder).evidence = this.evidence;
            ((MatchQueryInternal_Builder)builder)._unsetProperties.clear();
            ((MatchQueryInternal_Builder)builder)._unsetProperties.addAll(this._unsetProperties);
            return builder;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Partial)) {
                return false;
            }
            Partial other = (Partial)obj;
            return this.vulnMethods == other.vulnMethods && Objects.equals(this.evidence, other.evidence) && Objects.equals(this._unsetProperties, other._unsetProperties);
        }

        public int hashCode() {
            return Objects.hash(this.vulnMethods, this.evidence, this._unsetProperties);
        }

        public String toString() {
            StringBuilder result = new StringBuilder("partial MatchQueryInternal{");
            if (!this._unsetProperties.contains((Object)Property.VULN_METHODS)) {
                result.append("vulnMethods=").append(this.vulnMethods).append(", ");
            }
            return result.append("evidence=").append(this.evidence).append("}").toString();
        }

        private static class PartialBuilder
        extends MatchQueryInternal.Builder {
            private PartialBuilder() {
            }

            @Override
            public MatchQueryInternal build() {
                return this.buildPartial();
            }
        }
    }

    private static final class Value
    extends Rebuildable {
        private final boolean vulnMethods;
        private final ImmutableList<Evidence> evidence;

        private Value(MatchQueryInternal_Builder builder) {
            this.vulnMethods = builder.vulnMethods;
            this.evidence = ImmutableList.copyOf((Collection)builder.evidence);
        }

        @Override
        @JsonProperty(value="vulnMethods")
        public boolean vulnMethods() {
            return this.vulnMethods;
        }

        @Override
        @JsonProperty(value="evidence")
        public Collection<Evidence> evidence() {
            return this.evidence;
        }

        @Override
        public MatchQueryInternal.Builder toBuilder() {
            MatchQueryInternal.Builder builder = new MatchQueryInternal.Builder();
            ((MatchQueryInternal_Builder)builder).vulnMethods = this.vulnMethods;
            ((MatchQueryInternal_Builder)builder).evidence = this.evidence;
            ((MatchQueryInternal_Builder)builder)._unsetProperties.clear();
            return builder;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Value)) {
                return false;
            }
            Value other = (Value)obj;
            return this.vulnMethods == other.vulnMethods && Objects.equals(this.evidence, other.evidence);
        }

        public int hashCode() {
            return Objects.hash(this.vulnMethods, this.evidence);
        }

        public String toString() {
            return "MatchQueryInternal{vulnMethods=" + this.vulnMethods + ", evidence=" + this.evidence + "}";
        }
    }

    private static abstract class Rebuildable
    implements MatchQueryInternal {
        private Rebuildable() {
        }

        public abstract MatchQueryInternal.Builder toBuilder();
    }

    private static enum Property {
        VULN_METHODS("vulnMethods");

        private final String name;

        private Property(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

