/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.api.data.methods;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Strings;
import com.sourceclear.api.data.evidence.LibraryModel;
import com.sourceclear.api.data.methods.MethodCallData;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@Deprecated
@JsonIgnoreProperties(ignoreUnknown=true)
@NotThreadSafe
public class ComponentMethodMapper
implements Iterable<ComponentContext> {
    private static final String DELIMITER = ":::";
    @JsonProperty(value="components")
    private Map<Long, Map<String, Collection<MethodCallData>>> map = new HashMap<Long, Map<String, Collection<MethodCallData>>>();
    @JsonIgnore
    private Collection<MethodCallData> allVulnerableMethods;

    public ComponentContext componentContext(Long componentId) {
        HashMap context = new HashMap();
        if (this.map.put(componentId, context) != null) {
            throw new IllegalStateException("mapping duplicate componentId: " + componentId);
        }
        return new ComponentContext(componentId, context);
    }

    @JsonIgnore
    public Map<String, Collection<MethodCallData>> getComponentMethodData(Long componentId) {
        Map<String, Collection<MethodCallData>> componentMethodData = this.map.get(componentId);
        return componentMethodData != null ? Collections.unmodifiableMap(componentMethodData) : null;
    }

    @JsonIgnore
    public Map<String, Collection<MethodCallData>> getComponentMethodData(LibraryModel component) {
        return this.getComponentMethodData(component.getId());
    }

    @JsonIgnore
    public Collection<MethodCallData> getAllVulnerableMethods() {
        if (this.allVulnerableMethods == null) {
            HashSet<MethodCallData> result = new HashSet<MethodCallData>();
            for (Map<String, Collection<MethodCallData>> componentVulnMethods : this.map.values()) {
                for (Collection<MethodCallData> versionVulnMethods : componentVulnMethods.values()) {
                    result.addAll(versionVulnMethods);
                }
            }
            this.allVulnerableMethods = Collections.unmodifiableCollection(result);
        }
        return this.allVulnerableMethods;
    }

    @JsonIgnore
    public boolean isEmpty() {
        return this.getAllVulnerableMethods().isEmpty();
    }

    @Override
    public Iterator<ComponentContext> iterator() {
        return new Iterator<ComponentContext>(){
            private final Iterator<Map.Entry<Long, Map<String, Collection<MethodCallData>>>> iter;
            {
                this.iter = ComponentMethodMapper.this.map.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public ComponentContext next() {
                Map.Entry<Long, Map<String, Collection<MethodCallData>>> entry = this.iter.next();
                return new ComponentContext(entry.getKey(), entry.getValue());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @JsonIgnore
    public Map<Long, Map<String, Collection<MethodCallData>>> getComponentMap() {
        return Collections.unmodifiableMap(this.map);
    }

    public class VersionMethodData {
        private final String version;
        private final String platform;
        private final Collection<MethodCallData> methodCallData;

        private VersionMethodData(String version, String platform, Collection<MethodCallData> methodCallData) {
            this.version = this.splitVersionFromString(version);
            this.platform = !Strings.isNullOrEmpty((String)platform) ? platform : this.splitPlatformFromString(version);
            this.methodCallData = methodCallData;
        }

        public String getVersion() {
            return this.version;
        }

        @Nullable
        public String getPlatform() {
            return this.platform;
        }

        public Collection<MethodCallData> getMethodCallData() {
            return Collections.unmodifiableCollection(this.methodCallData);
        }

        private String splitVersionFromString(String version) {
            return version.split(ComponentMethodMapper.DELIMITER)[0];
        }

        private String splitPlatformFromString(String version) {
            String[] p = version.split(ComponentMethodMapper.DELIMITER);
            if (p.length > 1) {
                return p[1];
            }
            return null;
        }
    }

    public class ComponentContext
    implements Iterable<VersionMethodData> {
        private final Long componentId;
        private final Map<String, Collection<MethodCallData>> context;

        private ComponentContext(Long componentId, Map<String, Collection<MethodCallData>> context) {
            this.componentId = componentId;
            this.context = context;
        }

        public Long getComponentId() {
            return this.componentId;
        }

        @Override
        public Iterator<VersionMethodData> iterator() {
            return new Iterator<VersionMethodData>(){
                private final Iterator<Map.Entry<String, Collection<MethodCallData>>> iter;
                {
                    this.iter = ComponentContext.this.context.entrySet().iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.iter.hasNext();
                }

                @Override
                public VersionMethodData next() {
                    Map.Entry<String, Collection<MethodCallData>> entry = this.iter.next();
                    return new VersionMethodData(entry.getKey(), null, entry.getValue());
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }
}

