/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.bytecode.v2;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.sourceclear.bytecode.InputStreamGenerator;
import com.sourceclear.bytecode.JarInputStreamGenerator;
import com.sourceclear.bytecode.Util;
import com.sourceclear.bytecode.v2.ClassFingerprint;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarInputStream;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Hex;

public class CompFingerprint {
    private Map<String, JarInputStreamGenerator> jarMap = Maps.newHashMap();
    private Map<String, ClassFingerprint> classMap = Maps.newHashMap();

    public CompFingerprint() {
        this(new HashMap<String, ClassFingerprint>());
    }

    public CompFingerprint(Map<String, ClassFingerprint> classMap) {
        this.classMap = classMap;
    }

    public void read(InputStream is) throws IOException {
        JarInputStream jis = new JarInputStream(is);
        for (Map.Entry<String, InputStreamGenerator> entry : Util.readEntries(jis).entrySet()) {
            if (Util.hasJarExtension(new File(entry.getKey()))) {
                this.jarMap.put(entry.getKey(), (JarInputStreamGenerator)entry.getValue());
                continue;
            }
            ClassFingerprint classSig = new ClassFingerprint(entry.getValue());
            this.classMap.put(entry.getKey(), classSig);
        }
    }

    public String hash() {
        ArrayList classHashes = Lists.newArrayList();
        List sortedNames = this.classMap.keySet().stream().sorted().collect(Collectors.toList());
        for (String classFileName : sortedNames) {
            byte[] classSig = this.classMap.get(classFileName).hash();
            classHashes.add(classSig);
        }
        return classHashes.isEmpty() ? null : Hex.encodeHexString((byte[])Util.hashBytes(classHashes));
    }

    public Map<String, ClassFingerprint> getClassMap() {
        return this.classMap;
    }

    public Map<String, JarInputStreamGenerator> getJarMap() {
        return this.jarMap;
    }
}

