/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.common;

import com.sourceclear.engine.common.ProcessNonZeroRCException;
import com.veracode.security.logging.SecureLogger;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class ProcessUtils {
    private static final SecureLogger LOGGER = SecureLogger.getLogger(ProcessUtils.class);

    public static String launchProcess(@Nonnull File workingDirectory, @Nonnull List<String> command, @Nonnull Map<String, String> additionalEnvVars) throws IOException, InterruptedException, ProcessNonZeroRCException {
        String output;
        ProcessBuilder processBuilder = ProcessUtils.basicProcessBuilder(workingDirectory, command);
        processBuilder.redirectErrorStream(true);
        String commandString = ProcessUtils.render(command);
        LOGGER.debug("Launching process with command: {} in directory {}", (Object)commandString, (Object)workingDirectory);
        processBuilder.environment().putAll(additionalEnvVars);
        Process process = processBuilder.start();
        try (OutputStream outputStream2 = process.getOutputStream();){
            if (outputStream2 != null) {
                outputStream2.close();
            }
        }
        catch (IOException outputStream2) {
            // empty catch block
        }
        try (InputStream inputStream = process.getInputStream();){
            output = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
        }
        int rc = process.waitFor();
        if (rc != 0) {
            LOGGER.debug("Process exited with non-zero rc: {}", (Object)rc);
            throw new ProcessNonZeroRCException(String.format("Process '%s' exited with non-zero rc.", commandString), output, rc);
        }
        return output;
    }

    public static String launchProcess(@Nonnull List<String> command) throws IOException, InterruptedException, ProcessNonZeroRCException {
        Path workDir = Paths.get(System.getProperty("user.dir"), new String[0]);
        if (workDir.toAbsolutePath().normalize().equals(workDir)) {
            return ProcessUtils.launchProcess(workDir.toFile(), command, Collections.emptyMap());
        }
        throw new SecurityException("Unacceptable path: " + workDir);
    }

    public static int launchProcess(@Nonnull List<String> command, Consumer<String> logger) throws IOException, InterruptedException {
        Path workDir = Paths.get(System.getProperty("user.dir"), new String[0]);
        if (workDir.toAbsolutePath().normalize().equals(workDir)) {
            return ProcessUtils.launchProcess(workDir.toFile(), command, logger);
        }
        throw new SecurityException("Unacceptable working directory: " + workDir);
    }

    public static String launchProcess(String ... command) throws IOException, InterruptedException, ProcessNonZeroRCException {
        return ProcessUtils.launchProcess(Arrays.asList(command));
    }

    public static int launchProcess(File workingDirectory, List<String> command, Consumer<String> logger) throws IOException, InterruptedException {
        return ProcessUtils.launchProcess(workingDirectory, new HashMap<String, String>(), command, logger);
    }

    public static int launchProcess(File workingDirectory, Map<String, String> environment, List<String> command, Consumer<String> logger) throws IOException, InterruptedException {
        ProcessBuilder processBuilder = ProcessUtils.basicProcessBuilder(workingDirectory, command);
        environment.forEach((key, value) -> processBuilder.environment().put((String)key, (String)value));
        processBuilder.redirectErrorStream(true);
        String commandString = command.stream().collect(Collectors.joining(" "));
        LOGGER.debug("Launching process with command: {}", (Object)commandString);
        Process process = processBuilder.start();
        process.getOutputStream().close();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                logger.accept(line);
            }
        }
        return process.waitFor();
    }

    public static String launchProcess(@Nonnull File workingDirectory, @Nonnull List<String> command) throws IOException, InterruptedException, ProcessNonZeroRCException {
        return ProcessUtils.launchProcess(workingDirectory, command, Collections.emptyMap());
    }

    public static String render(List<String> command) {
        return ProcessUtils.render(command.stream());
    }

    public static String render(String[] command) {
        return ProcessUtils.render(Arrays.stream(command));
    }

    private static String render(Stream<String> command) {
        return command.map(c -> {
            if (c.contains(" ")) {
                return StringUtils.wrap((String)c, (String)"'");
            }
            return c;
        }).collect(Collectors.joining(" "));
    }

    private static ProcessBuilder basicProcessBuilder(@Nonnull File workingDirectory, @Nonnull List<String> command) {
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        processBuilder.command(command);
        processBuilder.directory(workingDirectory);
        return processBuilder;
    }
}

