/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.scan;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.sourceclear.api.client.Client;
import com.sourceclear.api.client.SourceClearClient;
import com.sourceclear.api.data.PlanType;
import com.sourceclear.api.data.ScanType;
import com.sourceclear.api.data.analytics.AgentRuntimeData;
import com.sourceclear.api.data.evidence.CoordinateType;
import com.sourceclear.api.data.evidence.Coordinates;
import com.sourceclear.api.data.evidence.Evidence;
import com.sourceclear.api.data.evidence.EvidenceType;
import com.sourceclear.api.data.evidence.LanguageType;
import com.sourceclear.api.data.git.GitCommit;
import com.sourceclear.api.data.git.MetaGit;
import com.sourceclear.api.data.match.MatchResponse;
import com.sourceclear.api.data.match.ScanFinishUploadResponse;
import com.sourceclear.api.data.methods.CallChainModel;
import com.sourceclear.api.data.methods.InstanceVulnMethod;
import com.sourceclear.engine.common.ClassFileVisitor;
import com.sourceclear.engine.common.CollectionResult;
import com.sourceclear.engine.common.FileTypeVisitor;
import com.sourceclear.engine.common.PythonFileVisitor;
import com.sourceclear.engine.common.StoredFileVisitor;
import com.sourceclear.engine.common.linecount.LineCounter;
import com.sourceclear.engine.common.logging.NoopLogStream;
import com.sourceclear.engine.methods.VulnerableMethodsCollator;
import com.sourceclear.engine.methods.VulnerableMethodsCollatorImpl;
import com.sourceclear.engine.scan.PlatformScan;
import com.sourceclear.engine.scan.SrcclrScanFailureException;
import com.sourceclear.engine.scan.SrcclrScanUnexpectedCondition;
import com.sourceclear.methods.CallSite;
import com.sourceclear.util.config.FailureLevel;
import com.sourceclear.util.config.ScanConfig;
import com.sourceclear.util.config.Verbosity;
import com.sourceclear.util.io.EvidenceUtils;
import com.sourceclear.util.io.GitUtils;
import com.sourceclear.util.io.renderers.ScanReport;
import com.sourceclear.util.io.renderers.SummaryRenderer;
import com.srcclr.sdk.LibraryGraphContainer;
import com.veracode.security.logging.SecureLogger;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class LibraryGraphContainerScanner {
    private static final SecureLogger LOGGER = SecureLogger.getLogger(LibraryGraphContainerScanner.class);
    private final ScanConfig config;
    private final Client client;
    private final boolean withPolicy;

    public LibraryGraphContainerScanner(@Nonnull ScanConfig config) {
        this.config = config;
        this.withPolicy = false;
        this.client = LibraryGraphContainerScanner.buildClient(this.config);
    }

    public LibraryGraphContainerScanner(@Nonnull ScanConfig config, @Nonnull Client sourceClearClient) {
        this(config, sourceClearClient, false);
    }

    public LibraryGraphContainerScanner(@Nonnull ScanConfig config, @Nonnull Client sourceClearClient, boolean withPolicy) {
        this.config = config;
        this.client = sourceClearClient;
        this.withPolicy = withPolicy;
    }

    public void consumeAndReport(LibraryGraphContainer projectDependencyTrees) throws SrcclrScanFailureException, SrcclrScanUnexpectedCondition {
        String policyExitMessage;
        Integer policyExitCode;
        MetaGit metaGit;
        ImmutableSet evidence = ImmutableSet.copyOf(EvidenceUtils.evidenceFromLibraryGraphs(projectDependencyTrees.getGraphs()));
        String pathToTop = this.config.getPathToTop().toString();
        boolean doVulnMethods = this.isMethodsSupported(pathToTop, (ImmutableSet<Evidence>)evidence);
        if (!doVulnMethods) {
            LOGGER.debug("No files found in {}. Skipping vulnerable methods check.", (Object)pathToTop);
        }
        long loc = this.countLoc();
        AgentRuntimeData agentRuntimeData = this.fillInAgentRuntimeDataForPlugins();
        CollectionResult collectionResult = new CollectionResult.Builder().withMethodsSupported(doVulnMethods).withLineCount(loc).withGraphs(projectDependencyTrees).withAgentRuntimeData(this.withPolicy ? null : agentRuntimeData).build();
        try {
            metaGit = this.getMetaGit();
        }
        catch (Exception ex) {
            throw new SrcclrScanUnexpectedCondition("An error occurred while getting the git data for this project.", ex);
        }
        boolean shouldUpload = GitUtils.isValidRemote(metaGit.getRemote()) && this.config.getUpload();
        MatchResponse response = this.match(collectionResult, metaGit, shouldUpload, null, null);
        Map<CallChainModel, CallSite> spanningEdges = null;
        List<InstanceVulnMethod> vulnMethods = null;
        Optional<Object> scanFinishUploadResponse = Optional.empty();
        if (this.withPolicy || doVulnMethods && response.isVulnMethods()) {
            VulnerableMethodsCollator.Result result = this.doVulnMethodsScan(response, (Multimap<LanguageType, CallSite>)MultimapBuilder.hashKeys().hashSetValues().build(), collectionResult.getScanAttributes());
            vulnMethods = result.vulnerableMethods;
            spanningEdges = result.spanningEdges;
            if (this.config.getUpload()) {
                scanFinishUploadResponse = this.finishScan(response.getScanId(), vulnMethods, agentRuntimeData);
            } else if (this.withPolicy) {
                scanFinishUploadResponse = Optional.of(new ScanFinishUploadResponse.Builder().withExitCode(0).withIssues("").withMessage("You specified upload=false. Issues were not created as a result.").build());
            }
        } else {
            LOGGER.debug("Skipping vulnerable methods scanning.");
        }
        ScanReport report = this.buildReport((ImmutableSet<Evidence>)evidence, vulnMethods, spanningEdges, response, loc, scanFinishUploadResponse.orElse(null));
        this.renderReport(report);
        if (this.withPolicy && !scanFinishUploadResponse.isPresent()) {
            throw new SrcclrScanUnexpectedCondition("There was an error saving your scan data. Please try scanning again.");
        }
        if (scanFinishUploadResponse.isPresent()) {
            ScanFinishUploadResponse scanFinishUploadResponseObj = (ScanFinishUploadResponse)scanFinishUploadResponse.get();
            policyExitCode = scanFinishUploadResponseObj.getExitCode();
            policyExitMessage = scanFinishUploadResponseObj.getMessage();
        } else {
            policyExitCode = null;
            policyExitMessage = null;
        }
        if (policyExitCode != null) {
            this.config.getFailureThreshold().ifPresent(v -> System.out.printf("NOTICE: You set the failure level to '%s'. This configuration is now deprecated.%nFailure values are determined by Custom Policies, available to Enterprise organizations.%nFor information about upgrading to Enterprise, call 1-888-ZER-0DAY (937-0329) or +44 (0)20 3761 5501 (UK).%nIf you need assistance, please contact support@veracode.com.%n", v));
            this.maybeFailOnPolicy(policyExitCode, StringUtils.trimToEmpty((String)policyExitMessage));
        } else {
            this.maybeFailOnVulns(this.config.getFailureThreshold().orElse(FailureLevel.METHOD), report.getVulnerableMethods(), report.getVulnerableComponents());
        }
    }

    public MatchResponse match(@Nonnull CollectionResult collectionResult, @Nonnull MetaGit metaGit, boolean shouldUpload, @Nullable AgentRuntimeData agentRuntimeData, ImmutableSet<GitCommit> commitLog) throws SrcclrScanUnexpectedCondition {
        return PlatformScan.match(this.client, this.config, collectionResult, metaGit, shouldUpload, agentRuntimeData, commitLog);
    }

    public void completeForFailedScans(@Nonnull MetaGit metaGit, boolean shouldUpload, @Nonnull AgentRuntimeData agentRuntimeData) throws SrcclrScanUnexpectedCondition {
        PlatformScan.completeForFailedRepoScans(this.client, this.config, metaGit, shouldUpload, agentRuntimeData);
    }

    public VulnerableMethodsCollator.Result doVulnMethodsScan(MatchResponse response, Multimap<LanguageType, CallSite> additionalEdges, ImmutableMap<String, Object> scanAttributes) {
        VulnerableMethodsCollatorImpl collator = new VulnerableMethodsCollatorImpl(response.getComponents(), scanAttributes, additionalEdges, new NoopLogStream());
        return collator.scanPath(this.config.getPathToTop().toPath());
    }

    public Optional<ScanFinishUploadResponse> finishScan(String scanId, List<InstanceVulnMethod> vulnMethods, @Nonnull AgentRuntimeData agentRuntimeData) {
        return PlatformScan.finishScan(this.client, this.withPolicy, scanId, vulnMethods, agentRuntimeData);
    }

    private void maybeFailOnPolicy(int exitCode, @Nonnull String exitMessage) throws SrcclrScanFailureException {
        System.out.println(exitMessage);
        if (exitCode > 0) {
            throw new SrcclrScanFailureException(exitMessage);
        }
    }

    void maybeFailOnVulns(FailureLevel failureThreshold, Integer optVulnMethodCount, int vulnComponentCount) throws SrcclrScanFailureException {
        FailureLevel failureLevel = null;
        if (optVulnMethodCount != null && optVulnMethodCount > 0) {
            failureLevel = FailureLevel.METHOD;
        } else if (vulnComponentCount > 0) {
            failureLevel = FailureLevel.COMPONENT;
        }
        if (failureLevel != null && failureLevel.compareTo(failureThreshold) >= 0) {
            throw new SrcclrScanFailureException("The current scan found vulnerable " + failureLevel.toString().toLowerCase() + "s, failing as failureThreshold is set to " + (Object)((Object)failureThreshold) + ".");
        }
    }

    private void renderReport(ScanReport report) {
        Verbosity verbosity = this.config.getReportVerbosity();
        if (verbosity == Verbosity.SILENT) {
            return;
        }
        String clientVersion = this.config.getClientVersion() != null ? this.config.getClientVersion() : "Unknown";
        new SummaryRenderer(clientVersion, "Unknown", System.out, this.withPolicy).accept(report);
    }

    private ScanReport buildReport(ImmutableSet<Evidence> evidence, List<InstanceVulnMethod> methodScanResult, Map<CallChainModel, CallSite> spanningEdges, MatchResponse response, @Nullable Long loc, @Nullable ScanFinishUploadResponse scanFinishUploadResponse) {
        ScanReport.Builder reportBuilder = new ScanReport.Builder().withScanType(ScanType.REPO).withScanConfig(this.config).withAppBase(URI.create("https://srcclr.com")).withScanPath(this.config.getPathToTop().toString()).withDuration((System.currentTimeMillis() - this.config.getScanStart()) / 1000L).withEvidence((Collection<Evidence>)evidence).withMatchResponse(response).withMethodScanResult(methodScanResult, spanningEdges).withUpload(this.config.getUpload()).withLineCount(loc);
        if (scanFinishUploadResponse != null) {
            reportBuilder.withScanFinishUploadResponse(scanFinishUploadResponse);
        }
        return reportBuilder.build();
    }

    private static Client buildClient(ScanConfig config) {
        SourceClearClient.Builder clientBuilder = new SourceClearClient.Builder().withApiToken(config.getApiToken()).withBaseURI(config.getApiURL()).withClientType(SourceClearClient.Type.CLI).withClientVersion(config.getClientVersion()).withExpBackOffInitial(5);
        return clientBuilder.build();
    }

    private long countLoc() {
        try {
            return LineCounter.countLOC(this.config.getPathToTop(), this.client);
        }
        catch (Throwable t) {
            LOGGER.error("Skipping counting lines-of-code because an exception occurred:", t);
            return 0L;
        }
    }

    private Map<String, String> getEnv() {
        HashMap<String, String> env = new HashMap<String, String>(System.getenv());
        if (this.isLicensedForGenericSCM()) {
            env.put("__WITHOUT_GIT__", "1");
        }
        return env;
    }

    MetaGit getMetaGit() throws Exception {
        return GitUtils.getGitMetaData(this.config.getPathToTop(), this.getEnv());
    }

    private boolean isLicensedForGenericSCM() {
        PlanType planType = Optional.ofNullable(this.config.getLicenseData().getPlanType()).orElse(PlanType.OPEN);
        return planType.compareTo(PlanType.TRIAL) >= 0;
    }

    private boolean isMethodsSupported(String projectRoot, ImmutableSet<Evidence> evidence) {
        if (evidence == null || evidence.size() == 0) {
            return false;
        }
        for (Evidence ev : evidence) {
            LanguageType languageType;
            CoordinateType coordinateType;
            if (ev.getEvidenceType() == EvidenceType.JAR) {
                Optional<FileTypeVisitor> fileVisitor = this.getVulnMethodVisitorForLanguageType(LanguageType.JAVA);
                return fileVisitor.isPresent() && this.internalIsMethodsSupported(projectRoot, fileVisitor.get());
            }
            Coordinates coordinates = ev.getCoordinates();
            if (coordinates == null || (coordinateType = coordinates.getCoordinateType()) == null || (languageType = coordinateType.getPrimaryLanguage()) == null) continue;
            Optional<FileTypeVisitor> fileVisitor = this.getVulnMethodVisitorForLanguageType(languageType);
            return fileVisitor.isPresent() && this.internalIsMethodsSupported(projectRoot, fileVisitor.get());
        }
        return false;
    }

    private boolean internalIsMethodsSupported(@Nonnull String projectRoot, @Nonnull StoredFileVisitor storedFileVisitor) {
        try {
            Files.walkFileTree(Paths.get(projectRoot, new String[0]), storedFileVisitor);
            return !storedFileVisitor.getFiles().isEmpty();
        }
        catch (Exception ex) {
            LOGGER.error("Unable to determine vulnerable methods support due to exception:", ex);
            return false;
        }
    }

    private Optional<FileTypeVisitor> getVulnMethodVisitorForLanguageType(@Nonnull LanguageType languageType) {
        switch (languageType) {
            case JAVA: {
                return Optional.of(ClassFileVisitor.getVisitor());
            }
            case PYTHON: {
                return Optional.of(PythonFileVisitor.getVisitor());
            }
        }
        return Optional.empty();
    }

    private AgentRuntimeData fillInAgentRuntimeDataForPlugins() {
        return new AgentRuntimeData.Builder().setAgentType(this.config.getClientType() != null ? this.config.getClientType().name() : "").setAgentVersion(StringUtils.trimToEmpty((String)this.config.getClientVersion())).setJVMVersion(System.getProperty("java.runtime.version", System.getProperty("java.version", "UNKNOWN"))).setOS(System.getProperty("os.name", "UNKNOWN")).setOSVersion(System.getProperty("os.version", "UNKNOWN")).build();
    }
}

