/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.methods;

import com.sourceclear.analysis.latte.frameworks.Frameworks;
import com.sourceclear.methods.CallChainsInspector;
import com.sourceclear.methods.CallGraph;
import com.sourceclear.methods.CallSite;
import com.sourceclear.methods.MethodInfo;
import com.sourceclear.methods.VulnMethodsInput;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jgrapht.Graph;
import org.jgrapht.event.ConnectedComponentTraversalEvent;
import org.jgrapht.event.EdgeTraversalEvent;
import org.jgrapht.event.TraversalListener;
import org.jgrapht.event.VertexTraversalEvent;
import org.jgrapht.graph.DirectedPseudograph;
import org.jgrapht.traverse.DepthFirstIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CallGraphBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(CallGraphBuilder.class);
    private Set<MethodInfo> frameworkEntryPoints;
    private Set<MethodInfo> appVertices;
    private Set<CallSite> appEdges;
    protected Set<Frameworks.Module> frameworkMethods;

    public void build(VulnMethodsInput input) throws IOException {
        this.frameworkMethods = input.frameworkMethods();
        this.build();
        this.appVertices = this.getCallGraph().vertices().collect(Collectors.toSet());
        this.appEdges = this.getCallGraph().edges().collect(Collectors.toSet());
        CallGraph callGraph = this.getCallGraph();
        LOGGER.debug("initial static call graph: {} vertices, {} edges", (Object)callGraph.vertices().count(), (Object)callGraph.edges().count());
        CallChainsInspector.printDotGraph(callGraph, "staticGraph");
        this.addDynamicEdges(input, callGraph);
        this.augmentCallGraph(input, callGraph);
        CallChainsInspector.printDotGraph(callGraph, "withDynamic");
        LOGGER.debug("with dynamic call graph: {} vertices, {} edges", (Object)callGraph.vertices().count(), (Object)callGraph.edges().count());
        CallGraphBuilder.addStaticEdges(input, callGraph);
        CallChainsInspector.printDotGraph(callGraph, "withCallChain");
        LOGGER.debug("with call chains: {} vertices, {} edges", (Object)callGraph.vertices().count(), (Object)callGraph.edges().count());
    }

    protected abstract void build() throws IOException;

    public abstract CallGraph getCallGraph();

    public abstract Set<MethodInfo> getMethodsDefined();

    public boolean isTestMethod(MethodInfo m) {
        return false;
    }

    protected void augmentCallGraph(VulnMethodsInput input, CallGraph callGraph) {
    }

    public boolean isTestFrameworkEntryPoint(CallSite callSite) {
        return false;
    }

    private static void addStaticEdges(VulnMethodsInput input, CallGraph callGraph) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("static call chains: {} edges, {} vertices", (Object)input.staticCallChains().size(), (Object)input.staticCallChains().stream().flatMap(c -> c.stream().flatMap(cc -> Stream.of(cc.getCallee(), cc.getCaller()))).distinct().count());
        }
        int addedCount = 0;
        for (List<CallSite> chain : input.staticCallChains()) {
            boolean addAll = false;
            for (CallSite callSite : chain) {
                if (addAll) {
                    if (!callGraph.addEdge(callSite)) continue;
                    ++addedCount;
                    continue;
                }
                if (!callGraph.containsVertex(callSite.getCaller()) || !callGraph.addEdge(callSite)) continue;
                ++addedCount;
                addAll = true;
            }
        }
        LOGGER.debug("added {} call sites from platform call chains", (Object)addedCount);
    }

    private void addDynamicEdges(VulnMethodsInput input, CallGraph callGraph) {
        DirectedPseudograph dynamic = new DirectedPseudograph(CallSite.class);
        input.dynamicEdges().forEach(arg_0 -> CallGraphBuilder.lambda$addDynamicEdges$2((Graph)dynamic, arg_0));
        CallChainsInspector.printDotGraph((Graph<MethodInfo, CallSite>)dynamic, "pureDynamic");
        this.frameworkEntryPoints = dynamic.edgeSet().stream().filter(this::isTestFrameworkEntryPoint).map(CallSite::getCallee).collect(Collectors.toSet());
        LOGGER.debug("framework entry points: {}", (Object)this.frameworkEntryPoints.size());
        int[] dynamicCount = new int[1];
        this.frameworkEntryPoints.forEach(arg_0 -> this.lambda$addDynamicEdges$4((Graph)dynamic, callGraph, dynamicCount, arg_0));
        LOGGER.debug("added {} edges", (Object)dynamicCount[0]);
    }

    public Set<MethodInfo> getFrameworkEntryPoints() {
        return this.frameworkEntryPoints;
    }

    public Set<MethodInfo> getAppVertices() {
        return this.appVertices;
    }

    public Set<CallSite> getAppEdges() {
        return this.appEdges;
    }

    private /* synthetic */ void lambda$addDynamicEdges$4(final Graph dynamic, final CallGraph callGraph, final int[] dynamicCount, MethodInfo caller) {
        DepthFirstIterator dfs = new DepthFirstIterator(dynamic, (Object)caller);
        dfs.addTraversalListener((TraversalListener)new TraversalListener<MethodInfo, CallSite>(){

            public void edgeTraversed(EdgeTraversalEvent<CallSite> e) {
                if (((CallSite)e.getEdge()).getCallee().equals(((CallSite)e.getEdge()).getCaller()) && !dynamic.containsEdge((Object)((CallSite)e.getEdge()))) {
                    return;
                }
                if (callGraph.addEdge((CallSite)e.getEdge())) {
                    dynamicCount[0] = dynamicCount[0] + 1;
                }
            }

            public void connectedComponentFinished(ConnectedComponentTraversalEvent e) {
            }

            public void connectedComponentStarted(ConnectedComponentTraversalEvent e) {
            }

            public void vertexTraversed(VertexTraversalEvent<MethodInfo> e) {
            }

            public void vertexFinished(VertexTraversalEvent<MethodInfo> e) {
            }
        });
        dfs.forEachRemaining(i -> {});
    }

    private static /* synthetic */ void lambda$addDynamicEdges$2(Graph dynamic, CallSite e) {
        dynamic.addVertex((Object)e.getCaller());
        dynamic.addVertex((Object)e.getCallee());
        dynamic.addEdge((Object)e.getCaller(), (Object)e.getCallee(), (Object)e);
    }
}

