/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.methods;

import com.google.common.collect.Sets;
import com.sourceclear.methods.CallChain;
import com.sourceclear.methods.CallGraph;
import com.sourceclear.methods.CallSite;
import com.sourceclear.methods.MethodInfo;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface MethodScanner
extends Closeable {
    public static final Logger LOGGER = LoggerFactory.getLogger(MethodScanner.class);

    public VMReport scan() throws IOException;

    public Set<MethodInfo> reachableMethods(Set<MethodInfo> var1) throws IOException;

    public boolean vulnerableMethodsAreDefined() throws IOException;

    public CallGraph getCallGraph();

    public static class VMReport {
        public final Map<MethodInfo, Collection<CallChain>> callChains;
        public final Map<CallChain, CallSite> spanningEdges;

        public VMReport(Map<MethodInfo, Collection<CallChain>> callChains, Map<CallChain, CallSite> spanningEdges) {
            this.callChains = callChains;
            this.spanningEdges = spanningEdges;
        }

        public VMReport combine(VMReport other) {
            VMReport.mergeMapKeys(this.callChains, other.callChains);
            if (!Sets.intersection(this.spanningEdges.keySet(), other.spanningEdges.keySet()).isEmpty()) {
                LOGGER.debug("spanning edges overlap: {}, {}", this.spanningEdges.keySet(), other.spanningEdges.keySet());
            }
            this.spanningEdges.putAll(other.spanningEdges);
            return this;
        }

        public static VMReport empty() {
            return new VMReport(new HashMap<MethodInfo, Collection<CallChain>>(), new HashMap<CallChain, CallSite>());
        }

        public static <K, V> void mergeMapKeys(Map<K, Collection<V>> m1, Map<K, Collection<V>> m2) {
            for (Map.Entry<K, Collection<V>> entry : m2.entrySet()) {
                K key = entry.getKey();
                Collection<V> value = entry.getValue();
                m1.merge(key, value, (a, b) -> {
                    a.addAll(b);
                    return a;
                });
            }
        }
    }
}

