/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.methods;

import com.sourceclear.methods.EntryPointResolver;
import com.sourceclear.methods.MethodInfo;
import com.sourceclear.methods.MethodScanner;
import com.sourceclear.methods.MethodScannerFactory;
import com.sourceclear.methods.java.JavaMethodScannerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Collection;

public class MethodScanners {
    public static MethodScannerFactory factory = new JavaMethodScannerFactory();

    public static MethodScanner forJar(InputStream jarStream, Collection<MethodInfo> vulnerableMethods, EntryPointResolver entryPointResolver) throws IOException {
        return factory.forArchiveStream(jarStream, vulnerableMethods, entryPointResolver);
    }

    public static MethodScanner forClassFiles(Collection<Path> classFiles, Collection<MethodInfo> vulnerableMethods, EntryPointResolver entryPointResolver) throws IOException {
        return factory.forFiles(classFiles, vulnerableMethods, entryPointResolver);
    }

    public static MethodScanner forDirectory(Path directory, Collection<MethodInfo> vulnerableMethods, EntryPointResolver entryPointResolver) throws IOException {
        return factory.forDirectory(directory, vulnerableMethods, entryPointResolver);
    }

    private MethodScanners() {
    }
}

