/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.methods;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.sourceclear.methods.VulnMethodsConfig;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import java.util.stream.BaseStream;

abstract class VulnMethodsConfig_Builder {
    private Set<String> ignoredDirectories = ImmutableSet.of();
    private boolean parallel;

    VulnMethodsConfig_Builder() {
    }

    public static VulnMethodsConfig.Builder from(VulnMethodsConfig value) {
        if (value instanceof Rebuildable) {
            return ((Rebuildable)value).toBuilder();
        }
        return new VulnMethodsConfig.Builder().mergeFrom(value);
    }

    public VulnMethodsConfig.Builder addIgnoredDirectories(String element) {
        if (this.ignoredDirectories instanceof ImmutableSet) {
            this.ignoredDirectories = new LinkedHashSet<String>(this.ignoredDirectories);
        }
        this.ignoredDirectories.add(Objects.requireNonNull(element));
        return (VulnMethodsConfig.Builder)this;
    }

    public VulnMethodsConfig.Builder addIgnoredDirectories(String ... elements) {
        return this.addAllIgnoredDirectories(Arrays.asList(elements));
    }

    public VulnMethodsConfig.Builder addAllIgnoredDirectories(Spliterator<? extends String> elements) {
        elements.forEachRemaining(this::addIgnoredDirectories);
        return (VulnMethodsConfig.Builder)this;
    }

    public VulnMethodsConfig.Builder addAllIgnoredDirectories(BaseStream<? extends String, ?> elements) {
        return this.addAllIgnoredDirectories(elements.spliterator());
    }

    public VulnMethodsConfig.Builder addAllIgnoredDirectories(Iterable<? extends String> elements) {
        elements.forEach(this::addIgnoredDirectories);
        return (VulnMethodsConfig.Builder)this;
    }

    public VulnMethodsConfig.Builder removeIgnoredDirectories(String element) {
        if (this.ignoredDirectories instanceof ImmutableSet) {
            this.ignoredDirectories = new LinkedHashSet<String>(this.ignoredDirectories);
        }
        this.ignoredDirectories.remove(Objects.requireNonNull(element));
        return (VulnMethodsConfig.Builder)this;
    }

    public VulnMethodsConfig.Builder mutateIgnoredDirectories(Consumer<? super Set<String>> mutator) {
        if (this.ignoredDirectories instanceof ImmutableSet) {
            this.ignoredDirectories = new LinkedHashSet<String>(this.ignoredDirectories);
        }
        mutator.accept(this.ignoredDirectories);
        return (VulnMethodsConfig.Builder)this;
    }

    public VulnMethodsConfig.Builder clearIgnoredDirectories() {
        if (this.ignoredDirectories instanceof ImmutableSet) {
            this.ignoredDirectories = ImmutableSet.of();
        } else {
            this.ignoredDirectories.clear();
        }
        return (VulnMethodsConfig.Builder)this;
    }

    public Set<String> ignoredDirectories() {
        if (this.ignoredDirectories instanceof ImmutableSet) {
            this.ignoredDirectories = new LinkedHashSet<String>(this.ignoredDirectories);
        }
        return Collections.unmodifiableSet(this.ignoredDirectories);
    }

    public VulnMethodsConfig.Builder parallel(boolean parallel) {
        this.parallel = parallel;
        return (VulnMethodsConfig.Builder)this;
    }

    public VulnMethodsConfig.Builder mapParallel(UnaryOperator<Boolean> mapper) {
        return this.parallel((Boolean)mapper.apply(this.parallel()));
    }

    public boolean parallel() {
        return this.parallel;
    }

    public VulnMethodsConfig.Builder mergeFrom(VulnMethodsConfig value) {
        if (value instanceof Value && this.ignoredDirectories == ImmutableSet.of()) {
            this.ignoredDirectories = ImmutableSet.copyOf(value.ignoredDirectories());
        } else {
            this.addAllIgnoredDirectories(value.ignoredDirectories());
        }
        VulnMethodsConfig.Builder defaults = new VulnMethodsConfig.Builder();
        if (value.parallel() != ((VulnMethodsConfig_Builder)defaults).parallel()) {
            this.parallel(value.parallel());
        }
        return (VulnMethodsConfig.Builder)this;
    }

    public VulnMethodsConfig.Builder mergeFrom(VulnMethodsConfig.Builder template) {
        VulnMethodsConfig.Builder base = template;
        this.addAllIgnoredDirectories(base.ignoredDirectories);
        VulnMethodsConfig.Builder defaults = new VulnMethodsConfig.Builder();
        if (template.parallel() != ((VulnMethodsConfig_Builder)defaults).parallel()) {
            this.parallel(template.parallel());
        }
        return (VulnMethodsConfig.Builder)this;
    }

    public VulnMethodsConfig.Builder clear() {
        this.clearIgnoredDirectories();
        VulnMethodsConfig.Builder defaults = new VulnMethodsConfig.Builder();
        this.parallel = defaults.parallel;
        return (VulnMethodsConfig.Builder)this;
    }

    public VulnMethodsConfig build() {
        return new Value(this);
    }

    @VisibleForTesting
    public VulnMethodsConfig buildPartial() {
        return new Partial(this);
    }

    private static final class Partial
    extends Rebuildable {
        private final ImmutableSet<String> ignoredDirectories;
        private final boolean parallel;

        Partial(VulnMethodsConfig_Builder builder) {
            this.ignoredDirectories = ImmutableSet.copyOf((Collection)builder.ignoredDirectories);
            this.parallel = builder.parallel;
        }

        @Override
        public Set<String> ignoredDirectories() {
            return this.ignoredDirectories;
        }

        @Override
        public boolean parallel() {
            return this.parallel;
        }

        @Override
        public VulnMethodsConfig.Builder toBuilder() {
            PartialBuilder builder = new PartialBuilder();
            ((VulnMethodsConfig_Builder)builder).ignoredDirectories = this.ignoredDirectories;
            ((VulnMethodsConfig_Builder)builder).parallel = this.parallel;
            return builder;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Partial)) {
                return false;
            }
            Partial other = (Partial)obj;
            return Objects.equals(this.ignoredDirectories, other.ignoredDirectories) && this.parallel == other.parallel;
        }

        public int hashCode() {
            return Objects.hash(this.ignoredDirectories, this.parallel);
        }

        public String toString() {
            return "partial VulnMethodsConfig{ignoredDirectories=" + this.ignoredDirectories + ", parallel=" + this.parallel + "}";
        }

        private static class PartialBuilder
        extends VulnMethodsConfig.Builder {
            private PartialBuilder() {
            }

            @Override
            public VulnMethodsConfig build() {
                return this.buildPartial();
            }
        }
    }

    private static final class Value
    extends Rebuildable {
        private final ImmutableSet<String> ignoredDirectories;
        private final boolean parallel;

        private Value(VulnMethodsConfig_Builder builder) {
            this.ignoredDirectories = ImmutableSet.copyOf((Collection)builder.ignoredDirectories);
            this.parallel = builder.parallel;
        }

        @Override
        public Set<String> ignoredDirectories() {
            return this.ignoredDirectories;
        }

        @Override
        public boolean parallel() {
            return this.parallel;
        }

        @Override
        public VulnMethodsConfig.Builder toBuilder() {
            VulnMethodsConfig.Builder builder = new VulnMethodsConfig.Builder();
            ((VulnMethodsConfig_Builder)builder).ignoredDirectories = this.ignoredDirectories;
            ((VulnMethodsConfig_Builder)builder).parallel = this.parallel;
            return builder;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Value)) {
                return false;
            }
            Value other = (Value)obj;
            return Objects.equals(this.ignoredDirectories, other.ignoredDirectories) && this.parallel == other.parallel;
        }

        public int hashCode() {
            return Objects.hash(this.ignoredDirectories, this.parallel);
        }

        public String toString() {
            return "VulnMethodsConfig{ignoredDirectories=" + this.ignoredDirectories + ", parallel=" + this.parallel + "}";
        }
    }

    private static abstract class Rebuildable
    implements VulnMethodsConfig {
        private Rebuildable() {
        }

        public abstract VulnMethodsConfig.Builder toBuilder();
    }
}

