/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.methods.python;

import com.sourceclear.analysis.utils.Utils;
import com.sourceclear.methods.Cleaner;
import com.sourceclear.methods.EntryPointResolver;
import com.sourceclear.methods.MethodInfo;
import com.sourceclear.methods.MethodScanner;
import com.sourceclear.methods.MethodScannerFactory;
import com.sourceclear.methods.VulnMethodsConfig;
import com.sourceclear.methods.VulnerablePartsDetector;
import com.sourceclear.methods.python.PythonCallGraphBuilder;
import com.veracode.security.logging.SecureLogger;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.io.FileUtils;

public class PythonMethodScannerFactory
extends MethodScannerFactory {
    private static SecureLogger LOGGER = SecureLogger.getLogger(PythonMethodScannerFactory.class);

    @Override
    public VulnMethodsConfig.Builder defaultVulnMethodsConfig() {
        return VulnMethodsConfig.Builder.python();
    }

    @Override
    public MethodScanner forArchiveStream(InputStream archiveStream, Collection<MethodInfo> vulnerableMethods, EntryPointResolver entryPointResolver) throws IOException {
        Path tempDirectory = Files.createTempDirectory("python-archive", new FileAttribute[0]);
        Cleaner cleanTempDirectory = () -> FileUtils.deleteQuietly((File)tempDirectory.toFile());
        InputStream stream = archiveStream;
        try {
            stream = new CompressorStreamFactory().createCompressorInputStream(stream);
        }
        catch (CompressorException e) {
            LOGGER.debug("Unable to decompress using autodetector: " + e.getMessage());
        }
        if (!stream.markSupported()) {
            stream = new BufferedInputStream(stream);
        }
        try {
            VulnerablePartsDetector vulnerablePartsDetector;
            block15: {
                ArchiveInputStream archiveInputStream = new ArchiveStreamFactory().createArchiveInputStream(stream);
                try {
                    DirectoryStream<Path> paths;
                    Iterator<Path> iterator;
                    Utils.unarchiveIntoDirectory(archiveInputStream, tempDirectory);
                    Path projectRoot = tempDirectory;
                    if (archiveInputStream instanceof TarArchiveInputStream && (iterator = (paths = Files.newDirectoryStream(tempDirectory)).iterator()).hasNext()) {
                        projectRoot = iterator.next();
                    }
                    PythonCallGraphBuilder pythonCallGraphBuilder = new PythonCallGraphBuilder(projectRoot, this.input.publicMethods(), this.config);
                    vulnerablePartsDetector = new VulnerablePartsDetector(vulnerableMethods, entryPointResolver, pythonCallGraphBuilder, this.input, cleanTempDirectory);
                    if (archiveInputStream == null) break block15;
                }
                catch (Throwable throwable) {
                    try {
                        if (archiveInputStream != null) {
                            try {
                                archiveInputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (ArchiveException e) {
                        LOGGER.error("Unable to unarchive using autodetector", e);
                        throw new IOException(e);
                    }
                }
                archiveInputStream.close();
            }
            return vulnerablePartsDetector;
        }
        finally {
            IOUtils.closeQuietly((Closeable)stream);
        }
    }

    @Override
    public MethodScanner forFiles(Collection<Path> files2, Collection<MethodInfo> vulnerableMethods, EntryPointResolver entryPointResolver) throws IOException {
        throw new UnsupportedOperationException("File scanning is unsupported");
    }

    @Override
    public MethodScanner forDirectory(Path directory, Collection<MethodInfo> vulnerableMethods, EntryPointResolver entryPointResolver) throws IOException {
        PythonCallGraphBuilder pythonCallGraphBuilder = new PythonCallGraphBuilder(directory, this.input.publicMethods(), this.config);
        return new VulnerablePartsDetector(vulnerableMethods, entryPointResolver, pythonCallGraphBuilder, this.input, Cleaner.DO_NOTHING);
    }
}

