/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.methods.ruby;

import com.sourceclear.methods.CallChainsInspector;
import com.sourceclear.methods.CallGraph;
import com.sourceclear.methods.CallGraphBuilder;
import com.sourceclear.methods.CallSite;
import com.sourceclear.methods.MethodInfo;
import com.sourceclear.methods.VulnMethodsConfig;
import com.sourceclear.methods.ruby.CallGraphVisitor;
import com.sourceclear.rubysonar.Analyzer;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jrubyparser.ast.Node;

public class RubyCallGraphBuilder
extends CallGraphBuilder {
    private final Path projectRoot;
    private final Collection<MethodInfo> publicMethods;
    private final Set<MethodInfo> methods;
    private final CallGraph callGraph = CallChainsInspector.createCallGraph();
    private boolean callGraphBuilt = false;
    private final Analyzer analyzer;

    public RubyCallGraphBuilder(Path projectRoot, Collection<MethodInfo> publicMethods, VulnMethodsConfig config) throws IOException {
        this.projectRoot = projectRoot;
        this.publicMethods = publicMethods;
        this.methods = new HashSet<MethodInfo>();
        this.analyzer = new Analyzer(config);
    }

    @Override
    public void build() throws IOException {
        if (this.callGraphBuilt) {
            return;
        }
        CallGraphVisitor visitor2 = new CallGraphVisitor(this.projectRoot){

            @Override
            public void visitMethod(MethodInfo methodInfo, Node body) {
                RubyCallGraphBuilder.this.methods.add(methodInfo);
            }
        };
        this.analyzer.addVisitor(visitor2);
        this.loadPublicMethods(this.analyzer);
        this.analyzer.analyze(this.projectRoot);
        this.analyzer.finish();
        for (CallSite callSite : visitor2.getCallSites()) {
            this.callGraph.addEdge(callSite);
        }
        this.callGraphBuilt = true;
    }

    private void loadPublicMethods(Analyzer analyzer) {
        for (MethodInfo method : this.publicMethods) {
            ArrayList<String> modules = new ArrayList<String>();
            if (method.getModuleName() != null) {
                Collections.addAll(modules, method.getModuleName().split("::"));
            }
            analyzer.loadMethod(modules, method.getClassName(), method.getMethodName());
        }
    }

    @Override
    public Set<MethodInfo> getMethodsDefined() {
        return this.methods;
    }

    @Override
    public CallGraph getCallGraph() {
        return this.callGraph;
    }
}

