/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.publicmethods.ruby;

import com.google.common.base.Strings;
import com.sourceclear.methods.MethodInfo;
import com.sourceclear.methods.MethodInfoImpl;
import com.sourceclear.rubysonar.State;
import com.sourceclear.rubysonar.TypeInferencer;
import com.sourceclear.rubysonar.Visitor;
import com.sourceclear.rubysonar.types.ClassType;
import com.sourceclear.rubysonar.types.InstanceType;
import com.sourceclear.rubysonar.types.ModuleType;
import com.sourceclear.rubysonar.types.Type;
import com.veracode.security.logging.SecureLogger;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jrubyparser.ast.ClassNode;
import org.jrubyparser.ast.Colon2Node;
import org.jrubyparser.ast.Colon3Node;
import org.jrubyparser.ast.ConstNode;
import org.jrubyparser.ast.DefnNode;
import org.jrubyparser.ast.DefsNode;
import org.jrubyparser.ast.ModuleNode;
import org.jrubyparser.ast.NilNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.SClassNode;
import org.jrubyparser.lexer.yacc.InvalidSourcePosition;

public abstract class RubyMethodsVisitor
extends Visitor<Void> {
    private static final SecureLogger LOGGER = SecureLogger.getLogger(RubyMethodsVisitor.class);
    private Stack<Namespace> namespaces = new Stack();
    protected State state;
    private static final String RUBY_NAMESPACE_SEPARATOR = "::";
    private static final String INITIALIZE_METHOD = "initialize";
    private static final NilNode NIL_NODE = new NilNode(new InvalidSourcePosition());
    private boolean privateAccess = false;

    @Override
    public Void visitModuleNode(ModuleNode node) {
        String name;
        Type type = new TypeInferencer(this.state).visitModuleNode(node);
        State oldState = this.state;
        if (type.getTable().stateType == State.StateType.MODULE) {
            this.state = type.getTable();
            name = ((ModuleType)type).getQname();
        } else {
            name = this.nameToString(node.getCPath());
        }
        this.enterScope(new Module(name));
        this.addModuleCallbacks();
        super.visitModuleNode(node);
        this.state = oldState;
        this.exitScope();
        return null;
    }

    @Override
    public Void visitSClassNode(SClassNode node) {
        Node receiverNode = node.getReceiverNode();
        Type receiverType = receiverNode.accept(new TypeInferencer(this.state));
        String moduleName = null;
        String className = null;
        switch (receiverType.getTable().stateType) {
            case CLASS: {
                className = receiverType.getTable().path;
                break;
            }
            case INSTANCE: {
                if (receiverType instanceof InstanceType) {
                    InstanceType instanceType = (InstanceType)receiverType;
                    className = instanceType.getClassType().getTable().path;
                    break;
                }
                LOGGER.debug("Receiver's state type is INSTANCE but type not an instance of InstanceType: {}", (Object)receiverType);
                break;
            }
            case MODULE: {
                moduleName = receiverType.getTable().path;
                break;
            }
            case FUNCTION: 
            case GLOBAL: 
            case SCOPE: {
                LOGGER.debug("Unhandled receiver state type when visiting singleton class node: {}", (Object)receiverType);
            }
        }
        Stack<Namespace> oldNamespaces = this.namespaces;
        this.namespaces = new Stack();
        if (moduleName != null) {
            this.namespaces.push(new Module(moduleName));
        }
        if (className != null) {
            this.namespaces.push(new Class(className));
        }
        super.visitSClassNode(node);
        this.namespaces = oldNamespaces;
        return null;
    }

    @Override
    public Void visitClassNode(ClassNode node) {
        Colon3Node cPath = node.getCPath();
        Type type = cPath.accept(new TypeInferencer(this.state));
        State oldState = this.state;
        if (type instanceof ClassType) {
            this.enterScope(new Class(type.getTable().path));
            this.state = type.getTable();
        }
        this.visitRubyMethod(this.currentModule(), this.currentClass(), INITIALIZE_METHOD, NIL_NODE);
        super.visitClassNode(node);
        this.state = oldState;
        if (type instanceof ClassType) {
            this.exitScope();
        }
        return null;
    }

    @Override
    public Void visitDefnNode(DefnNode node) {
        String methodName = node.getName();
        this.visitRubyMethod(this.currentModule(), this.currentClass(), methodName, node.getBodyNode());
        super.visitDefnNode(node);
        return null;
    }

    @Override
    public Void visitDefsNode(DefsNode node) {
        String methodName = node.getName();
        Node receiverNode = node.getReceiverNode();
        Type receiverType = receiverNode.accept(new TypeInferencer(this.state));
        String moduleName = null;
        String className = null;
        switch (receiverType.getTable().stateType) {
            case CLASS: {
                moduleName = RubyMethodsVisitor.parentPath(receiverType.getTable().path);
                className = RubyMethodsVisitor.basename(receiverType.getTable().path);
                break;
            }
            case INSTANCE: {
                if (receiverType instanceof InstanceType) {
                    InstanceType instanceType = (InstanceType)receiverType;
                    moduleName = RubyMethodsVisitor.parentPath(instanceType.getClassType().getTable().path);
                    className = instanceType.getClassType().getName();
                    break;
                }
                LOGGER.debug("Unhandled receiver state type when visiting defs node: {}", (Object)receiverType);
                return (Void)super.visitDefsNode(node);
            }
            case MODULE: {
                if (receiverType instanceof ModuleType) {
                    moduleName = ((ModuleType)receiverType).getQname();
                    break;
                }
                LOGGER.debug("Unhandled receiver state type when visiting defs node: {}", (Object)receiverType);
                return (Void)super.visitDefsNode(node);
            }
            case FUNCTION: 
            case GLOBAL: 
            case SCOPE: {
                LOGGER.debug("Unhandled receiver state type when visiting defs node: {}", (Object)receiverType);
                return (Void)super.visitDefsNode(node);
            }
        }
        this.visitRubyMethod(moduleName, className, methodName, node.getBodyNode());
        return (Void)super.visitDefsNode(node);
    }

    @Override
    protected Void defaultVisit(Node node) {
        for (Node child : node.childNodes()) {
            if (child == null) continue;
            child.accept(this);
        }
        return null;
    }

    @Override
    public void setState(State state) {
        this.state = state;
    }

    @Override
    public void finish() {
    }

    private void enterScope(Namespace namespace) {
        this.namespaces.push(namespace);
        this.onEnterScope(namespace);
    }

    private void exitScope() {
        this.onExitScope(this.namespaces.pop());
    }

    protected void onEnterScope(Namespace namespace) {
    }

    protected void onExitScope(Namespace pop) {
    }

    @Nullable
    protected String currentClass() {
        if (this.namespaces.isEmpty()) {
            return "Object";
        }
        if (this.namespaces.peek().isClass()) {
            return RubyMethodsVisitor.basename(this.namespaces.peek().getName());
        }
        return null;
    }

    @Nullable
    protected String currentModule() {
        if (this.namespaces.isEmpty()) {
            return null;
        }
        if (this.namespaces.peek().isClass()) {
            return Strings.emptyToNull((String)RubyMethodsVisitor.parentPath(this.namespaces.peek().getName()));
        }
        return Strings.emptyToNull((String)this.namespaces.peek().getName());
    }

    @NotNull
    private String nameToString(Node node) {
        if (node == null) {
            return "";
        }
        switch (node.getNodeType()) {
            case COLON2NODE: {
                Colon2Node colon2 = (Colon2Node)node;
                Node leftNode = colon2.getLeftNode();
                if (leftNode != null) {
                    return this.nameToString(leftNode) + RUBY_NAMESPACE_SEPARATOR + colon2.getLexicalName();
                }
                return colon2.getLexicalName();
            }
            case CONSTNODE: {
                ConstNode constNode = (ConstNode)node;
                return constNode.getLexicalName();
            }
            case COLON3NODE: {
                Colon3Node colon3 = (Colon3Node)node;
                return colon3.getLexicalName();
            }
        }
        return "";
    }

    static String basename(String path) {
        if (path == null) {
            return null;
        }
        int separatorIndex = path.lastIndexOf(RUBY_NAMESPACE_SEPARATOR);
        if (separatorIndex > -1) {
            return path.substring(separatorIndex + RUBY_NAMESPACE_SEPARATOR.length());
        }
        return path;
    }

    protected static String parentPath(String path) {
        String result = null;
        int separatorIndex = path.lastIndexOf(RUBY_NAMESPACE_SEPARATOR);
        if (separatorIndex > 0) {
            result = path.substring(0, separatorIndex);
        }
        return result;
    }

    private void addModuleCallbacks() {
        this.visitRubyMethod(this.currentModule(), this.currentClass(), "included", NIL_NODE);
        this.visitRubyMethod(this.currentModule(), this.currentClass(), "extended", NIL_NODE);
        this.visitRubyMethod(this.currentModule(), this.currentClass(), "prepended", NIL_NODE);
    }

    private void visitRubyMethod(String moduleName, String className, String methodName, Node body) {
        this.visitMethod(new MethodInfoImpl(moduleName, className, methodName, null), body);
    }

    public abstract void visitMethod(MethodInfo var1, Node var2);

    public static interface Namespace {
        public String getName();

        public boolean isClass();

        public boolean isModule();
    }

    public static class Module
    implements Namespace {
        private final String name;

        public Module(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isClass() {
            return false;
        }

        @Override
        public boolean isModule() {
            return true;
        }

        public String toString() {
            return this.getName();
        }
    }

    public static class Class
    implements Namespace {
        private final String name;

        public Class(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isClass() {
            return true;
        }

        @Override
        public boolean isModule() {
            return false;
        }

        public String toString() {
            return this.getName();
        }
    }
}

