/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.pysonar;

import com.sourceclear.methods.CallSite;
import com.sourceclear.methods.MethodInfo;
import com.sourceclear.pysonar.Binding;
import com.sourceclear.pysonar.Diagnostic;
import com.sourceclear.pysonar.State;
import com.sourceclear.pysonar.TypeStack;
import com.sourceclear.pysonar.ast.BinOp;
import com.sourceclear.pysonar.ast.Node;
import com.sourceclear.pysonar.ast.Url;
import com.sourceclear.pysonar.types.FunType;
import com.sourceclear.pysonar.types.Type;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class AnalyzerState {
    private final List<Binding> allBindings = new ArrayList<Binding>();
    private final Set<State> stateLooked = new HashSet<State>();
    public final TypeStack typeStack = new TypeStack();
    private final Map<Path, List<Diagnostic>> semanticErrors = new HashMap<Path, List<Diagnostic>>();
    private final List<Path> loadPathAdditions = new ArrayList<Path>();
    private final Map<Node, List<Binding>> references = new LinkedHashMap<Node, List<Binding>>();
    private final Set<FunType> uncalled = new HashSet<FunType>();
    private final Set<Object> importStack = new HashSet<Object>();
    private final Set<CallSite> callSites = new HashSet<CallSite>();
    private final Map<BinOp, Type> overriddenOperatorTypes = new HashMap<BinOp, Type>();
    private final Map<String, Type> publicMethods = new HashMap<String, Type>();
    private final Set<MethodInfo> methods = new HashSet<MethodInfo>();
    private int lambdaCounter = 0;

    public void addOverriddenOperatorType(BinOp op, Type type) {
        this.overriddenOperatorTypes.put(op, type);
    }

    public Map<BinOp, Type> getOverriddenOperatorTypes() {
        return this.overriddenOperatorTypes;
    }

    public Set<CallSite> getCallSites() {
        return this.callSites;
    }

    public void addCallSite(CallSite callSite) {
        this.callSites.add(callSite);
    }

    public Set<MethodInfo> getMethods() {
        return this.methods;
    }

    public void addMethods(Set<MethodInfo> methods) {
        this.methods.addAll(methods);
    }

    public void addUncalled(@NotNull FunType function) {
        if (!function.func.called) {
            this.uncalled.add(function);
        }
    }

    public void removeUncalled(FunType function) {
        this.uncalled.remove(function);
    }

    public boolean hasUncalledFunctions() {
        return !this.uncalled.isEmpty();
    }

    public List<FunType> getUncalledFunctions() {
        return new ArrayList<FunType>(this.uncalled);
    }

    public boolean inImportStack(Path file) {
        return this.importStack.contains(file);
    }

    public void pushImportStack(Path file) {
        this.importStack.add(file);
    }

    public void popImportStack(Path file) {
        this.importStack.remove(file);
    }

    public void addPublicMethod(String name, Type type) {
        this.publicMethods.put(name, type);
    }

    public Type getPublicMethodType(String name) {
        return this.publicMethods.get(name);
    }

    public Map<Path, List<Diagnostic>> getAllSemanticErrors() {
        return this.semanticErrors;
    }

    public void addPath(Path path) {
        this.loadPathAdditions.add(path);
    }

    public List<Path> getLoadPathAdditions() {
        return this.loadPathAdditions;
    }

    public void seenState(State state) {
        this.stateLooked.add(state);
    }

    public void forgetState(State state) {
        this.stateLooked.remove(state);
    }

    public boolean wasStateSeen(State state) {
        return this.stateLooked.contains(state);
    }

    public int incrementLambdaCounter() {
        return ++this.lambdaCounter;
    }

    @NotNull
    public Map<Node, List<Binding>> getReferences() {
        return this.references;
    }

    public void putRef(@NotNull Node node, @NotNull Binding b) {
        ArrayList<Binding> bs = new ArrayList<Binding>();
        bs.add(b);
        this.putRef(node, bs);
    }

    public void putRef(@NotNull Node node, @NotNull Collection<Binding> bs) {
        if (!(node instanceof Url)) {
            List<Binding> bindings = this.references.get(node);
            if (bindings == null) {
                bindings = new ArrayList<Binding>(1);
                this.references.put(node, bindings);
            }
            for (Binding b : bs) {
                if (!bindings.contains(b)) {
                    bindings.add(b);
                }
                b.addRef(node);
            }
        }
    }

    public List<Binding> getAllBindings() {
        return this.allBindings;
    }

    public void registerBinding(@NotNull Binding b) {
        this.allBindings.add(b);
    }
}

