/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.pysonar;

import com.google.common.annotations.VisibleForTesting;
import com.sourceclear.pysonar.Analyzer;
import com.sourceclear.pysonar.PythonProcesses;
import com.sourceclear.pysonar.PythonSyntaxErrorException;
import com.sourceclear.pysonar.Utils;
import com.sourceclear.pysonar.ast.Alias;
import com.sourceclear.pysonar.ast.Assert;
import com.sourceclear.pysonar.ast.Assign;
import com.sourceclear.pysonar.ast.Attribute;
import com.sourceclear.pysonar.ast.BinOp;
import com.sourceclear.pysonar.ast.Block;
import com.sourceclear.pysonar.ast.Break;
import com.sourceclear.pysonar.ast.Bytes;
import com.sourceclear.pysonar.ast.Call;
import com.sourceclear.pysonar.ast.ClassDef;
import com.sourceclear.pysonar.ast.Comprehension;
import com.sourceclear.pysonar.ast.Continue;
import com.sourceclear.pysonar.ast.Delete;
import com.sourceclear.pysonar.ast.Dict;
import com.sourceclear.pysonar.ast.DictComp;
import com.sourceclear.pysonar.ast.Ellipsis;
import com.sourceclear.pysonar.ast.Exec;
import com.sourceclear.pysonar.ast.Expr;
import com.sourceclear.pysonar.ast.ExtSlice;
import com.sourceclear.pysonar.ast.For;
import com.sourceclear.pysonar.ast.FunctionDef;
import com.sourceclear.pysonar.ast.GeneratorExp;
import com.sourceclear.pysonar.ast.Global;
import com.sourceclear.pysonar.ast.Handler;
import com.sourceclear.pysonar.ast.If;
import com.sourceclear.pysonar.ast.IfExp;
import com.sourceclear.pysonar.ast.Import;
import com.sourceclear.pysonar.ast.ImportFrom;
import com.sourceclear.pysonar.ast.Index;
import com.sourceclear.pysonar.ast.Keyword;
import com.sourceclear.pysonar.ast.ListComp;
import com.sourceclear.pysonar.ast.Module;
import com.sourceclear.pysonar.ast.Name;
import com.sourceclear.pysonar.ast.Node;
import com.sourceclear.pysonar.ast.Op;
import com.sourceclear.pysonar.ast.Pass;
import com.sourceclear.pysonar.ast.Print;
import com.sourceclear.pysonar.ast.PyComplex;
import com.sourceclear.pysonar.ast.PyFloat;
import com.sourceclear.pysonar.ast.PyInt;
import com.sourceclear.pysonar.ast.PyList;
import com.sourceclear.pysonar.ast.PySet;
import com.sourceclear.pysonar.ast.Raise;
import com.sourceclear.pysonar.ast.Repr;
import com.sourceclear.pysonar.ast.Return;
import com.sourceclear.pysonar.ast.SetComp;
import com.sourceclear.pysonar.ast.Slice;
import com.sourceclear.pysonar.ast.Starred;
import com.sourceclear.pysonar.ast.Str;
import com.sourceclear.pysonar.ast.Subscript;
import com.sourceclear.pysonar.ast.Try;
import com.sourceclear.pysonar.ast.Tuple;
import com.sourceclear.pysonar.ast.UnaryOp;
import com.sourceclear.pysonar.ast.Unsupported;
import com.sourceclear.pysonar.ast.While;
import com.sourceclear.pysonar.ast.With;
import com.sourceclear.pysonar.ast.Withitem;
import com.sourceclear.pysonar.ast.Yield;
import com.veracode.security.logging.SecureLogger;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Parser
implements Closeable {
    private static final SecureLogger LOGGER = SecureLogger.getLogger(Parser.class);
    static final String DUMP_PYTHON_RESOURCE = "python/dump_python.py";
    public final Path tempDir;
    private final Path jsonizer;
    private final Path exchangeFile;
    private final Path endMark;
    private final Path parserLog;
    private final Analyzer analyzer;
    private Path file;
    private String content;
    private final PythonProcesses pythonProcesses;

    @VisibleForTesting
    Parser(Path tempDir, Analyzer analyzer) throws IOException {
        this.tempDir = tempDir;
        this.analyzer = analyzer;
        this.exchangeFile = Files.createTempFile(tempDir, "json", "", new FileAttribute[0]);
        this.endMark = Files.createTempFile(tempDir, "end", "", new FileAttribute[0]);
        this.jsonizer = tempDir.resolve("dump_python");
        this.parserLog = Files.createTempFile(tempDir, "parser_log", "", new FileAttribute[0]);
        if (!Files.exists(this.jsonizer, new LinkOption[0])) {
            this.copyJsonizerToTempFile();
        }
        this.pythonProcesses = new PythonProcesses(this.jsonizer, this.exchangeFile, this.endMark, this.parserLog);
        this.pythonProcesses.ensurePythonIsAvailable();
        this.pythonProcesses.start();
    }

    public Parser(Analyzer analyzer) throws IOException {
        this(Files.createTempDirectory("pysonar-ast-cache", new FileAttribute[0]), analyzer);
    }

    private void copyJsonizerToTempFile() throws IOException {
        try (InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(DUMP_PYTHON_RESOURCE);){
            Files.copy(stream, this.jsonizer, new CopyOption[0]);
        }
        catch (IOException e) {
            throw new IOException("Failed to copy resource file:python/dump_python.py", e);
        }
    }

    @Override
    public void close() throws IOException {
        this.cleanTemp();
        if (Files.exists(this.jsonizer, new LinkOption[0])) {
            Files.delete(this.jsonizer);
        }
        this.pythonProcesses.cleanup();
        if (Files.exists(this.parserLog, new LinkOption[0])) {
            Files.delete(this.parserLog);
        }
        FileUtils.deleteDirectory((File)this.tempDir.toFile());
    }

    @Nullable
    public Node convert(Object o) {
        int end;
        if (!(o instanceof Map)) {
            return null;
        }
        Map map = (Map)o;
        String type = (String)map.get("type");
        Double lineDouble = (Double)map.get("lineno");
        Double startDouble = (Double)map.get("start");
        Double endDouble = (Double)map.get("end");
        int lineNumber = lineDouble == null ? 1 : lineDouble.intValue();
        int start = startDouble == null ? 0 : startDouble.intValue();
        int n = end = endDouble == null ? 1 : endDouble.intValue();
        if (type.equals("Module")) {
            Block b = this.convertBlock(map.get("body"));
            return new Module(this.analyzer, b, this.file, lineNumber, start, end);
        }
        if (type.equals("alias")) {
            String qname = (String)map.get("name");
            List<Name> names = this.segmentQname(qname, lineNumber, start + "import ".length(), false);
            Name asname = map.get("asname") == null ? null : new Name(this.analyzer, (String)map.get("asname"));
            return new Alias(this.analyzer, names, asname, this.file, lineNumber, start, end);
        }
        if (type.equals("Assert")) {
            Node test = this.convert(map.get("test"));
            Node msg = this.convert(map.get("msg"));
            return new Assert(this.analyzer, test, msg, this.file, lineNumber, start, end);
        }
        if (type.equals("Assign")) {
            List targets = this.convertList(map.get("targets"));
            Node value = this.convert(map.get("value"));
            if (targets.size() == 1) {
                return new Assign(this.analyzer, (Node)targets.get(0), value, this.file, lineNumber, start, end);
            }
            ArrayList<Node> assignments = new ArrayList<Node>();
            Node lastTarget = (Node)targets.get(targets.size() - 1);
            assignments.add(new Assign(this.analyzer, lastTarget, value, this.file, lineNumber, start, end));
            for (int i = targets.size() - 2; i >= 0; --i) {
                Assign nextAssign = new Assign(this.analyzer, (Node)targets.get(i), lastTarget, this.file, lineNumber, start, end);
                assignments.add(nextAssign);
            }
            return new Block(this.analyzer, assignments, this.file, lineNumber, start, end);
        }
        if (type.equals("Attribute")) {
            Node value = this.convert(map.get("value"));
            Name attr = (Name)this.convert(map.get("attr_name"));
            if (attr == null) {
                attr = new Name(this.analyzer, (String)map.get("attr"));
            }
            return new Attribute(this.analyzer, value, attr, this.file, lineNumber, start, end);
        }
        if (type.equals("AugAssign")) {
            Node target = this.convert(map.get("target"));
            Node value = this.convert(map.get("value"));
            Op op = this.convertOp(map.get("op"));
            BinOp operation = new BinOp(this.analyzer, op, target, value, this.file, target.lineNumber, target.start, value.end);
            return new Assign(this.analyzer, target, operation, this.file, lineNumber, start, end);
        }
        if (type.equals("BinOp")) {
            Node left = this.convert(map.get("left"));
            Node right = this.convert(map.get("right"));
            Op op = this.convertOp(map.get("op"));
            if (op == Op.NotEqual) {
                BinOp eq = new BinOp(this.analyzer, Op.Equal, left, right, this.file, lineNumber, start, end);
                return new UnaryOp(this.analyzer, Op.Not, eq, this.file, lineNumber, start, end);
            }
            if (op == Op.LtE) {
                BinOp lt = new BinOp(this.analyzer, Op.Lt, left, right, this.file, lineNumber, start, end);
                BinOp eq = new BinOp(this.analyzer, Op.Eq, left, right, this.file, lineNumber, start, end);
                return new BinOp(this.analyzer, Op.Or, lt, eq, this.file, lineNumber, start, end);
            }
            if (op == Op.GtE) {
                BinOp gt = new BinOp(this.analyzer, Op.Gt, left, right, this.file, lineNumber, start, end);
                BinOp eq = new BinOp(this.analyzer, Op.Eq, left, right, this.file, lineNumber, start, end);
                return new BinOp(this.analyzer, Op.Or, gt, eq, this.file, lineNumber, start, end);
            }
            if (op == Op.NotIn) {
                BinOp in = new BinOp(this.analyzer, Op.In, left, right, this.file, lineNumber, start, end);
                return new UnaryOp(this.analyzer, Op.Not, in, this.file, lineNumber, start, end);
            }
            if (op == Op.NotEq) {
                BinOp in = new BinOp(this.analyzer, Op.Eq, left, right, this.file, lineNumber, start, end);
                return new UnaryOp(this.analyzer, Op.Not, in, this.file, lineNumber, start, end);
            }
            return new BinOp(this.analyzer, op, left, right, this.file, lineNumber, start, end);
        }
        if (type.equals("BoolOp")) {
            List values = this.convertList(map.get("values"));
            if (values == null || values.size() < 2) {
                throw new IllegalArgumentException("impossible number of arguments, please fix the Python parser");
            }
            Op op = this.convertOp(map.get("op"));
            BinOp ret = new BinOp(this.analyzer, op, (Node)values.get(0), (Node)values.get(1), this.file, lineNumber, start, end);
            for (int i = 2; i < values.size(); ++i) {
                ret = new BinOp(this.analyzer, op, ret, (Node)values.get(i), this.file, lineNumber, start, end);
            }
            return ret;
        }
        if (type.equals("Bytes")) {
            Object s = map.get("s");
            return new Bytes(this.analyzer, s, this.file, lineNumber, start, end);
        }
        if (type.equals("Call")) {
            Node func = this.convert(map.get("func"));
            List<Node> args = this.convertList(map.get("args"));
            List<Keyword> keywords = this.convertList(map.get("keywords"));
            Node kwargs = this.convert(map.get("kwarg"));
            Node starargs = this.convert(map.get("starargs"));
            return new Call(this.analyzer, func, args, keywords, kwargs, starargs, this.file, lineNumber, start, end);
        }
        if (type.equals("ClassDef")) {
            Name name = (Name)this.convert(map.get("name_node"));
            List<Node> bases = this.convertList(map.get("bases"));
            Block body = this.convertBlock(map.get("body"));
            return new ClassDef(this.analyzer, name, bases, body, this.file, lineNumber, start, end);
        }
        if (type.equals("Compare")) {
            Node left = this.convert(map.get("left"));
            List<Op> ops = this.convertListOp(map.get("ops"));
            List comparators = this.convertList(map.get("comparators"));
            BinOp result = new BinOp(this.analyzer, ops.get(0), left, (Node)comparators.get(0), this.file, lineNumber, start, end);
            for (int i = 1; i < comparators.size(); ++i) {
                BinOp compNext = new BinOp(this.analyzer, ops.get(i), (Node)comparators.get(i - 1), (Node)comparators.get(i), this.file, lineNumber, start, end);
                result = new BinOp(this.analyzer, Op.And, result, compNext, this.file, lineNumber, start, end);
            }
            return result;
        }
        if (type.equals("comprehension")) {
            Node target = this.convert(map.get("target"));
            Node iter = this.convert(map.get("iter"));
            List<Node> ifs = this.convertList(map.get("ifs"));
            return new Comprehension(this.analyzer, target, iter, ifs, this.file, lineNumber, start, end);
        }
        if (type.equals("Break")) {
            return new Break(this.analyzer, this.file, lineNumber, start, end);
        }
        if (type.equals("Continue")) {
            return new Continue(this.analyzer, this.file, lineNumber, start, end);
        }
        if (type.equals("Delete")) {
            List<Node> targets = this.convertList(map.get("targets"));
            return new Delete(this.analyzer, targets, this.file, lineNumber, start, end);
        }
        if (type.equals("Dict")) {
            List<Node> keys = this.convertList(map.get("keys"));
            List<Node> values = this.convertList(map.get("values"));
            return new Dict(this.analyzer, keys, values, this.file, lineNumber, start, end);
        }
        if (type.equals("DictComp")) {
            Node key = this.convert(map.get("key"));
            Node value = this.convert(map.get("value"));
            List<Comprehension> generators = this.convertList(map.get("generators"));
            return new DictComp(this.analyzer, key, value, generators, this.file, lineNumber, start, end);
        }
        if (type.equals("Ellipsis")) {
            return new Ellipsis(this.analyzer, this.file, lineNumber, start, end);
        }
        if (type.equals("ExceptHandler")) {
            ArrayList<Node> exceptions;
            Node exception = this.convert(map.get("type"));
            if (exception != null) {
                exceptions = new ArrayList<Node>();
                exceptions.add(exception);
            } else {
                exceptions = null;
            }
            Node binder = this.convert(map.get("name"));
            Block body = this.convertBlock(map.get("body"));
            return new Handler(this.analyzer, exceptions, binder, body, this.file, lineNumber, start, end);
        }
        if (type.equals("Exec")) {
            Node body = this.convert(map.get("body"));
            Node globals = this.convert(map.get("globals"));
            Node locals = this.convert(map.get("locals"));
            return new Exec(this.analyzer, body, globals, locals, this.file, lineNumber, start, end);
        }
        if (type.equals("Expr")) {
            Node value = this.convert(map.get("value"));
            return new Expr(this.analyzer, value, this.file, lineNumber, start, end);
        }
        if (type.equals("For") || type.equals("AsyncFor")) {
            Node target = this.convert(map.get("target"));
            Node iter = this.convert(map.get("iter"));
            Block body = this.convertBlock(map.get("body"));
            Block orelse = this.convertBlock(map.get("orelse"));
            return new For(this.analyzer, target, iter, body, orelse, type.equals("AsyncFor"), this.file, lineNumber, start, end);
        }
        if (type.equals("FunctionDef") || type.equals("Lambda") || type.equals("AsyncFunctionDef")) {
            Name name = type.equals("Lambda") ? null : (Name)this.convert(map.get("name_node"));
            Map argsMap = (Map)map.get("args");
            List<Node> args = this.convertList(argsMap.get("args"));
            List<Node> defaults = this.convertList(argsMap.get("defaults"));
            Node body = type.equals("Lambda") ? this.convert(map.get("body")) : this.convertBlock(map.get("body"));
            Name vararg = null;
            Object varargObj = argsMap.get("vararg");
            if (varargObj instanceof String) {
                vararg = new Name(this.analyzer, (String)argsMap.get("vararg"));
            } else if (varargObj instanceof Map) {
                String argName = (String)((Map)varargObj).get("arg");
                vararg = new Name(this.analyzer, argName);
            }
            Name kwarg = null;
            Object kwargObj = argsMap.get("kwarg");
            if (kwargObj instanceof String) {
                kwarg = new Name(this.analyzer, (String)argsMap.get("kwarg"));
            } else if (kwargObj instanceof Map) {
                String argName = (String)((Map)kwargObj).get("arg");
                kwarg = new Name(this.analyzer, argName);
            }
            boolean isAsync = type.equals("AsyncFunctionDef");
            return new FunctionDef(this.analyzer, name, args, body, defaults, vararg, kwarg, this.file, isAsync, lineNumber, start, end);
        }
        if (type.equals("GeneratorExp")) {
            Node elt = this.convert(map.get("elt"));
            List<Comprehension> generators = this.convertList(map.get("generators"));
            return new GeneratorExp(this.analyzer, elt, generators, this.file, lineNumber, start, end);
        }
        if (type.equals("Global")) {
            List names = (List)map.get("names");
            ArrayList<Name> nameNodes = new ArrayList<Name>();
            for (String name : names) {
                nameNodes.add(new Name(this.analyzer, name));
            }
            return new Global(this.analyzer, nameNodes, this.file, lineNumber, start, end);
        }
        if (type.equals("Nonlocal")) {
            List names = (List)map.get("names");
            ArrayList<Name> nameNodes = new ArrayList<Name>();
            for (String name : names) {
                nameNodes.add(new Name(this.analyzer, name));
            }
            return new Global(this.analyzer, nameNodes, this.file, lineNumber, start, end);
        }
        if (type.equals("If")) {
            Node test = this.convert(map.get("test"));
            Block body = this.convertBlock(map.get("body"));
            Block orelse = this.convertBlock(map.get("orelse"));
            return new If(this.analyzer, test, body, orelse, this.file, lineNumber, start, end);
        }
        if (type.equals("IfExp")) {
            Node test = this.convert(map.get("test"));
            Node body = this.convert(map.get("body"));
            Node orelse = this.convert(map.get("orelse"));
            return new IfExp(this.analyzer, test, body, orelse, this.file, lineNumber, start, end);
        }
        if (type.equals("Import")) {
            List<Alias> aliases = this.convertList(map.get("names"));
            this.locateNames(aliases, start);
            return new Import(this.analyzer, aliases, this.file, lineNumber, start, end);
        }
        if (type.equals("ImportFrom")) {
            String module = (String)map.get("module");
            int level = ((Double)map.get("level")).intValue();
            List<Name> moduleSeg = module == null ? null : this.segmentQname(module, lineNumber, start + "from ".length() + level, true);
            List<Alias> names = this.convertList(map.get("names"));
            this.locateNames(names, start);
            return new ImportFrom(this.analyzer, moduleSeg, names, level, this.file, lineNumber, start, end);
        }
        if (type.equals("Index")) {
            Node value = this.convert(map.get("value"));
            return new Index(this.analyzer, value, this.file, lineNumber, start, end);
        }
        if (type.equals("keyword")) {
            String arg = (String)map.get("arg");
            Node value = this.convert(map.get("value"));
            return new Keyword(this.analyzer, arg, value, this.file, lineNumber, start, end);
        }
        if (type.equals("List")) {
            List<Node> elts = this.convertList(map.get("elts"));
            return new PyList(this.analyzer, elts, this.file, lineNumber, start, end);
        }
        if (type.equals("Starred")) {
            Node value = this.convert(map.get("value"));
            return new Starred(this.analyzer, value, this.file, lineNumber, start, end);
        }
        if (type.equals("ListComp")) {
            Node elt = this.convert(map.get("elt"));
            List<Comprehension> generators = this.convertList(map.get("generators"));
            return new ListComp(this.analyzer, elt, generators, this.file, lineNumber, start, end);
        }
        if (type.equals("Name")) {
            String id = (String)map.get("id");
            return new Name(this.analyzer, id, this.file, lineNumber, start, end);
        }
        if (type.equals("NameConstant")) {
            String strVal;
            Object value = map.get("value");
            if (value == null) {
                strVal = "None";
            } else if (value instanceof Boolean) {
                strVal = (Boolean)value != false ? "true" : "false";
            } else if (value instanceof String) {
                strVal = (String)value;
            } else {
                Utils.msg("[WARNING] NameConstant contains unrecognized value: " + value + ", please report issue");
                strVal = "";
            }
            return new Name(this.analyzer, strVal, this.file, lineNumber, start, end);
        }
        if (type.equals("arg")) {
            String id = (String)map.get("arg");
            return new Name(this.analyzer, id, this.file, lineNumber, start, end);
        }
        if (type.equals("Num")) {
            String num_type = (String)map.get("num_type");
            if (num_type.equals("int")) {
                return new PyInt(this.analyzer, (String)map.get("n"), this.file, lineNumber, start, end);
            }
            if (num_type.equals("float")) {
                return new PyFloat(this.analyzer, (String)map.get("n"), this.file, lineNumber, start, end);
            }
            Object real = map.get("real");
            Object imag = map.get("imag");
            if (real instanceof String) {
                if (real.equals("Infinity")) {
                    real = Double.POSITIVE_INFINITY;
                } else if (real.equals("-Infinity")) {
                    real = Double.NEGATIVE_INFINITY;
                }
            }
            if (imag instanceof String) {
                if (imag.equals("Infinity")) {
                    imag = Double.POSITIVE_INFINITY;
                } else if (real.equals("-Infinity")) {
                    imag = Double.NEGATIVE_INFINITY;
                }
            }
            return new PyComplex(this.analyzer, (Double)real, (Double)imag, this.file, lineNumber, start, end);
        }
        if (type.equals("SetComp")) {
            Node elt = this.convert(map.get("elt"));
            List<Comprehension> generators = this.convertList(map.get("generators"));
            return new SetComp(this.analyzer, elt, generators, this.file, lineNumber, start, end);
        }
        if (type.equals("Pass")) {
            return new Pass(this.analyzer, this.file, lineNumber, start, end);
        }
        if (type.equals("Print")) {
            List<Node> values = this.convertList(map.get("values"));
            Node destination = this.convert(map.get("destination"));
            return new Print(this.analyzer, destination, values, this.file, lineNumber, start, end);
        }
        if (type.equals("Raise")) {
            Node exceptionType = this.convert(map.get("type"));
            Node inst = this.convert(map.get("inst"));
            Node tback = this.convert(map.get("tback"));
            return new Raise(this.analyzer, exceptionType, inst, tback, this.file, lineNumber, start, end);
        }
        if (type.equals("Repr")) {
            Node value = this.convert(map.get("value"));
            return new Repr(this.analyzer, value, this.file, lineNumber, start, end);
        }
        if (type.equals("Return")) {
            Node value = this.convert(map.get("value"));
            return new Return(this.analyzer, value, this.file, lineNumber, start, end);
        }
        if (type.equals("Await")) {
            Node value = this.convert(map.get("value"));
            return new Return(this.analyzer, value, this.file, lineNumber, start, end);
        }
        if (type.equals("Set")) {
            List<Node> elts = this.convertList(map.get("elts"));
            return new PySet(this.analyzer, elts, this.file, lineNumber, start, end);
        }
        if (type.equals("SetComp")) {
            Node elt = this.convert(map.get("elt"));
            List<Comprehension> generators = this.convertList(map.get("generators"));
            return new SetComp(this.analyzer, elt, generators, this.file, lineNumber, start, end);
        }
        if (type.equals("Slice")) {
            Node lower = this.convert(map.get("lower"));
            Node step = this.convert(map.get("step"));
            Node upper = this.convert(map.get("upper"));
            return new Slice(this.analyzer, lower, step, upper, this.file, lineNumber, start, end);
        }
        if (type.equals("ExtSlice")) {
            List<Node> dims = this.convertList(map.get("dims"));
            return new ExtSlice(this.analyzer, dims, this.file, lineNumber, start, end);
        }
        if (type.equals("Str")) {
            String s = (String)map.get("s");
            return new Str(this.analyzer, s, this.file, lineNumber, start, end);
        }
        if (type.equals("Subscript")) {
            Node value = this.convert(map.get("value"));
            Node slice = this.convert(map.get("slice"));
            return new Subscript(this.analyzer, value, slice, this.file, lineNumber, start, end);
        }
        if (type.equals("Try")) {
            Block body = this.convertBlock(map.get("body"));
            Block orelse = this.convertBlock(map.get("orelse"));
            List<Handler> handlers = this.convertList(map.get("handlers"));
            Block finalbody = this.convertBlock(map.get("finalbody"));
            return new Try(this.analyzer, handlers, body, orelse, finalbody, this.file, lineNumber, start, end);
        }
        if (type.equals("TryExcept")) {
            Block body = this.convertBlock(map.get("body"));
            Block orelse = this.convertBlock(map.get("orelse"));
            List<Handler> handlers = this.convertList(map.get("handlers"));
            return new Try(this.analyzer, handlers, body, orelse, null, this.file, lineNumber, start, end);
        }
        if (type.equals("TryFinally")) {
            Block body = this.convertBlock(map.get("body"));
            Block finalbody = this.convertBlock(map.get("finalbody"));
            return new Try(this.analyzer, null, body, null, finalbody, this.file, lineNumber, start, end);
        }
        if (type.equals("Tuple")) {
            List<Node> elts = this.convertList(map.get("elts"));
            return new Tuple(this.analyzer, elts, this.file, lineNumber, start, end);
        }
        if (type.equals("UnaryOp")) {
            Op op = this.convertOp(map.get("op"));
            Node operand = this.convert(map.get("operand"));
            return new UnaryOp(this.analyzer, op, operand, this.file, lineNumber, start, end);
        }
        if (type.equals("While")) {
            Node test = this.convert(map.get("test"));
            Block body = this.convertBlock(map.get("body"));
            Block orelse = this.convertBlock(map.get("orelse"));
            return new While(this.analyzer, test, body, orelse, this.file, lineNumber, start, end);
        }
        if (type.equals("With") || type.equals("AsyncWith")) {
            ArrayList<Withitem> items = new ArrayList<Withitem>();
            Node context_expr = this.convert(map.get("context_expr"));
            Node optional_vars = this.convert(map.get("optional_vars"));
            Block body = this.convertBlock(map.get("body"));
            if (context_expr != null) {
                Withitem item = new Withitem(this.analyzer, context_expr, optional_vars, this.file, lineNumber, -1, -1);
                items.add(item);
            } else {
                List itemsMap = (List)map.get("items");
                for (Map m : itemsMap) {
                    context_expr = this.convert(m.get("context_expr"));
                    optional_vars = this.convert(m.get("optional_vars"));
                    Withitem item = new Withitem(this.analyzer, context_expr, optional_vars, this.file, lineNumber, -1, -1);
                    items.add(item);
                }
            }
            boolean isAsync = type.equals("AsyncWith");
            return new With(this.analyzer, items, body, this.file, isAsync, lineNumber, start, end);
        }
        if (type.equals("Yield")) {
            Node value = this.convert(map.get("value"));
            return new Yield(this.analyzer, value, this.file, lineNumber, start, end);
        }
        if (type.equals("YieldFrom")) {
            Node value = this.convert(map.get("value"));
            return new Yield(this.analyzer, value, this.file, lineNumber, start, end);
        }
        Utils.msg("\n[Please Report]: unexpected ast node: " + map.get("type"));
        return new Unsupported(this.analyzer, this.file, lineNumber, start, end);
    }

    @Nullable
    private <T> List<T> convertList(@Nullable Object o) {
        if (o == null) {
            return null;
        }
        List in = (List)o;
        ArrayList<Node> out = new ArrayList<Node>();
        for (Map m : in) {
            Node n = this.convert(m);
            if (n == null) continue;
            out.add(n);
        }
        return out;
    }

    private void locateNames(List<Alias> names, int start) {
        for (Alias a : names) {
            Name first = a.name.get(0);
            first.start = start = this.content.indexOf(first.id, start);
            start = first.end = start + first.id.length();
            if (a.asname == null) continue;
            a.asname.start = start = this.content.indexOf(a.asname.id, start);
            a.asname.end = start + a.asname.id.length();
            a.asname.setFile(this.file);
            start = a.asname.end;
        }
    }

    @Nullable
    private List<Node> convertListNode(@Nullable Object o) {
        if (o == null) {
            return null;
        }
        List in = (List)o;
        ArrayList<Node> out = new ArrayList<Node>();
        for (Map m : in) {
            Node n = this.convert(m);
            if (n == null) continue;
            out.add(n);
        }
        return out;
    }

    @Nullable
    private Block convertBlock(@Nullable Object o) {
        if (o == null) {
            return null;
        }
        List<Node> body = this.convertListNode(o);
        if (body == null || body.isEmpty()) {
            return null;
        }
        return new Block(this.analyzer, body, this.file, 0, 0, 0);
    }

    @Nullable
    private List<Op> convertListOp(@Nullable Object o) {
        if (o == null) {
            return null;
        }
        List in = (List)o;
        ArrayList<Op> out = new ArrayList<Op>();
        for (Map m : in) {
            Op n = this.convertOp(m);
            if (n == null) continue;
            out.add(n);
        }
        return out;
    }

    public Op convertOp(Object map) {
        String type = (String)((Map)map).get("type");
        if (type.equals("Add") || type.equals("UAdd")) {
            return Op.Add;
        }
        if (type.equals("Sub") || type.equals("USub")) {
            return Op.Sub;
        }
        if (type.equals("Mult")) {
            return Op.Mul;
        }
        if (type.equals("MatMult")) {
            return Op.MatMult;
        }
        if (type.equals("Div")) {
            return Op.Div;
        }
        if (type.equals("Pow")) {
            return Op.Pow;
        }
        if (type.equals("Eq")) {
            return Op.Equal;
        }
        if (type.equals("Is")) {
            return Op.Eq;
        }
        if (type.equals("Lt")) {
            return Op.Lt;
        }
        if (type.equals("Gt")) {
            return Op.Gt;
        }
        if (type.equals("BitAnd")) {
            return Op.BitAnd;
        }
        if (type.equals("BitOr")) {
            return Op.BitOr;
        }
        if (type.equals("BitXor")) {
            return Op.BitXor;
        }
        if (type.equals("In")) {
            return Op.In;
        }
        if (type.equals("LShift")) {
            return Op.LShift;
        }
        if (type.equals("FloorDiv")) {
            return Op.FloorDiv;
        }
        if (type.equals("Mod")) {
            return Op.Mod;
        }
        if (type.equals("RShift")) {
            return Op.RShift;
        }
        if (type.equals("Invert")) {
            return Op.Invert;
        }
        if (type.equals("And")) {
            return Op.And;
        }
        if (type.equals("Or")) {
            return Op.Or;
        }
        if (type.equals("Not")) {
            return Op.Not;
        }
        if (type.equals("NotEq")) {
            return Op.NotEqual;
        }
        if (type.equals("IsNot")) {
            return Op.NotEq;
        }
        if (type.equals("LtE")) {
            return Op.LtE;
        }
        if (type.equals("GtE")) {
            return Op.GtE;
        }
        if (type.equals("NotIn")) {
            return Op.NotIn;
        }
        Utils.msg("[please report] unsupported operator: " + type);
        return Op.Unsupported;
    }

    @NotNull
    List<Name> segmentQname(@NotNull String qname, int lineNumber, int start, boolean hasLoc) {
        ArrayList<Name> result = new ArrayList<Name>();
        for (int i = 0; i < qname.length(); ++i) {
            String name = "";
            while (Character.isSpaceChar(qname.charAt(i))) {
                ++i;
            }
            int nameStart = i;
            while (i < qname.length() && (Character.isJavaIdentifierPart(qname.charAt(i)) || qname.charAt(i) == '*') && qname.charAt(i) != '.') {
                name = name + qname.charAt(i);
                ++i;
            }
            int nameStop = i;
            int nstart = hasLoc ? start + nameStart : -1;
            int nstop = hasLoc ? start + nameStop : -1;
            result.add(new Name(this.analyzer, name, this.file, lineNumber, nstart, nstop));
        }
        return result;
    }

    @NotNull
    public Node parseFile(Path filename) throws IOException, PythonSyntaxErrorException {
        this.file = filename;
        this.content = Utils.readFile(filename);
        try {
            return this.parseFileInner(filename, PythonProcesses.Version.PYTHON2);
        }
        catch (PythonSyntaxErrorException e) {
            LOGGER.debug("Unable to parse {} with python2; trying python 3", (Object)filename, (Object)e);
            return this.parseFileInner(filename, PythonProcesses.Version.PYTHON3);
        }
    }

    @NotNull
    public Node parseFileInner(Path filename, PythonProcesses.Version version) throws IOException, PythonSyntaxErrorException {
        if (!this.pythonProcesses.isPythonAvailable(version)) {
            throw new IOException(String.format("Unable to parse %s, %s is unavailable", new Object[]{filename, version}));
        }
        this.cleanTemp();
        Map<String, Object> raw = this.pythonProcesses.parseFile(filename, version);
        this.cleanTemp();
        Node result = this.convert(raw);
        if (result == null) {
            throw new RuntimeException("Could not convert raw JSON structure to Node");
        }
        return result;
    }

    private void cleanTemp() throws IOException {
        if (Files.exists(this.exchangeFile, new LinkOption[0])) {
            Files.delete(this.exchangeFile);
        }
        if (Files.exists(this.endMark, new LinkOption[0])) {
            Files.delete(this.endMark);
        }
    }
}

