/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.pysonar;

import com.google.common.base.Joiner;
import com.sourceclear.methods.MethodInfo;
import com.sourceclear.methods.MethodInfoImpl;
import com.sourceclear.pysonar.Binding;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jetbrains.annotations.NotNull;

public class Utils {
    static final String suffix = ".py";
    private static final String pattern = "*.py";
    private static final PathMatcher pythonPathMatcher = FileSystems.getDefault().getPathMatcher("glob:*.py");
    public static final Charset UTF_8 = StandardCharsets.UTF_8;

    static String baseQname(String qname) {
        if (qname == null || qname.isEmpty()) {
            return "";
        }
        int index = qname.lastIndexOf(".");
        if (index == -1) {
            return "";
        }
        return qname.substring(index + 1);
    }

    @NotNull
    static String moduleQname(@NotNull Path path) {
        Path init = Paths.get("__init__.py", new String[0]);
        boolean isInitPy = path.endsWith(init);
        String filename = path.toString();
        if (isInitPy) {
            filename = path.getParent().toString();
        } else if (Utils.isPythonFile(path.getFileName())) {
            int length = path.toString().length();
            filename = path.toString().substring(0, length - suffix.length());
        }
        return filename.replace(".", "%20").replace('/', '.').replace('\\', '.');
    }

    public static String moduleName(Path path) {
        File f = path.toFile();
        String name = f.getName();
        if (name.equals("__init__.py")) {
            return f.getParentFile().getName();
        }
        if (name.endsWith(suffix)) {
            return name.substring(0, name.length() - suffix.length());
        }
        return name;
    }

    @NotNull
    static List<String> splitQname(String qualifiedName) {
        String[] temp = qualifiedName.split("\\.");
        return Arrays.asList(Arrays.copyOfRange(temp, 1, temp.length));
    }

    @NotNull
    static String joinQname(List<String> names) {
        return "." + Joiner.on((String)".").join(names);
    }

    @NotNull
    public static String getQualifiedModuleName(Path projectDir, Path sourceFile) {
        return Utils.relativizeQname(projectDir, Utils.moduleQname(sourceFile));
    }

    @NotNull
    static String readFile(@NotNull Path path) throws IOException {
        byte[] content = Files.readAllBytes(path);
        return new String(content, UTF_8);
    }

    static String escapeWindowsPath(String path) {
        return path.replace("\\", "\\\\");
    }

    public static void msg(String m) {
    }

    static List<List<Binding>> correlateBindings(List<Binding> bindings) {
        HashMap bdHash = new HashMap();
        for (Binding b : bindings) {
            int hash = b.hashCode();
            if (!bdHash.containsKey(hash)) {
                bdHash.put(hash, new ArrayList());
            }
            List bs = (List)bdHash.get(hash);
            bs.add(b);
        }
        return new ArrayList<List<Binding>>(bdHash.values());
    }

    public static <P> P first(@NotNull Collection<P> collection) {
        if (collection.isEmpty()) {
            throw new IllegalArgumentException("Collection is empty");
        }
        return collection.iterator().next();
    }

    static boolean isPythonFile(Path file) {
        return pythonPathMatcher.matches(file);
    }

    static MethodInfo makeMethodInfo(String moduleName, String className, String methodName) {
        return new MethodInfoImpl(moduleName, className, methodName, null);
    }

    @NotNull
    static String relativizeQname(Path projectDir, String path) {
        String projectQname = Utils.moduleQname(projectDir);
        if (path.startsWith(projectQname)) {
            return path.substring(projectQname.length());
        }
        return path;
    }

    public static void unzipInputStream(InputStream inputStream, Path destinationDirectory) throws IOException {
        try (ZipInputStream zipInputStream = new ZipInputStream(inputStream);){
            ZipEntry entry;
            while ((entry = zipInputStream.getNextEntry()) != null) {
                Path path = destinationDirectory.resolve(entry.getName());
                if (path.normalize().startsWith(destinationDirectory)) {
                    Files.createDirectories(path.getParent(), new FileAttribute[0]);
                    Files.copy(zipInputStream, path, new CopyOption[0]);
                    continue;
                }
                throw new IllegalArgumentException(String.format("Bad zip entry: %s", entry.getName()));
            }
        }
    }
}

