/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.pysonar.types;

import com.sourceclear.pysonar.Analyzer;
import com.sourceclear.pysonar.State;
import com.sourceclear.pysonar.ast.FunctionDef;
import com.sourceclear.pysonar.hash.MyHashMap;
import com.sourceclear.pysonar.types.ClassType;
import com.sourceclear.pysonar.types.ListType;
import com.sourceclear.pysonar.types.TupleType;
import com.sourceclear.pysonar.types.Type;
import com.sourceclear.pysonar.types.TypeVisitor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FunType
extends Type {
    private static final int MAX_ARROWS = 10;
    @NotNull
    public Map<Type, Type> arrows = new MyHashMap<Type, Type>();
    public FunctionDef func;
    @Nullable
    public ClassType cls = null;
    public State env;
    @Nullable
    public Type selfType;
    public List<Type> defaultTypes;

    public FunType(Analyzer analyzer) {
        super(analyzer);
    }

    public FunType(Analyzer analyzer, FunctionDef func, State env) {
        super(analyzer);
        this.func = func;
        this.env = env;
    }

    public FunType(Analyzer analyzer, Type from, Type to) {
        super(analyzer);
        this.addMapping(from, to);
        this.table.addSuper(analyzer.builtins.BaseFunction.table);
        this.table.setPath(analyzer.builtins.BaseFunction.table.path);
    }

    public void addMapping(Type from, Type to) {
        if (this.arrows.size() < 10) {
            this.arrows.put(from, to);
        }
    }

    @Nullable
    public Type getMapping(@NotNull Type from) {
        return this.arrows.get(from);
    }

    public boolean oversized() {
        return this.arrows.size() >= 10;
    }

    public Type getReturnType() {
        if (!this.arrows.isEmpty()) {
            return this.arrows.values().iterator().next();
        }
        return this.analyzer.TYPE_UNKNOWN;
    }

    public void setCls(ClassType cls) {
        this.cls = cls;
    }

    public void setSelfType(Type selfType) {
        this.selfType = selfType;
    }

    public void setDefaultTypes(List<Type> defaultTypes) {
        this.defaultTypes = defaultTypes;
    }

    @Override
    public boolean typeEquals(Object other) {
        if (other instanceof FunType) {
            FunType fo = (FunType)other;
            return fo.table.path.equals(this.table.path) || this == other;
        }
        return false;
    }

    public int hashCode() {
        return "FunType".hashCode();
    }

    private boolean subsumed(Type type1, Type type2) {
        return this.subsumedInner(type1, type2);
    }

    private boolean subsumedInner(Type type1, Type type2) {
        if (this.analyzer.state.typeStack.contains(type1, type2)) {
            return true;
        }
        if (type1.isUnknownType() || type1 == this.analyzer.TYPE_NONE || type1.equals(type2)) {
            return true;
        }
        if (type1 instanceof TupleType && type2 instanceof TupleType) {
            List<Type> elems1 = ((TupleType)type1).eltTypes;
            List<Type> elems2 = ((TupleType)type2).eltTypes;
            if (elems1.size() == elems2.size()) {
                for (int i = 0; i < elems1.size(); ++i) {
                    if (this.subsumedInner(elems1.get(i), elems2.get(i))) continue;
                    return false;
                }
            }
            return true;
        }
        if (type1 instanceof ListType && type2 instanceof ListType) {
            return this.subsumedInner(((ListType)type1).toTupleType(), ((ListType)type2).toTupleType());
        }
        return false;
    }

    private Map<Type, Type> compressArrows(Map<Type, Type> arrows) {
        HashMap<Type, Type> ret = new HashMap<Type, Type>();
        for (Map.Entry<Type, Type> e1 : arrows.entrySet()) {
            boolean subsumed = false;
            for (Map.Entry<Type, Type> e2 : arrows.entrySet()) {
                if (e1 == e2 || !this.subsumed(e1.getKey(), e2.getKey())) continue;
                subsumed = true;
                break;
            }
            if (subsumed) continue;
            ret.put(e1.getKey(), e1.getValue());
        }
        return ret;
    }

    private TupleType simplifySelf(TupleType from) {
        TupleType simplified = new TupleType(this.analyzer);
        if (from.eltTypes.size() > 0) {
            if (this.cls != null) {
                simplified.add(this.cls.getCanon());
            } else {
                simplified.add(from.get(0));
            }
        }
        for (int i = 1; i < from.eltTypes.size(); ++i) {
            simplified.add(from.get(i));
        }
        return simplified;
    }

    @Override
    protected String printType(@NotNull Type.CyclicTypeRecorder ctr) {
        if (this.arrows.isEmpty()) {
            return "? -> ?";
        }
        StringBuilder sb = new StringBuilder();
        Integer num = ctr.visit(this);
        if (num != null) {
            sb.append("#").append(num);
        } else {
            int newNum = ctr.push(this);
            int i = 0;
            HashSet<String> seen = new HashSet<String>();
            for (Map.Entry<Type, Type> e : this.arrows.entrySet()) {
                Type from = e.getKey();
                String as = from.printType(ctr) + " -> " + e.getValue().printType(ctr);
                if (!seen.contains(as)) {
                    if (i != 0) {
                        sb.append(" \u2227 ");
                    }
                    sb.append(as);
                    seen.add(as);
                }
                ++i;
            }
            if (ctr.isUsed(this)) {
                sb.append("=#").append(newNum).append(": ");
            }
            ctr.pop(this);
        }
        return sb.toString();
    }

    @Override
    public <T> T accept(TypeVisitor<T> visitor2) {
        return visitor2.visit(this);
    }
}

