/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.pysonar.types;

import com.sourceclear.pysonar.Analyzer;
import com.sourceclear.pysonar.types.Type;
import com.sourceclear.pysonar.types.TypeVisitor;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnionType
extends Type {
    public Set<Type> types = new HashSet<Type>();

    public UnionType(Analyzer analyzer) {
        super(analyzer);
    }

    public UnionType(Analyzer analyzer, Type ... initialTypes) {
        this(analyzer);
        for (Type nt : initialTypes) {
            this.addType(nt);
        }
    }

    public boolean isEmpty() {
        return this.types.isEmpty();
    }

    public static boolean contains(Type t1, Type t2) {
        if (t1 instanceof UnionType) {
            return ((UnionType)t1).contains(t2);
        }
        return t1.equals(t2);
    }

    public static Type remove(Analyzer analyzer, Type t1, Type t2) {
        if (t1 instanceof UnionType) {
            HashSet<Type> types = new HashSet<Type>(((UnionType)t1).types);
            types.remove(t2);
            return analyzer.newUnion(types);
        }
        if (t1 != analyzer.TYPE_CONT && t1 == t2) {
            return analyzer.TYPE_UNKNOWN;
        }
        return t1;
    }

    public void setTypes(Set<Type> types) {
        this.types = types;
    }

    public void addType(@NotNull Type t) {
        if (t instanceof UnionType) {
            this.types.addAll(((UnionType)t).types);
        } else {
            this.types.add(t);
        }
    }

    public boolean contains(Type t) {
        return this.types.contains(t);
    }

    @Nullable
    public Type firstUseful() {
        for (Type type : this.types) {
            if (type.isUnknownType() || type == this.analyzer.TYPE_NONE) continue;
            return type;
        }
        return null;
    }

    @Override
    public boolean typeEquals(Object other) {
        if (this.analyzer.state.typeStack.contains(this, other)) {
            return true;
        }
        if (other instanceof UnionType) {
            Set<Type> types1 = this.types;
            Set<Type> types2 = ((UnionType)other).types;
            if (types1.size() != types2.size()) {
                return false;
            }
            for (Type t : types2) {
                if (types1.contains(t)) continue;
                return false;
            }
            for (Type t : types1) {
                if (types2.contains(t)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return "UnionType".hashCode();
    }

    @Override
    protected String printType(@NotNull Type.CyclicTypeRecorder ctr) {
        StringBuilder sb = new StringBuilder();
        Integer num = ctr.visit(this);
        if (num != null) {
            sb.append("#").append(num);
        } else {
            int newNum = ctr.push(this);
            boolean first = true;
            sb.append("{");
            for (Type t : this.types) {
                if (!first) {
                    sb.append(" | ");
                }
                sb.append(t.printType(ctr));
                first = false;
            }
            if (ctr.isUsed(this)) {
                sb.append("=#").append(newNum).append(":");
            }
            sb.append("}");
            ctr.pop(this);
        }
        return sb.toString();
    }

    @Override
    public <T> T accept(TypeVisitor<T> visitor2) {
        return visitor2.visit(this);
    }
}

