/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.pysonar.types;

import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import org.jetbrains.annotations.NotNull;

public class Utils {
    private static final String suffix = ".py";
    private static final String pattern = "*.py";
    private static final PathMatcher pythonPathMatcher = FileSystems.getDefault().getPathMatcher("glob:*.py");

    @NotNull
    static String moduleQname(@NotNull Path path) {
        Path init = Paths.get("__init__.py", new String[0]);
        boolean isInitPy = path.endsWith(init);
        String filename = path.toString();
        if (isInitPy) {
            filename = path.getParent().toString();
        } else if (Utils.isPythonFile(path.getFileName())) {
            int length = path.toString().length();
            filename = path.toString().substring(0, length - suffix.length());
        }
        return filename.replace(".", "%20").replace('/', '.').replace('\\', '.');
    }

    private static boolean isPythonFile(Path file) {
        return pythonPathMatcher.matches(file);
    }
}

