/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.pysonar.visitor;

import com.sourceclear.methods.MethodInfo;
import com.sourceclear.methods.MethodInfoImpl;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Utils {
    private static final String suffix = ".py";
    private static final String pattern = "*.py";
    private static final PathMatcher pythonPathMatcher = FileSystems.getDefault().getPathMatcher("glob:*.py");

    static String baseQname(String qname) {
        if (qname == null || qname.isEmpty()) {
            return "";
        }
        int index = qname.lastIndexOf(".");
        if (index == -1) {
            return "";
        }
        return qname.substring(index + 1);
    }

    static String getQnameParent(@Nullable String qname) {
        if (qname == null || qname.isEmpty()) {
            return "";
        }
        int index = qname.lastIndexOf(".");
        if (index == -1) {
            return "";
        }
        return qname.substring(0, index);
    }

    @NotNull
    static String moduleQname(@NotNull Path path) {
        Path init = Paths.get("__init__.py", new String[0]);
        boolean isInitPy = path.endsWith(init);
        String filename = path.toString();
        if (isInitPy) {
            filename = path.getParent().toString();
        } else if (Utils.isPythonFile(path.getFileName())) {
            int length = path.toString().length();
            filename = path.toString().substring(0, length - suffix.length());
        }
        return filename.replace(".", "%20").replace('/', '.').replace('\\', '.');
    }

    static MethodInfo makeMethodInfo(String moduleName, String className, String methodName) {
        return new MethodInfoImpl(moduleName, className, methodName, null);
    }

    @NotNull
    static String relativizeQname(Path projectDir, String path) {
        String projectQname = Utils.moduleQname(projectDir);
        if (path.startsWith(projectQname)) {
            return path.substring(projectQname.length());
        }
        return path;
    }

    private static boolean isPythonFile(Path file) {
        return pythonPathMatcher.matches(file);
    }
}

