/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.rubysonar;

import com.sourceclear.rubysonar.Binding;
import com.sourceclear.rubysonar.State;
import com.sourceclear.rubysonar.types.ClassType;
import com.sourceclear.rubysonar.types.FunType;
import com.sourceclear.rubysonar.types.HashType;
import com.sourceclear.rubysonar.types.InstanceType;
import com.sourceclear.rubysonar.types.IntType;
import com.sourceclear.rubysonar.types.ListType;
import com.sourceclear.rubysonar.types.TupleType;
import com.sourceclear.rubysonar.types.Type;
import com.sourceclear.rubysonar.types.Types;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jrubyparser.ast.NilNode;
import org.jrubyparser.lexer.yacc.SimpleSourcePosition;

public class Builtins {
    private static final NilNode nullNode = new NilNode(new SimpleSourcePosition("null", 0));
    private static final String PREVIOUS_EXCEPTION = "$!";

    public static ClassType initArrayClass(State state, Type elementType) {
        String arrayClassName = "Array";
        ClassType rubyArray = new ClassType(arrayClassName, state);
        state.insert(arrayClassName, nullNode, rubyArray, Binding.Kind.CLASS);
        rubyArray.getTable().setParent(state);
        Builtins.insertArrayMethods(rubyArray, elementType);
        return rubyArray;
    }

    public static ClassType initFixnumClass(State state, IntType intType) {
        String arrayClassName = "Fixnum";
        ClassType fixnum = new ClassType(arrayClassName, state);
        state.insert(arrayClassName, nullNode, fixnum, Binding.Kind.CLASS);
        fixnum.getTable().setParent(state);
        Builtins.insertFixnumMethods(fixnum, intType);
        return fixnum;
    }

    public static void insertFixnumMethods(Type fixnum, IntType intType) {
        Builtins.insertMethods(fixnum.getTable(), Builtins.fixnumMethods(intType));
    }

    public static void insertArrayMethods(Type rubyArray, Type elementType) {
        IntType i = new IntType(rubyArray.getTable().getGlobalTable());
        List<AbstractMap.SimpleEntry<String, Type>> methods = Arrays.asList(Builtins.fun("size", Builtins.args(new Type[0]), i), Builtins.fun("[]", Builtins.args(i), elementType), Builtins.fun("[]=", Builtins.args(i, Types.UNKNOWN), Types.UNKNOWN));
        Builtins.insertMethods(rubyArray.getTable(), methods);
    }

    public static ClassType initHashClass(State state, Type keyType, Type valueType) {
        ClassType rubyHash = new ClassType("Hash", state);
        state.insert("Hash", nullNode, rubyHash, Binding.Kind.CLASS);
        rubyHash.getTable().setParent(state);
        rubyHash.getTable().insert("keys", nullNode, new FunType(Builtins.args(new Type[0]), new ListType(keyType)), Binding.Kind.METHOD);
        rubyHash.getTable().insert("[]", nullNode, new FunType(Builtins.args(keyType), valueType), Binding.Kind.METHOD);
        return rubyHash;
    }

    static ClassType initStructClass(State state) {
        ClassType struct = new ClassType("Struct", state);
        state.insert("Struct", nullNode, struct, Binding.Kind.CLASS);
        struct.getTable().setParent(state);
        IntType intType = new IntType(state.getGlobalTable());
        ListType unknownArray = new ListType(state.getGlobalTable(), Types.UNKNOWN);
        Builtins.insertMethods(struct.getTable(), Arrays.asList(Builtins.fun("==", Builtins.args(Types.UNKNOWN), Types.BOOL), Builtins.fun("[]", Builtins.args(Types.UNKNOWN), Types.UNKNOWN), Builtins.fun("dig", Builtins.args(Types.UNKNOWN), Types.UNKNOWN), Builtins.fun("each", Builtins.args(Types.UNKNOWN), Types.UNKNOWN), Builtins.fun("each_pair", Builtins.args(Types.UNKNOWN), Types.UNKNOWN), Builtins.fun("eql?", Builtins.args(Types.UNKNOWN), Types.BOOL), Builtins.fun("hash", Builtins.args(new Type[0]), intType), Builtins.fun("inspect", Builtins.args(new Type[0]), Types.STR), Builtins.fun("length", Builtins.args(new Type[0]), intType), Builtins.fun("members", Builtins.args(new Type[0]), unknownArray), Builtins.fun("select", Builtins.args(new Type[0]), unknownArray), Builtins.fun("size", Builtins.args(new Type[0]), intType), Builtins.fun("to_a", Builtins.args(new Type[0]), unknownArray), Builtins.fun("to_h", Builtins.args(new Type[0]), new HashType(state.getGlobalTable(), Types.SYMBOL, Types.UNKNOWN)), Builtins.fun("to_s", Builtins.args(new Type[0]), Types.STR), Builtins.fun("values", Builtins.args(new Type[0]), unknownArray), Builtins.fun("values_at", Builtins.args(Types.UNKNOWN), unknownArray)));
        return struct;
    }

    static void initPredefinedGlobals(State globalTable) {
        ClassType exception = new ClassType("Exception", globalTable);
        Binding b = new Binding(nullNode, new InstanceType(exception), Binding.Kind.SCOPE);
        b.setQname(PREVIOUS_EXCEPTION);
        globalTable.update(PREVIOUS_EXCEPTION, b);
    }

    public static void insertMethods(State classTable, Collection<AbstractMap.SimpleEntry<String, Type>> methods) {
        for (AbstractMap.SimpleEntry<String, Type> method : methods) {
            String methodName = method.getKey();
            Type type = method.getValue();
            if (Builtins.isMonkeyPatched(classTable, methodName)) continue;
            classTable.insert(methodName, nullNode, type, Binding.Kind.METHOD);
        }
    }

    private static boolean isMonkeyPatched(State classTable, String methodName) {
        FunType funType;
        Type unifiedType;
        List<Binding> lookup = classTable.lookup(methodName);
        return lookup != null && (unifiedType = State.makeUnion(lookup)) instanceof FunType && (funType = (FunType)unifiedType).getMethodDefNode() != null;
    }

    private static TupleType args(Type ... types) {
        return new TupleType(types);
    }

    private static AbstractMap.SimpleEntry<String, Type> fun(String methodName, Type from, Type to) {
        return new AbstractMap.SimpleEntry<String, Type>(methodName, new FunType(from, to));
    }

    public static Collection<AbstractMap.SimpleEntry<String, Type>> fixnumMethods(IntType intType) {
        return Arrays.asList(Builtins.fun("+", Builtins.args(intType), intType), Builtins.fun("-", Builtins.args(intType), intType), Builtins.fun("*", Builtins.args(intType), intType), Builtins.fun("/", Builtins.args(intType), intType), Builtins.fun("==", Builtins.args(Types.UNKNOWN), Types.BOOL), Builtins.fun("===", Builtins.args(Types.UNKNOWN), Types.BOOL), Builtins.fun(">=", Builtins.args(Types.UNKNOWN), Types.BOOL), Builtins.fun("<", Builtins.args(Types.UNKNOWN), Types.BOOL), Builtins.fun("<=", Builtins.args(Types.UNKNOWN), Types.BOOL), Builtins.fun("times", Builtins.args(Types.UNKNOWN), intType));
    }
}

