/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.rubysonar;

import com.sourceclear.rubysonar.HashableDefnNode;
import com.sourceclear.rubysonar.HashableDefsNode;
import java.util.ArrayList;
import java.util.List;
import org.jrubyparser.ast.ArgsNode;
import org.jrubyparser.ast.ArgumentNode;
import org.jrubyparser.ast.BlockNode;
import org.jrubyparser.ast.CallNode;
import org.jrubyparser.ast.ClassNode;
import org.jrubyparser.ast.Colon2ConstNode;
import org.jrubyparser.ast.Colon3Node;
import org.jrubyparser.ast.ConstNode;
import org.jrubyparser.ast.DefnNode;
import org.jrubyparser.ast.DefsNode;
import org.jrubyparser.ast.EmptyArgsNode;
import org.jrubyparser.ast.InstAsgnNode;
import org.jrubyparser.ast.InstVarNode;
import org.jrubyparser.ast.IterNode;
import org.jrubyparser.ast.ListNode;
import org.jrubyparser.ast.LocalVarNode;
import org.jrubyparser.ast.ModuleNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.SClassNode;
import org.jrubyparser.lexer.yacc.ISourcePosition;

class CodeGenerator {
    private static final String RUBY_ATTRIBUTE_PREFIX = "@";
    private static final String MODULE_NAMESPACE = "RubySonar";

    CodeGenerator() {
    }

    static List<DefsNode> sClassNodeToDefsNodes(SClassNode sClassNode) {
        ArrayList<DefsNode> defsNodes = new ArrayList<DefsNode>();
        Node receiverNode = sClassNode.getReceiverNode();
        for (Node node : sClassNode.getBodyNode().childNodes()) {
            if (!(node instanceof DefnNode)) continue;
            DefnNode defnNode = (DefnNode)node;
            HashableDefsNode defsNode = new HashableDefsNode(defnNode.getPosition(), receiverNode, defnNode.getName(), defnNode.getArgsNode(), defnNode.getScope(), defnNode.getBodyNode(), defnNode.getEndLine());
            defsNodes.add(defsNode);
        }
        return defsNodes;
    }

    static DefnNode generateWriterMethod(String attrName, ISourcePosition position) {
        String argName = "value";
        return new HashableDefnNode(position, CodeGenerator.toWriterMethodName(attrName), new ArgsNode(position, new ListNode(position, new ArgumentNode(position, "value")), null, null, null, null, null, null), null, new InstAsgnNode(position, CodeGenerator.toInstanceAttributeName(attrName), new LocalVarNode(position, 0, "value")), position.getLine());
    }

    private static String toWriterMethodName(String attrName) {
        return attrName + "=";
    }

    private static String toInstanceAttributeName(String attrName) {
        return RUBY_ATTRIBUTE_PREFIX + attrName;
    }

    static DefnNode generateReaderMethod(String attrName, ISourcePosition position) {
        return new HashableDefnNode(position, attrName, new ArgsNode(position, null, null, null, null, null, null, null), null, new InstVarNode(position, CodeGenerator.toInstanceAttributeName(attrName)), position.getLine());
    }

    static ModuleNode generateLambdaClass(String className, ISourcePosition position, IterNode lambdaNode) {
        HashableDefnNode callMethod = new HashableDefnNode(position, "call", lambdaNode.getArgsNode(), lambdaNode.getScope(), lambdaNode.getBodyNode(), lambdaNode.getEndLine());
        HashableDefnNode squareBracketsMethod = new HashableDefnNode(position, "[]", lambdaNode.getArgsNode(), lambdaNode.getScope(), lambdaNode.getBodyNode(), lambdaNode.getEndLine());
        BlockNode bodyNode = new BlockNode(position);
        bodyNode.add(callMethod);
        bodyNode.add(squareBracketsMethod);
        ClassNode classNode = new ClassNode(position, new Colon3Node(position, className), lambdaNode.getScope(), bodyNode, null);
        return new ModuleNode(position, new Colon3Node(position, MODULE_NAMESPACE), lambdaNode.getScope(), classNode);
    }

    static CallNode generateLambdaNewCallNode(String className, ISourcePosition position) {
        Colon2ConstNode receiver = new Colon2ConstNode(position, new ConstNode(position, MODULE_NAMESPACE), className);
        return new CallNode(position, receiver, "new", new EmptyArgsNode(), null);
    }

    static CallNode generateCallToLocalReceiverNode(String receiverName, String message, Node argsNode, IterNode iterNode, ISourcePosition position) {
        return new CallNode(position, new LocalVarNode(position, 0, receiverName), message, argsNode, iterNode);
    }
}

