/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.scm.core;

import com.google.common.collect.ImmutableMap;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class SCMRepository {
    private final String id;
    private final String name;
    private final String fullName;
    private final ImmutableMap<String, String> urls;
    private final String primaryBranch;
    private final String language;
    private final String description;
    private final Boolean isPrivate;
    private final Date createdAt;
    private final Date updatedAt;
    private final Date pushedAt;
    private final int stargazers;
    private final int forks;
    private final int watchers;
    private final Boolean admin;

    private SCMRepository(Builder builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.fullName = builder.fullName;
        this.urls = ImmutableMap.copyOf((Map)builder.urls);
        this.primaryBranch = builder.primaryBranch;
        this.language = builder.language;
        this.description = builder.description;
        this.isPrivate = builder.isPrivate;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.pushedAt = builder.pushedAt;
        this.stargazers = builder.stargazers;
        this.forks = builder.forks;
        this.watchers = builder.watchers;
        this.admin = builder.admin;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return this.fullName;
    }

    public ImmutableMap<String, String> getUrls() {
        return this.urls;
    }

    public String getPrimaryBranch() {
        return this.primaryBranch;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getDescription() {
        return this.description;
    }

    public Boolean isPrivate() {
        return this.isPrivate;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public Date getPushedAt() {
        return this.pushedAt;
    }

    public int getStargazers() {
        return this.stargazers;
    }

    public int getForks() {
        return this.forks;
    }

    public int getWatchers() {
        return this.watchers;
    }

    public Boolean isAdmin() {
        return this.admin;
    }

    public static class Builder {
        private String id;
        private String name;
        private String fullName;
        private Map<String, String> urls = new HashMap<String, String>();
        private String primaryBranch;
        private String language;
        private String description;
        private Boolean isPrivate;
        private Date createdAt;
        private Date updatedAt;
        private Date pushedAt;
        private int stargazers;
        private int forks;
        private int watchers;
        private Boolean admin;

        public Builder withId(String id) {
            this.id = id;
            return this;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withFullName(String fullName) {
            this.fullName = fullName;
            return this;
        }

        public Builder withUrl(String type, String url) {
            this.urls.put(type, url);
            return this;
        }

        public Builder withPrimaryBranch(String primaryBranch) {
            this.primaryBranch = primaryBranch;
            return this;
        }

        public Builder withLanguage(String language) {
            this.language = language;
            return this;
        }

        public Builder withDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder withIsPrivate(Boolean isPrivate) {
            this.isPrivate = isPrivate;
            return this;
        }

        public Builder withCreatedAt(Date createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder withUpdatedAt(Date updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder withPushedAt(Date pushedAt) {
            this.pushedAt = pushedAt;
            return this;
        }

        public Builder withStargazers(int stargazers) {
            this.stargazers = stargazers;
            return this;
        }

        public Builder withForks(int forks) {
            this.forks = forks;
            return this;
        }

        public Builder withWatchers(int watchers) {
            this.watchers = watchers;
            return this;
        }

        public Builder withAdmin(Boolean admin) {
            this.admin = admin;
            return this;
        }

        public SCMRepository build() {
            return new SCMRepository(this);
        }
    }
}

