/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.util.io;

import com.sourceclear.api.data.evidence.CoordinateType;
import com.sourceclear.api.data.evidence.Coordinates;
import com.sourceclear.api.data.evidence.Evidence;
import com.sourceclear.api.data.evidence.EvidencePath;
import com.sourceclear.api.data.evidence.EvidenceType;
import com.sourceclear.bytecode.Util;
import com.sourceclear.util.io.BoundedSortedSet;
import com.srcclr.sdk.Coords;
import com.srcclr.sdk.LibraryGraph;
import com.veracode.security.logging.SecureLogger;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public class EvidenceUtils {
    static final int MAX_PATHS = 5;
    private static final SecureLogger LOGGER = SecureLogger.getLogger(EvidenceUtils.class);

    @Nonnull
    public static Collection<Evidence> evidenceFromLibraryGraphs(@Nonnull Collection<LibraryGraph> libraryGraphs) {
        return EvidenceUtils.evidenceFromLibraryGraphs(libraryGraphs, false);
    }

    @Nonnull
    public static Collection<Evidence> evidenceFromLibraryGraphs(@Nonnull Collection<LibraryGraph> libraryGraphs, boolean noDependencyGraph) {
        HashMap<CustomCoord, Evidence.Builder> coordEvidenceMap = new HashMap<CustomCoord, Evidence.Builder>();
        HashMap<CustomCoord, BoundedSortedSet<EvidencePath>> coordEvidencePaths = new HashMap<CustomCoord, BoundedSortedSet<EvidencePath>>();
        HashMap<String, Evidence.Builder> fileBasedEvidenceBySha2 = new HashMap<String, Evidence.Builder>();
        HashSet<Evidence.Builder> filedBasedEvidenceWithoutSha2 = new HashSet<Evidence.Builder>();
        for (LibraryGraph libraryGraph : libraryGraphs) {
            EvidenceType evidenceType;
            for (LibraryGraph direct : libraryGraph.getDirects()) {
                if (noDependencyGraph) {
                    EvidenceUtils.buildEvidenceWithoutDependencyPath(coordEvidenceMap, direct, new HashSet<CustomCoord>());
                    continue;
                }
                EvidenceUtils.buildEvidenceWithDependencyPaths(coordEvidenceMap, direct, coordEvidencePaths, Collections.emptyList());
            }
            String graphFilename = libraryGraph.getFilename();
            String bytecodeHash = libraryGraph.getBytecodeHash();
            String sha2 = libraryGraph.getSha2();
            String sha1 = libraryGraph.getSha1();
            if (libraryGraph.getCoords() != null || graphFilename == null) continue;
            if (Util.hasJarExtension(new File(graphFilename)) && sha2 != null && sha1 != null) {
                evidenceType = EvidenceType.JAR;
            } else if (graphFilename.endsWith(".dll") && sha2 != null && sha1 != null) {
                evidenceType = EvidenceType.DLL;
            } else {
                if (bytecodeHash == null) continue;
                evidenceType = EvidenceType.BYTECODE;
            }
            if (sha2 != null) {
                Evidence.Builder evidenceBuilder = fileBasedEvidenceBySha2.computeIfAbsent(sha2, key -> new Evidence.Builder().withByteCodeHash(bytecodeHash).withSha1(sha1).withSha2(sha2).withEvidenceType(evidenceType));
                evidenceBuilder.withEvidencePath(new EvidencePath(graphFilename, null));
                continue;
            }
            LOGGER.debug("Found file-based graph with null sha2: filename={}", (Object)graphFilename);
            filedBasedEvidenceWithoutSha2.add(new Evidence.Builder().withEvidencePath(new EvidencePath(graphFilename, null)).withByteCodeHash(bytecodeHash).withSha1(sha1).withEvidenceType(evidenceType));
        }
        if (!coordEvidencePaths.isEmpty()) {
            for (Map.Entry entry : coordEvidenceMap.entrySet()) {
                CustomCoord customCoord = (CustomCoord)entry.getKey();
                Evidence.Builder evidenceBuilder = (Evidence.Builder)entry.getValue();
                BoundedSortedSet evidencePaths = coordEvidencePaths.getOrDefault(customCoord, BoundedSortedSet.empty());
                evidenceBuilder.withEvidencePaths(evidencePaths.toList());
            }
        }
        return Stream.concat(coordEvidenceMap.values().stream(), Stream.concat(fileBasedEvidenceBySha2.values().stream(), filedBasedEvidenceWithoutSha2.stream())).map(Evidence.Builder::build).collect(Collectors.toSet());
    }

    private static void buildEvidenceWithDependencyPaths(Map<CustomCoord, Evidence.Builder> map, LibraryGraph graph, Map<CustomCoord, BoundedSortedSet<EvidencePath>> coordEvidencePaths, List<Coordinates> coordPath) {
        Coords coords = graph.getCoords();
        if (coords == null) {
            LOGGER.warn("Found null coordinates for a LibraryGraph!");
            return;
        }
        CustomCoord customCoord = new CustomCoord(coords);
        map.computeIfAbsent(customCoord, unused -> EvidenceUtils.buildEvidenceFromGraph(graph));
        EvidencePath evidencePath = new EvidencePath(graph.getFilename(), graph.getLineNumber(), coordPath);
        BoundedSortedSet evidencePaths = coordEvidencePaths.computeIfAbsent(customCoord, unused -> new BoundedSortedSet(5));
        evidencePaths.add(evidencePath);
        Coordinates apiCoordinates = EvidenceUtils.apiCoordinatesFromSDKCoords(coords);
        ArrayList<Coordinates> appendedCoordPath = new ArrayList<Coordinates>(coordPath);
        appendedCoordPath.add(apiCoordinates);
        for (LibraryGraph direct : graph.getDirects()) {
            EvidenceUtils.buildEvidenceWithDependencyPaths(map, direct, coordEvidencePaths, appendedCoordPath);
        }
    }

    private static void buildEvidenceWithoutDependencyPath(Map<CustomCoord, Evidence.Builder> map, LibraryGraph graph, Set<CustomCoord> seenCoords) {
        Coords coords = graph.getCoords();
        if (coords == null) {
            LOGGER.warn("Found null coordinates for a LibraryGraph!");
            return;
        }
        CustomCoord customCoord = new CustomCoord(coords);
        if (seenCoords.contains(customCoord)) {
            return;
        }
        seenCoords.add(customCoord);
        Evidence.Builder builder = map.computeIfAbsent(customCoord, unused -> EvidenceUtils.buildEvidenceFromGraph(graph));
        EvidencePath evidencePath = new EvidencePath(graph.getFilename(), graph.getLineNumber());
        builder.withEvidencePath(evidencePath);
        for (LibraryGraph direct : graph.getDirects()) {
            EvidenceUtils.buildEvidenceWithoutDependencyPath(map, direct, seenCoords);
        }
    }

    private static Evidence.Builder buildEvidenceFromGraph(LibraryGraph graph) {
        Evidence.Builder evidenceBuilder = new Evidence.Builder();
        Coords coords = graph.getCoords();
        Coordinates apiCoordinates = EvidenceUtils.apiCoordinatesFromSDKCoords(coords);
        evidenceBuilder.withCoordinates(apiCoordinates);
        if (coords.getCoordinateType() == com.srcclr.sdk.CoordinateType.SO) {
            evidenceBuilder.withEvidenceType(EvidenceType.SO).withSha2(graph.getSha2());
        } else if (coords.getCommitHash() != null) {
            evidenceBuilder.withCommitHash(coords.getCommitHash()).withEvidenceType(EvidenceType.COMMIT);
        } else {
            evidenceBuilder.withEvidenceType(EvidenceType.COORDINATES);
        }
        return evidenceBuilder;
    }

    private static Coordinates apiCoordinatesFromSDKCoords(Coords coords) {
        return new Coordinates.Builder().withCoordinateType(CoordinateType.valueOf(coords.getCoordinateType().name())).withCoordinates(coords.getCoordinate1(), coords.getCoordinate2()).withPlatform(coords.getPlatform()).withScope(coords.getScope()).withVersion(coords.getVersion()).build();
    }

    private EvidenceUtils() {
    }

    private static class CustomCoord {
        private final Coords coords;

        CustomCoord(Coords coords) {
            this.coords = coords;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CustomCoord)) {
                return false;
            }
            CustomCoord that = (CustomCoord)o;
            return Objects.equals(this.coords.getCoordinateType(), that.coords.getCoordinateType()) && Objects.equals(this.coords.getCoordinate1(), that.coords.getCoordinate1()) && Objects.equals(this.coords.getCoordinate2(), that.coords.getCoordinate2()) && Objects.equals(this.coords.getVersion(), that.coords.getVersion()) && Objects.equals(this.coords.getPlatform(), that.coords.getPlatform()) && Objects.equals(this.coords.getCommitHash(), that.coords.getCommitHash());
        }

        public int hashCode() {
            return Objects.hash(this.coords.getCoordinateType(), this.coords.getCoordinate1(), this.coords.getCoordinate2(), this.coords.getVersion(), this.coords.getPlatform(), this.coords.getCommitHash());
        }

        public String toString() {
            return "CustomCoord{coords=" + this.coords + '}';
        }
    }
}

