/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.util.security;

import java.nio.file.Path;
import java.nio.file.Paths;

public class SecurityUtils {
    public static boolean isSecureRelativePath(Path path) {
        return path.toAbsolutePath().normalize().equals(path.toAbsolutePath());
    }

    public static Path securePathsGet(String first, String ... more) {
        Path path = Paths.get(first, more);
        if (!SecurityUtils.isSecureRelativePath(path)) {
            throw new SecurityException(String.format("Potential directory traversal attack (CWE-73) detected in path: %s", path.toString()));
        }
        return path;
    }

    public static Path securePathsResolve(Path rootPath, String ... suppliedPaths) {
        if (rootPath == null || suppliedPaths == null || suppliedPaths.length == 0) {
            throw new IllegalArgumentException("no root path or supplied paths");
        }
        Path resolvedPath = rootPath;
        for (String suppliedPath : suppliedPaths) {
            resolvedPath = resolvedPath.resolve(suppliedPath);
        }
        if (!SecurityUtils.isSecureRelativePath(resolvedPath)) {
            throw new SecurityException(String.format("Potential directory traversal attack (CWE-73) detected in path: %s", resolvedPath.toString()));
        }
        return resolvedPath;
    }
}

