/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser;

import java.io.IOException;
import java.io.Reader;
import org.jrubyparser.ast.Node;
import org.jrubyparser.common.IRubyWarnings;
import org.jrubyparser.lexer.ByteListLexerSource;
import org.jrubyparser.lexer.yacc.ISourcePosition;
import org.jrubyparser.lexer.yacc.SyntaxException;
import org.jrubyparser.parser.ParserConfiguration;
import org.jrubyparser.parser.RubyParser;
import org.jrubyparser.parser.RubyParserResult;

public class Parser {
    private volatile long totalTime;
    private volatile int totalBytes;

    public long getTotalTime() {
        return this.totalTime;
    }

    public int getTotalBytes() {
        return this.totalBytes;
    }

    public Node parse(String file, Reader content, ParserConfiguration configuration) throws SyntaxException, IOException {
        long startTime = System.nanoTime();
        ByteListLexerSource lexerSource = ByteListLexerSource.getLexerSource(file, 0, content);
        RubyParser parser = new RubyParser(lexerSource, new NullWarnings());
        Node ast = null;
        try {
            RubyParserResult result = parser.parse(configuration);
            ast = result.getAST();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.totalTime += System.nanoTime() - startTime;
        this.totalBytes += lexerSource.getOffset();
        return ast;
    }

    public static class NullWarnings
    implements IRubyWarnings {
        @Override
        public boolean isVerbose() {
            return false;
        }

        @Override
        public void warn(IRubyWarnings.ID id, ISourcePosition position, String message) {
        }

        @Override
        public void warn(IRubyWarnings.ID id, String fileName, int lineNumber, String message) {
        }

        @Override
        public void warn(IRubyWarnings.ID id, String fileName, String message) {
        }

        @Override
        public void warn(IRubyWarnings.ID id, String message) {
        }

        @Override
        public void warning(IRubyWarnings.ID id, String message) {
        }

        @Override
        public void warning(IRubyWarnings.ID id, ISourcePosition position, String message) {
        }

        @Override
        public void warning(IRubyWarnings.ID id, String fileName, int lineNumber, String message) {
        }
    }
}

